/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.application.cms.tests.model;

import com.vdurmont.semver4j.Semver;
import java.time.LocalDateTime;
import java.util.Collections;
import java.util.UUID;
import junit.framework.TestCase;
import org.bson.Document;
import org.gcube.application.cms.tests.TokenSetter;
import org.gcube.application.geoportal.common.model.document.Project;
import org.gcube.application.geoportal.common.model.document.access.Access;
import org.gcube.application.geoportal.common.model.document.access.AccessPolicy;
import org.gcube.application.geoportal.common.model.document.accounting.AccountingInfo;
import org.gcube.application.geoportal.common.model.document.accounting.Context;
import org.gcube.application.geoportal.common.model.document.accounting.PublicationInfo;
import org.gcube.application.geoportal.common.model.document.accounting.User;
import org.gcube.application.geoportal.common.model.document.lifecycle.LifecycleInformation;
import org.gcube.application.geoportal.common.model.useCaseDescriptor.DataAccessPolicy;
import org.gcube.application.geoportal.common.model.useCaseDescriptor.HandlerDeclaration;
import org.gcube.application.geoportal.common.model.useCaseDescriptor.UseCaseDescriptor;
import org.gcube.application.geoportal.common.utils.tests.GCubeTest;
import org.junit.Assume;
import org.junit.BeforeClass;

public class BasicTests
extends GCubeTest {
    @BeforeClass
    public static void initContext() {
        Assume.assumeTrue((boolean)BasicTests.isTestInfrastructureEnabled());
        TokenSetter.set(BasicTests.getContext());
    }

    protected User getCurrentUser() {
        User u = new User();
        u.setUsername("fake-user");
        return u;
    }

    protected UseCaseDescriptor getUCD() {
        return BasicTests.initUCD(this.getContextObject(), this.getCurrentUser());
    }

    protected Document getBasicDocument() {
        return new Document();
    }

    protected Project getBasicProject() {
        return BasicTests.initProject(this.getBasicDocument(), this.getUCD(), this.getCurrentUser(), this.getContextObject());
    }

    protected Context getContextObject() {
        Context toReturn = new Context();
        toReturn.setName("My Fake Vre");
        toReturn.setId("FAKE-VRE");
        return toReturn;
    }

    protected PublicationInfo getCurrentInfo() {
        return BasicTests.initPublicationInfo(this.getUCD(), this.getContextObject(), this.getCurrentUser());
    }

    protected static PublicationInfo initPublicationInfo(UseCaseDescriptor ucd, Context ctx, User user) {
        PublicationInfo toReturn = new PublicationInfo();
        Access access = new Access();
        access.setLicense("");
        access.setPolicy(AccessPolicy.OPEN);
        toReturn.setAccess(access);
        toReturn.setCreationInfo(BasicTests.initAccountingInfo(ctx, user));
        return toReturn;
    }

    protected static AccountingInfo initAccountingInfo(Context ctx, User user) {
        AccountingInfo accInfo = new AccountingInfo();
        accInfo.setInstant(LocalDateTime.now());
        accInfo.setContext(ctx);
        accInfo.setUser(user);
        return accInfo;
    }

    protected static Project initProject(Document doc, UseCaseDescriptor ucd, User user, Context ctx) {
        Project p = new Project();
        p.setId(UUID.randomUUID().toString());
        p.setInfo(BasicTests.initPublicationInfo(ucd, ctx, user));
        p.setProfileID(ucd.getId());
        p.setProfileVersion(ucd.getVersion());
        p.setVersion(new Semver("1.0.0"));
        LifecycleInformation draftInfo = new LifecycleInformation().cleanState();
        draftInfo.setPhase("DRAFT");
        draftInfo.setLastOperationStatus(LifecycleInformation.Status.OK);
        p.setLifecycleInformation(draftInfo);
        return p;
    }

    protected static UseCaseDescriptor initUCD(Context ctx, User u) {
        UseCaseDescriptor ucd = new UseCaseDescriptor();
        ucd.setName("Test UCD");
        ucd.setId("test-ucd");
        ucd.setDescription("Just a test dummy profile");
        ucd.setCreationInfo(BasicTests.initAccountingInfo(ctx, u));
        ucd.setVersion(new Semver("1.0.0"));
        HandlerDeclaration h = new HandlerDeclaration();
        h.setType("LifecycleManagement");
        h.setId(UUID.randomUUID().toString());
        ucd.setHandlers(Collections.singletonList(h));
        DataAccessPolicy p = new DataAccessPolicy();
        p.setPolicy(new DataAccessPolicy.Policy());
        p.getPolicy().setRead(DataAccessPolicy.Policy.Type.any);
        p.getPolicy().setWrite(DataAccessPolicy.Policy.Type.any);
        ucd.setDataAccessPolicies(Collections.singletonList(p));
        return ucd;
    }

    public static void validate(Project doc) {
        TestCase.assertTrue((doc != null ? 1 : 0) != 0);
        TestCase.assertTrue((doc.getId() != null ? 1 : 0) != 0);
        TestCase.assertTrue((doc.getLifecycleInformation().getPhase() != null ? 1 : 0) != 0);
        TestCase.assertTrue((doc.getLifecycleInformation().getLastOperationStatus() != null ? 1 : 0) != 0);
        if (doc.getLifecycleInformation().getLastOperationStatus().equals((Object)LifecycleInformation.Status.ERROR)) {
            TestCase.assertTrue((doc.getLifecycleInformation().getErrorMessages().size() > 0 ? 1 : 0) != 0);
        }
        if (doc.getLifecycleInformation().getLastOperationStatus().equals((Object)LifecycleInformation.Status.WARNING)) {
            TestCase.assertTrue((doc.getLifecycleInformation().getWarningMessages().size() > 0 ? 1 : 0) != 0);
        }
        if (doc.getLifecycleInformation().getTriggeredEvents() != null) {
            doc.getLifecycleInformation().getTriggeredEvents().forEach(triggeredEvents -> {
                TestCase.assertTrue((triggeredEvents.getEvent() != null ? 1 : 0) != 0);
                TestCase.assertTrue((triggeredEvents.getLastOperationStatus() != null ? 1 : 0) != 0);
                if (triggeredEvents.getLastOperationStatus().equals((Object)LifecycleInformation.Status.ERROR)) {
                    TestCase.assertTrue((triggeredEvents.getErrorMessages().size() > 0 ? 1 : 0) != 0);
                }
                if (triggeredEvents.getLastOperationStatus().equals((Object)LifecycleInformation.Status.WARNING)) {
                    TestCase.assertTrue((triggeredEvents.getWarningMessages().size() > 0 ? 1 : 0) != 0);
                }
            });
        }
        TestCase.assertTrue((doc.getInfo() != null ? 1 : 0) != 0);
        TestCase.assertTrue((doc.getInfo().getCreationInfo() != null ? 1 : 0) != 0);
        TestCase.assertTrue((doc.getInfo().getCreationInfo().getContext() != null ? 1 : 0) != 0);
        TestCase.assertTrue((doc.getInfo().getCreationInfo().getContext().getId() != null ? 1 : 0) != 0);
        TestCase.assertTrue((doc.getInfo().getCreationInfo().getContext().getName() != null ? 1 : 0) != 0);
        TestCase.assertTrue((doc.getInfo().getCreationInfo().getInstant() != null ? 1 : 0) != 0);
        TestCase.assertTrue((doc.getInfo().getCreationInfo().getInstant() != null ? 1 : 0) != 0);
        TestCase.assertTrue((doc.getInfo().getCreationInfo().getUser() != null ? 1 : 0) != 0);
        TestCase.assertTrue((doc.getInfo().getCreationInfo().getUser().getUsername() != null ? 1 : 0) != 0);
        TestCase.assertTrue((doc.getTheDocument() != null ? 1 : 0) != 0);
    }
}

