/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.application.cms.implementations.utils;

import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.gcube.application.geoportal.common.model.document.accounting.AccountingInfo;
import org.gcube.application.geoportal.common.model.document.accounting.Context;
import org.gcube.common.authorization.library.provider.AccessTokenProvider;
import org.gcube.common.authorization.library.provider.SecurityTokenProvider;
import org.gcube.common.authorization.utils.manager.SecretManager;
import org.gcube.common.authorization.utils.manager.SecretManagerProvider;
import org.gcube.common.authorization.utils.user.User;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UserUtils {
    private static final Logger log = LoggerFactory.getLogger(UserUtils.class);
    public static List<String> DEFAULT_ROLES = new ArrayList<String>();

    public static AuthenticatedUser getCurrent() throws SecurityException {
        log.debug("Loading caller info..");
        SecretManager cm = SecretManagerProvider.instance.get();
        String context = cm.getContext();
        if (context == null) {
            throw new SecurityException("Cannot determine context");
        }
        HashSet<String> roles = new HashSet<String>();
        User user = cm.getUser();
        if (user == null) {
            log.warn("No user found in the session work, context is {}", (Object)context);
        } else {
            log.info("Identified caller {} in context {}", (Object)user.getUsername(), (Object)context);
            roles.addAll(user.getRoles());
        }
        AuthenticatedUser toReturn = new AuthenticatedUser(user, roles, AccessTokenProvider.instance.get(), SecurityTokenProvider.instance.get(), context);
        log.info("Current User is {} ", (Object)toReturn);
        return toReturn;
    }

    public static class AuthenticatedUser {
        private User user;
        private Set<String> roles;
        private String uma_token;
        private String gcube_token;
        private String context;

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("User [user=");
            builder.append(this.user);
            builder.append(", uma_token=");
            builder.append(this.uma_token == null ? this.uma_token : "***");
            builder.append(", gcube_token=");
            builder.append(this.gcube_token == null ? this.gcube_token : "***");
            builder.append(", roles=");
            builder.append(this.roles);
            builder.append(", context=");
            builder.append(this.context);
            builder.append("]");
            return builder.toString();
        }

        public AccountingInfo asInfo() {
            AccountingInfo info = new AccountingInfo();
            org.gcube.application.geoportal.common.model.document.accounting.User user = new org.gcube.application.geoportal.common.model.document.accounting.User();
            try {
                user.setUsername(this.getUser().getUsername());
                user.setRoles(this.roles);
            }
            catch (Exception e) {
                log.warn("Unable to determine user id, using FAKE", (Throwable)e);
                user.setUsername("FAKE");
                user.setRoles(new HashSet());
                user.getRoles().addAll(DEFAULT_ROLES);
            }
            info.setUser(user);
            info.setInstant(LocalDateTime.now());
            Context c = new Context();
            c.setId(this.context);
            c.setName(this.context.contains("/") ? this.context.substring(this.context.lastIndexOf("/")) : this.context);
            info.setContext(c);
            return info;
        }

        public AuthenticatedUser(User user, Set<String> roles, String uma_token, String gcube_token, String context) {
            this.user = user;
            this.roles = roles;
            this.uma_token = uma_token;
            this.gcube_token = gcube_token;
            this.context = context;
        }

        public User getUser() {
            return this.user;
        }

        public Set<String> getRoles() {
            return this.roles;
        }

        public String getUma_token() {
            return this.uma_token;
        }

        public String getGcube_token() {
            return this.gcube_token;
        }

        public String getContext() {
            return this.context;
        }
    }
}

