/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.application.cms.caches;

import java.time.LocalDateTime;
import java.time.temporal.TemporalAmount;
import java.util.concurrent.ConcurrentHashMap;
import lombok.NonNull;
import org.gcube.application.cms.caches.Cache;
import org.gcube.application.cms.caches.TTLObject;
import org.gcube.application.geoportal.common.model.rest.ConfigurationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class TimedMap<K, V>
implements Cache<K, V> {
    private static final Logger log = LoggerFactory.getLogger(TimedMap.class);
    protected ConcurrentHashMap<K, TTLObject<V>> scopeMap = new ConcurrentHashMap();
    protected TemporalAmount TTL = null;
    @NonNull
    protected String name;

    @Override
    public V get(K key) throws ConfigurationException {
        log.trace(this.name + " : obtaining object by  " + key);
        TTLObject<V> found = this.scopeMap.get(key);
        if (found == null) {
            log.debug(this.name + " : init object for key " + key);
            TTLObject<V> toPut = new TTLObject<V>(LocalDateTime.now(), this.retrieveObject(key));
            this.scopeMap.put(key, toPut);
            return toPut.getTheObject();
        }
        if (this.getTTL() != null) {
            if (found.getCreationTime().plus(this.getTTL()).isBefore(LocalDateTime.now())) {
                log.debug(this.name + " : elapsed TTL, disposing..");
                this.dispose(found.getTheObject());
                TTLObject<V> newer = new TTLObject<V>(LocalDateTime.now(), this.retrieveObject(key));
                this.scopeMap.put(key, newer);
                found = this.scopeMap.get(key);
            }
        } else {
            log.trace(this.name + " : TTL is null, never disposing..");
        }
        log.trace(this.name + "Returning {} ", found);
        return found.getTheObject();
    }

    protected abstract V retrieveObject(K var1) throws ConfigurationException;

    protected void dispose(V toDispose) {
    }

    public TimedMap(@NonNull String name) {
        if (name == null) {
            throw new NullPointerException("name is marked @NonNull but is null");
        }
        this.name = name;
    }

    public void setTTL(TemporalAmount TTL) {
        this.TTL = TTL;
    }

    public TemporalAmount getTTL() {
        return this.TTL;
    }
}

