/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.application.cms.serviceaccount;

import java.util.AbstractMap;
import java.util.Map;
import javax.ws.rs.InternalServerErrorException;
import org.gcube.application.cms.serviceaccount.IAMClientCredentials;
import org.gcube.application.cms.serviceaccount.IAMClientCredentialsReader;
import org.gcube.common.authorization.utils.manager.SecretManager;
import org.gcube.common.authorization.utils.manager.SecretManagerProvider;
import org.gcube.common.authorization.utils.secret.JWTSecret;
import org.gcube.common.authorization.utils.secret.Secret;
import org.gcube.common.keycloak.KeycloakClientFactory;
import org.gcube.common.keycloak.model.TokenResponse;
import org.gcube.common.scope.api.ScopeProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GeoportalServiceAccount {
    private static final Logger log = LoggerFactory.getLogger(GeoportalServiceAccount.class);
    protected static final String CLIENT_ID_PROPERTY_NAME = "clientId";
    private static final String SE_PROFILE_NAME = "geoportal";
    private static final String SE_CATEGORY_NAME = "SystemWorkspaceClient";
    private static String clientId = "geoportal";

    private static Map.Entry<String, String> getClientIdAndClientSecret(String context) {
        try {
            IAMClientCredentials credentials = IAMClientCredentialsReader.getCredentials(context, SE_PROFILE_NAME, SE_CATEGORY_NAME);
            clientId = credentials.getClientId() == null ? clientId : credentials.getClientId();
            String clientSecret = credentials.getClientSecret();
            AbstractMap.SimpleEntry<String, String> entry = new AbstractMap.SimpleEntry<String, String>(clientId, clientSecret);
            return entry;
        }
        catch (Exception e) {
            throw new InternalServerErrorException("Unable to retrieve Application Token for context " + SecretManagerProvider.instance.get().getContext(), (Throwable)e);
        }
    }

    private static TokenResponse getJWTAccessToken() throws Exception {
        SecretManager secretManager = SecretManagerProvider.instance.get();
        if (secretManager != null) {
            String context = GeoportalServiceAccount.getContext();
            log.info("Context is {}", (Object)context);
            Map.Entry<String, String> entry = GeoportalServiceAccount.getClientIdAndClientSecret(context);
            TokenResponse tr = KeycloakClientFactory.newInstance().queryUMAToken(context, entry.getKey(), entry.getValue(), context, null);
            return tr;
        }
        throw new Exception(SecretManager.class.getSimpleName() + " is null!! Please set it");
    }

    public static String getContext() {
        String context = null;
        SecretManager secretManager = SecretManagerProvider.instance.get();
        if (secretManager == null) {
            log.info(SecretManager.class.getSimpleName() + " is null trying to read the scope from " + ScopeProvider.class.getSimpleName());
            context = ScopeProvider.instance.get();
            log.info("Returning scope {} read from {}", (Object)context, (Object)ScopeProvider.class.getSimpleName());
            return context;
        }
        context = secretManager.getContext();
        if (context == null) {
            log.info(SecretManager.class.getSimpleName() + " has getContext null trying to read the scope from " + ScopeProvider.class.getSimpleName());
            context = ScopeProvider.instance.get();
            log.info("Returning scope {} read from {}", (Object)context, (Object)ScopeProvider.class.getSimpleName());
            return context;
        }
        log.info("Returning scope {} read from {}", (Object)context, (Object)SecretManager.class.getSimpleName());
        return context;
    }

    public static Secret getGeoportalSecret() throws Exception {
        TokenResponse tr = GeoportalServiceAccount.getJWTAccessToken();
        JWTSecret secret = new JWTSecret(tr.getAccessToken());
        return secret;
    }
}

