/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.application.cms.serialization;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.vdurmont.semver4j.Semver;
import java.io.IOException;
import java.time.format.DateTimeFormatter;
import java.util.Iterator;
import org.bson.Document;
import org.bson.types.ObjectId;
import org.gcube.application.cms.plugins.model.ComparableVersion;
import org.gcube.application.geoportal.common.model.document.Project;
import org.gcube.application.geoportal.common.model.rest.QueryRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Serialization {
    private static final Logger log = LoggerFactory.getLogger(Serialization.class);
    public static final DateTimeFormatter FULL_FORMATTER = DateTimeFormatter.ofPattern("uuuuMMdd_HH-mm-ss");
    public static ObjectMapper mapper = new ObjectMapper();

    public static <T> T read(String jsonString, Class<T> clazz) throws JsonProcessingException, IOException {
        return (T)mapper.readerFor(clazz).readValue(jsonString);
    }

    public static <T> Iterator<T> readCollection(String jsonString, Class<T> clazz) throws IOException {
        return mapper.readerFor(clazz).readValues(jsonString);
    }

    public static String write(Object toWrite) throws JsonProcessingException {
        String toReturn = mapper.writeValueAsString(toWrite);
        return toReturn;
    }

    public static QueryRequest parseQuery(String queryString) throws IOException {
        log.trace("Parsing query Request {} ", (Object)queryString);
        Document queryDocument = Document.parse((String)queryString);
        log.trace("Document is ", (Object)queryDocument.toJson());
        QueryRequest req = new QueryRequest();
        if (queryDocument.getOrDefault((Object)"ordering", null) != null) {
            req.setOrdering(Serialization.read(((Document)queryDocument.get((Object)"ordering")).toJson(), QueryRequest.OrderedRequest.class));
        }
        if (queryDocument.getOrDefault((Object)"paging", null) != null) {
            req.setPaging(Serialization.read(((Document)queryDocument.get((Object)"paging")).toJson(), QueryRequest.PagedRequest.class));
        }
        req.setProjection((Document)queryDocument.get((Object)"projection", Document.class));
        req.setFilter((Document)queryDocument.get((Object)"filter", Document.class));
        return req;
    }

    public static final <T> T convert(Object d, Class<T> clazz) {
        return (T)mapper.convertValue(d, clazz);
    }

    public static final <T> T convertAcceptStringAsNull(Object d, Class<T> clazz) {
        mapper.configure(DeserializationFeature.ACCEPT_EMPTY_STRING_AS_NULL_OBJECT, true);
        Object converted = mapper.convertValue(d, clazz);
        mapper.configure(DeserializationFeature.ACCEPT_EMPTY_STRING_AS_NULL_OBJECT, false);
        return (T)converted;
    }

    public static final Document asDocument(Object obj) throws JsonProcessingException {
        return Document.parse((String)mapper.writeValueAsString(obj));
    }

    public static final Document asDocumentWithId(Project doc) throws JsonProcessingException {
        Document toReturn = Document.parse((String)mapper.writeValueAsString((Object)doc));
        if (doc.getId() != null) {
            toReturn.put("_id", (Object)new ObjectId(doc.getId()));
        }
        return toReturn;
    }

    static {
        mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        mapper.configure(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS, false);
        mapper.registerModule((Module)new JavaTimeModule());
        SimpleModule s = new SimpleModule();
        s.addDeserializer(ObjectId.class, (JsonDeserializer)new ObjectIdDeserializer());
        s.addSerializer(ObjectId.class, (JsonSerializer)new ObjectIdSerializer());
        s.addDeserializer(Semver.class, (JsonDeserializer)new SemverDeserializer());
        s.addSerializer(Semver.class, (JsonSerializer)new SemverSerializer());
        mapper.registerModule((Module)s);
    }

    private static class SemverDeserializer
    extends JsonDeserializer<Semver> {
        private SemverDeserializer() {
        }

        public Semver deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException, JsonProcessingException {
            String value = jsonParser.getValueAsString();
            if (value == null || value.isEmpty() || value.equals("null")) {
                return null;
            }
            return new Semver(value);
        }

        public Class<Semver> handledType() {
            return Semver.class;
        }
    }

    private static class SemverSerializer
    extends JsonSerializer<Semver> {
        private SemverSerializer() {
        }

        public void serialize(Semver semver, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException, JsonProcessingException {
            if (semver == null) {
                jsonGenerator.writeNull();
            } else {
                jsonGenerator.writeString(semver.getValue());
            }
        }

        public Class<Semver> handledType() {
            return Semver.class;
        }
    }

    private static class ComparableVersionDeserializer
    extends JsonDeserializer<ComparableVersion> {
        private ComparableVersionDeserializer() {
        }

        public ComparableVersion deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException, JsonProcessingException {
            String value = jsonParser.getValueAsString();
            if (value == null || value.isEmpty() || value.equals("null")) {
                return null;
            }
            return new ComparableVersion(value);
        }

        public Class<ComparableVersion> handledType() {
            return ComparableVersion.class;
        }
    }

    private static class ComparableVersionSerializer
    extends JsonSerializer<ComparableVersion> {
        private ComparableVersionSerializer() {
        }

        public void serialize(ComparableVersion comparableVersion, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException, JsonProcessingException {
            if (comparableVersion == null) {
                jsonGenerator.writeNull();
            } else {
                jsonGenerator.writeString(comparableVersion.getCanonical());
            }
        }

        public Class<ComparableVersion> handledType() {
            return ComparableVersion.class;
        }
    }

    private static class ObjectIdDeserializer
    extends JsonDeserializer<ObjectId> {
        private ObjectIdDeserializer() {
        }

        public ObjectId deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException, JsonProcessingException {
            String value = jsonParser.getValueAsString();
            if (value == null || value.isEmpty() || value.equals("null")) {
                return null;
            }
            return new ObjectId(value);
        }

        public Class<ObjectId> handledType() {
            return ObjectId.class;
        }
    }

    private static class ObjectIdSerializer
    extends JsonSerializer<ObjectId> {
        private ObjectIdSerializer() {
        }

        public void serialize(ObjectId objectId, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException, JsonProcessingException {
            if (objectId == null) {
                jsonGenerator.writeNull();
            } else {
                jsonGenerator.writeString(objectId.toString());
            }
        }

        public Class<ObjectId> handledType() {
            return ObjectId.class;
        }
    }
}

