/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.application.cms.plugins.events;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.bson.Document;
import org.gcube.application.cms.plugins.events.EventManager;
import org.gcube.application.cms.plugins.events.ItemObservable;
import org.gcube.application.geoportal.common.model.document.Project;
import org.gcube.application.geoportal.common.model.document.accounting.Context;
import org.gcube.application.geoportal.common.model.document.accounting.User;
import org.gcube.application.geoportal.common.model.useCaseDescriptor.UseCaseDescriptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ItemObserved<T extends Project>
implements ItemObservable {
    private static final Logger log = LoggerFactory.getLogger(ItemObserved.class);
    private User userCaller;
    private Context context;
    private UseCaseDescriptor useCaseDescriptor;
    private T project;
    private EventManager.Event event;
    private Document optional;

    @Override
    public String getProjectId() {
        log.debug("Called getProjectId");
        if (this.project == null) {
            return null;
        }
        return this.project.getId();
    }

    @Override
    public String getUCD_Id() {
        log.debug("Called getUCD_Id");
        if (this.useCaseDescriptor == null) {
            return null;
        }
        return this.useCaseDescriptor.getId();
    }

    public LinkedHashMap<String, Object> getDocumentEntries(int limit) {
        LinkedHashMap<String, Object> documentAsMap = new LinkedHashMap<String, Object>();
        Iterator entrySetsIt = this.project.getTheDocument().entrySet().iterator();
        int i = 0;
        while (entrySetsIt.hasNext() && i + 1 <= limit) {
            Map.Entry entry = (Map.Entry)entrySetsIt.next();
            documentAsMap.put((String)entry.getKey(), entry.getValue() != null ? entry.getValue().toString() : null);
            ++i;
        }
        return documentAsMap;
    }

    public void setOptional(OPTIONAL_FIELD optionalField, String value) {
        this.optional = new Document();
        if (this.optional == null) {
            this.optional = new Document();
        }
        this.optional.put(optionalField.name(), (Object)value);
    }

    public String getOptionalValue(OPTIONAL_FIELD optionalField) {
        if (this.optional != null) {
            return this.optional.getString((Object)optionalField.name());
        }
        return null;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("ItemObserved [userCaller=");
        builder.append(this.userCaller);
        builder.append(", context=");
        builder.append(this.context);
        builder.append(", useCaseDescriptor id=");
        builder.append(this.useCaseDescriptor != null ? this.useCaseDescriptor.getId() : null);
        builder.append(", project id=");
        builder.append(this.project != null ? this.project.getId() : null);
        builder.append(", event=");
        builder.append((Object)this.event);
        builder.append(", optional=");
        builder.append(this.optional);
        builder.append("]");
        return builder.toString();
    }

    public User getUserCaller() {
        return this.userCaller;
    }

    public Context getContext() {
        return this.context;
    }

    public UseCaseDescriptor getUseCaseDescriptor() {
        return this.useCaseDescriptor;
    }

    public T getProject() {
        return this.project;
    }

    public EventManager.Event getEvent() {
        return this.event;
    }

    public Document getOptional() {
        return this.optional;
    }

    public void setUserCaller(User userCaller) {
        this.userCaller = userCaller;
    }

    public void setContext(Context context) {
        this.context = context;
    }

    public void setUseCaseDescriptor(UseCaseDescriptor useCaseDescriptor) {
        this.useCaseDescriptor = useCaseDescriptor;
    }

    public void setProject(T project) {
        this.project = project;
    }

    public void setEvent(EventManager.Event event) {
        this.event = event;
    }

    public void setOptional(Document optional) {
        this.optional = optional;
    }

    public ItemObserved() {
    }

    public ItemObserved(User userCaller, Context context, UseCaseDescriptor useCaseDescriptor, T project, EventManager.Event event, Document optional) {
        this.userCaller = userCaller;
        this.context = context;
        this.useCaseDescriptor = useCaseDescriptor;
        this.project = project;
        this.event = event;
        this.optional = optional;
    }

    public static enum OPTIONAL_FIELD {
        message,
        preview_url;

    }
}

