/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.application.cms.plugins.events;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.gcube.application.cms.plugins.events.EventListener;
import org.gcube.application.cms.plugins.events.EventManagerInterface;
import org.gcube.application.cms.plugins.events.ItemObserved;
import org.gcube.application.geoportal.common.model.document.Project;

public class EventManager
implements EventManagerInterface<ItemObserved<Project>> {
    private HashMap<Event, List<EventListener<ItemObserved<Project>>>> listeners = new HashMap();
    private static EventManager instance;

    private EventManager() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static EventManager getInstance() {
        if (instance != null) return instance;
        Class<EventManager> clazz = EventManager.class;
        synchronized (EventManager.class) {
            if (instance != null) return instance;
            instance = new EventManager();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    @Override
    public void subscribe(Event eventType, EventListener<ItemObserved<Project>> listener) {
        List<EventListener<ItemObserved<Project>>> list = this.listeners.get((Object)eventType);
        if (list == null) {
            list = new ArrayList<EventListener<ItemObserved<Project>>>();
        }
        list.add(listener);
        this.listeners.put(eventType, list);
    }

    @Override
    public void unsubscribe(Event eventType, EventListener<ItemObserved<Project>> listener) {
        List<EventListener<ItemObserved<Project>>> list = this.listeners.get((Object)eventType);
        if (list == null) {
            return;
        }
        list.remove(listener);
        this.listeners.put(eventType, list);
    }

    @Override
    public void notify(Event eventType, ItemObserved<Project> item) {
        for (Event event : this.listeners.keySet()) {
            if (!event.equals((Object)eventType)) continue;
            for (EventListener<ItemObserved<Project>> eventListner : this.listeners.get((Object)eventType)) {
                eventListner.updated(item);
            }
        }
    }

    public static enum Event {
        PROJECT_CREATED("PROJECT_CREATED"),
        PROJECT_UPDATED("PROJECT_UPDATED"),
        PROJECT_DELETED("PROJECT_DELETED"),
        LIFECYCLE_STEP_PERFORMED("LIFECYCLE_STEP_PERFORMED");

        String name;

        private Event(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }
    }
}

