/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.application.cms.plugins;

import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Predicate;
import org.gcube.application.cms.plugins.Plugin;
import org.reflections.Configuration;
import org.reflections.Reflections;
import org.reflections.util.ConfigurationBuilder;
import org.reflections.util.FilterBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PluginsReflections {
    private static final Logger log = LoggerFactory.getLogger(PluginsReflections.class);

    public static Map<String, Plugin> load() {
        HashMap<String, Plugin> toReturn = new HashMap<String, Plugin>();
        log.warn("WARNING!! LOADING PLUGIN CLASSES : THIS SHOULD HAPPEN ONLY ONCE");
        Reflections reflections = new Reflections((Configuration)new ConfigurationBuilder().forPackage("org.gcube.application.cms", new ClassLoader[0]).filterInputsBy((Predicate)new FilterBuilder().includePackage("org.gcube.application.cms")));
        reflections.getSubTypesOf(Plugin.class).iterator().forEachRemaining(pluginClass -> {
            log.debug("Evaluating class {}", pluginClass);
            if (!pluginClass.isInterface() && !Modifier.isAbstract(pluginClass.getModifiers())) {
                try {
                    log.debug("Found implementation {} ", pluginClass);
                    Plugin plugin = (Plugin)pluginClass.newInstance();
                    log.debug("Loading {} description : {}", (Object)plugin, (Object)plugin.getDescriptor());
                    toReturn.put(plugin.getDescriptor().getId(), plugin);
                }
                catch (Throwable t) {
                    log.warn("Unable to instantiate Plugin " + pluginClass, t);
                }
            }
        });
        return toReturn;
    }
}

