/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.application.cms.serviceaccount;

import java.security.Key;
import java.util.Collection;
import java.util.List;
import org.gcube.application.cms.serviceaccount.IAMClientCredentials;
import org.gcube.common.encryption.StringEncrypter;
import org.gcube.common.resources.gcore.ServiceEndpoint;
import org.gcube.resources.discovery.client.api.DiscoveryClient;
import org.gcube.resources.discovery.client.queries.api.Query;
import org.gcube.resources.discovery.client.queries.impl.XQuery;
import org.gcube.resources.discovery.icclient.ICFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IAMClientCredentialsReader {
    private static final Logger log = LoggerFactory.getLogger(IAMClientCredentialsReader.class);

    public static IAMClientCredentials getCredentials(String currentContext, String seProfileName, String seCategoryName) throws Exception {
        log.info("Searching SE in the scope: " + currentContext + " with profile name: " + seProfileName + " and category name: " + seCategoryName);
        XQuery query = ICFactory.queryFor(ServiceEndpoint.class);
        query.addCondition("$resource/Profile/Name/text() eq '" + seProfileName + "'");
        query.addCondition("$resource/Profile/Category/text() eq '" + seCategoryName + "'");
        DiscoveryClient client = ICFactory.clientFor(ServiceEndpoint.class);
        List resources = client.submit((Query)query);
        if (resources.size() <= 0) {
            throw new RuntimeException("ServiceEndpoint not found. Searching for profile name '" + seProfileName + "' and category name '" + seCategoryName + "' in the scope: " + currentContext);
        }
        log.info("The query returned " + resources.size() + " ServiceEndpoint/s");
        ServiceEndpoint se = (ServiceEndpoint)resources.get(0);
        Collection theAccessPoints = se.profile().accessPoints().asCollection();
        String clientId = null;
        String secredPwd = null;
        for (ServiceEndpoint.AccessPoint accessPoint : theAccessPoints) {
            clientId = accessPoint.username();
            secredPwd = accessPoint.password();
            log.debug("Found clientId: " + clientId + " and encrypted secret: " + secredPwd);
            try {
                if (secredPwd == null) continue;
                secredPwd = StringEncrypter.getEncrypter().decrypt(secredPwd, new Key[0]);
                log.debug("Secret decrypted is: " + secredPwd.substring(0, secredPwd.length() / 2) + "_MASKED_TOKEN_");
            }
            catch (Exception e) {
                throw new RuntimeException("Error on decrypting the pwd: ", e);
            }
        }
        log.info("Returning keycloack credentials for SE {} read from SE", (Object)seProfileName);
        return new IAMClientCredentials(clientId, secredPwd);
    }
}

