/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.application.cms.plugins.reports;

import com.fasterxml.jackson.core.JsonProcessingException;
import java.util.ArrayList;
import java.util.List;
import lombok.NonNull;
import org.bson.Document;
import org.gcube.application.cms.plugins.faults.InvalidPluginRequestException;
import org.gcube.application.cms.plugins.faults.PluginExecutionException;
import org.gcube.application.cms.plugins.reports.Report;
import org.gcube.application.cms.plugins.requests.BaseExecutionRequest;
import org.gcube.application.geoportal.common.model.document.Project;
import org.gcube.application.geoportal.common.model.document.identification.IdentificationReference;
import org.gcube.application.geoportal.common.model.document.lifecycle.LifecycleInformation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DocumentHandlingReport<T extends BaseExecutionRequest>
extends Report {
    private static final Logger log = LoggerFactory.getLogger(DocumentHandlingReport.class);
    @NonNull
    T theRequest;
    Document resultingDocument;
    LifecycleInformation toSetLifecycleInformation;
    protected List<IdentificationReference> toSetIdentificationReferences = null;

    public DocumentHandlingReport<T> addIdentificationReference(IdentificationReference toAdd) {
        if (this.toSetIdentificationReferences == null) {
            this.toSetIdentificationReferences = new ArrayList<IdentificationReference>();
        }
        this.toSetIdentificationReferences.add(toAdd);
        return this;
    }

    public DocumentHandlingReport(@NonNull T theRequest) throws InvalidPluginRequestException {
        if (theRequest == null) {
            throw new NullPointerException("theRequest is marked @NonNull but is null");
        }
        ((BaseExecutionRequest)theRequest).validate();
        this.theRequest = theRequest;
        this.setStatus(Report.Status.OK);
        this.toSetLifecycleInformation = ((BaseExecutionRequest)theRequest).getDocument().getLifecycleInformation();
        this.resultingDocument = ((BaseExecutionRequest)theRequest).getDocument().getTheDocument();
    }

    @Override
    public void validate() throws PluginExecutionException {
        super.validate();
        if (this.resultingDocument == null) {
            log.warn("NULL resulting document in report {} ", (Object)this);
            throw new PluginExecutionException("Invalid report : Resulting document cannot be null");
        }
        if (this.toSetLifecycleInformation == null) {
            log.warn("NULL lifecycleinformation in report {} ", (Object)this);
            throw new PluginExecutionException("Invalid report : Lifecycle information cannot be null");
        }
    }

    public Project prepareResult() throws JsonProcessingException, PluginExecutionException {
        log.trace("Preparing document ID {} from report ... ", (Object)((BaseExecutionRequest)this.theRequest).getDocument().getId());
        this.validate();
        Project toReturn = ((BaseExecutionRequest)this.theRequest).getDocument();
        toReturn.setTheDocument(this.resultingDocument);
        toReturn.setLifecycleInformation(this.toSetLifecycleInformation);
        log.trace("Report status is {} ", (Object)this.getStatus());
        LifecycleInformation info = toReturn.getLifecycleInformation();
        switch (this.getStatus()) {
            case ERROR: {
                info.setLastOperationStatus(LifecycleInformation.Status.ERROR);
                this.getMessages().forEach(s -> info.addErrorMessage(s));
                break;
            }
            case WARNING: {
                info.setLastOperationStatus(LifecycleInformation.Status.WARNING);
                this.getMessages().forEach(s -> info.addWarningMessage(s));
                break;
            }
            case OK: {
                if (info.getLastOperationStatus() != null) break;
                info.setLastOperationStatus(LifecycleInformation.Status.OK);
            }
        }
        if (this.toSetIdentificationReferences != null) {
            toReturn.setIdentificationReferences(this.toSetIdentificationReferences);
        }
        return toReturn;
    }

    @NonNull
    public T getTheRequest() {
        return this.theRequest;
    }

    public Document getResultingDocument() {
        return this.resultingDocument;
    }

    public LifecycleInformation getToSetLifecycleInformation() {
        return this.toSetLifecycleInformation;
    }

    public List<IdentificationReference> getToSetIdentificationReferences() {
        return this.toSetIdentificationReferences;
    }

    public void setTheRequest(@NonNull T theRequest) {
        if (theRequest == null) {
            throw new NullPointerException("theRequest is marked @NonNull but is null");
        }
        this.theRequest = theRequest;
    }

    public void setResultingDocument(Document resultingDocument) {
        this.resultingDocument = resultingDocument;
    }

    public void setToSetLifecycleInformation(LifecycleInformation toSetLifecycleInformation) {
        this.toSetLifecycleInformation = toSetLifecycleInformation;
    }

    public void setToSetIdentificationReferences(List<IdentificationReference> toSetIdentificationReferences) {
        this.toSetIdentificationReferences = toSetIdentificationReferences;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DocumentHandlingReport)) {
            return false;
        }
        DocumentHandlingReport other = (DocumentHandlingReport)o;
        if (!other.canEqual(this)) {
            return false;
        }
        T this$theRequest = this.getTheRequest();
        T other$theRequest = other.getTheRequest();
        if (this$theRequest == null ? other$theRequest != null : !this$theRequest.equals(other$theRequest)) {
            return false;
        }
        Document this$resultingDocument = this.getResultingDocument();
        Document other$resultingDocument = other.getResultingDocument();
        if (this$resultingDocument == null ? other$resultingDocument != null : !this$resultingDocument.equals(other$resultingDocument)) {
            return false;
        }
        LifecycleInformation this$toSetLifecycleInformation = this.getToSetLifecycleInformation();
        LifecycleInformation other$toSetLifecycleInformation = other.getToSetLifecycleInformation();
        if (this$toSetLifecycleInformation == null ? other$toSetLifecycleInformation != null : !this$toSetLifecycleInformation.equals(other$toSetLifecycleInformation)) {
            return false;
        }
        List<IdentificationReference> this$toSetIdentificationReferences = this.getToSetIdentificationReferences();
        List<IdentificationReference> other$toSetIdentificationReferences = other.getToSetIdentificationReferences();
        return !(this$toSetIdentificationReferences == null ? other$toSetIdentificationReferences != null : !((Object)this$toSetIdentificationReferences).equals(other$toSetIdentificationReferences));
    }

    protected boolean canEqual(Object other) {
        return other instanceof DocumentHandlingReport;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        T $theRequest = this.getTheRequest();
        result = result * 59 + ($theRequest == null ? 43 : $theRequest.hashCode());
        Document $resultingDocument = this.getResultingDocument();
        result = result * 59 + ($resultingDocument == null ? 43 : $resultingDocument.hashCode());
        LifecycleInformation $toSetLifecycleInformation = this.getToSetLifecycleInformation();
        result = result * 59 + ($toSetLifecycleInformation == null ? 43 : $toSetLifecycleInformation.hashCode());
        List<IdentificationReference> $toSetIdentificationReferences = this.getToSetIdentificationReferences();
        result = result * 59 + ($toSetIdentificationReferences == null ? 43 : ((Object)$toSetIdentificationReferences).hashCode());
        return result;
    }

    public String toString() {
        return "DocumentHandlingReport(theRequest=" + this.getTheRequest() + ", resultingDocument=" + this.getResultingDocument() + ", toSetLifecycleInformation=" + this.getToSetLifecycleInformation() + ", toSetIdentificationReferences=" + this.getToSetIdentificationReferences() + ")";
    }
}

