/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.application.cms.implementations;

import java.io.InputStream;
import lombok.NonNull;
import org.gcube.application.cms.implementations.ImplementationProvider;
import org.gcube.application.geoportal.common.model.configuration.Archive;
import org.gcube.application.geoportal.common.model.document.filesets.RegisteredFile;
import org.gcube.application.geoportal.common.model.rest.ConfigurationException;
import org.gcube.application.geoportal.common.utils.Files;
import org.gcube.common.storagehub.client.dsl.FileContainer;
import org.gcube.common.storagehub.client.dsl.FolderContainer;
import org.gcube.common.storagehub.client.dsl.StorageHubClient;
import org.gcube.common.storagehub.model.exceptions.StorageHubException;
import org.gcube.common.storagehub.model.items.AbstractFileItem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WorkspaceManager {
    private static final Logger log = LoggerFactory.getLogger(WorkspaceManager.class);
    private static final Object $LOCK = new Object[0];
    private static final String APP_FOLDER = ".GNA_RECORDS";
    private StorageHubClient sgClient = ImplementationProvider.get().getProvidedObjectByClass(StorageHubClient.class);
    private FolderContainer appBase = WorkspaceManager.getApplicationBaseFolder(this.sgClient);

    public Archive getConfiguration() {
        Archive toReturn = new Archive("W-STORAGE");
        toReturn.put("folder_id", (Object)this.appBase.getId());
        return toReturn;
    }

    public FolderContainer createFolder(FolderOptions opts) throws StorageHubException {
        if (opts.getParent() == null) {
            opts.setParent(this.appBase);
        }
        return WorkspaceManager.createFolderRoutine(opts);
    }

    public FileContainer getFileById(String id) throws StorageHubException {
        return this.sgClient.open(id).asFile();
    }

    public FolderContainer getFolderById(String id) throws StorageHubException {
        return this.sgClient.open(id).asFolder();
    }

    public void removeFolderById(String id) throws StorageHubException {
        this.sgClient.open(id).asFolder().delete();
    }

    public FolderContainer getSubFolder(FolderContainer parentFolder, String path) throws StorageHubException {
        return this.getSubFolder(parentFolder, path, "");
    }

    public FolderContainer getSubFolder(FolderContainer parentFolder, String path, String description) throws StorageHubException {
        try {
            return parentFolder.openByRelativePath(path).asFolder();
        }
        catch (StorageHubException e) {
            log.debug("Missing subPath " + path);
            FolderContainer targetParent = parentFolder;
            String targetName = path;
            if (path.contains("/")) {
                String parent = path.substring(0, path.lastIndexOf("/"));
                log.debug("Checking intermediate " + parent);
                targetParent = this.getSubFolder(parentFolder, parent);
                targetName = path.substring(path.lastIndexOf("/") + 1);
            }
            FolderOptions opts = new FolderOptions(targetName, description, targetParent);
            log.debug("Creating FOLDER {}", (Object)opts);
            return this.createFolder(opts);
        }
    }

    public RegisteredFile registerFile(FileOptions opts) throws StorageHubException {
        FileContainer item = WorkspaceManager.createFileRoutine(opts);
        item = this.sgClient.open(item.getId()).asFile();
        RegisteredFile file = new RegisteredFile();
        file.setLink(item.getPublicLink().toString());
        file.setMimetype(((AbstractFileItem)item.get()).getContent().getMimeType());
        file.setStorageID(item.getId());
        file.setName(((AbstractFileItem)item.get()).getName());
        return file;
    }

    public void deleteItem(String itemId) throws StorageHubException {
        this.sgClient.open(itemId).asItem().forceDelete();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static FolderContainer getApplicationBaseFolder(StorageHubClient sgClient) throws StorageHubException {
        Object object = $LOCK;
        synchronized (object) {
            FolderContainer vre = sgClient.openVREFolder();
            try {
                return vre.openByRelativePath(APP_FOLDER).asFolder();
            }
            catch (StorageHubException e) {
                log.debug("APP Fodler missing. Initializing..");
                FolderContainer toReturn = vre.newFolder(APP_FOLDER, "Base folder for GNA records");
                toReturn.setHidden();
                return toReturn;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static FolderContainer createFolderRoutine(FolderOptions opts) throws StorageHubException {
        Object object = $LOCK;
        synchronized (object) {
            opts.setFolderName(Files.fixFilename((String)opts.getFolderName()));
            return opts.getParent().newFolder(opts.getFolderName(), opts.getFolderDescription());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static FileContainer createFileRoutine(FileOptions opts) throws StorageHubException {
        Object object = $LOCK;
        synchronized (object) {
            opts.setFileName(Files.fixFilename((String)opts.getFileName()));
            return opts.getParent().uploadFile(opts.getIs(), opts.getFileName(), opts.getFileDescription());
        }
    }

    public FolderContainer getAppBase() {
        return this.appBase;
    }

    public static class FileOptions {
        @NonNull
        private String fileName;
        @NonNull
        private InputStream is;
        private String fileDescription;
        private FolderContainer parent;

        @NonNull
        public String getFileName() {
            return this.fileName;
        }

        @NonNull
        public InputStream getIs() {
            return this.is;
        }

        public String getFileDescription() {
            return this.fileDescription;
        }

        public FolderContainer getParent() {
            return this.parent;
        }

        public void setFileName(@NonNull String fileName) {
            if (fileName == null) {
                throw new NullPointerException("fileName is marked @NonNull but is null");
            }
            this.fileName = fileName;
        }

        public void setIs(@NonNull InputStream is) {
            if (is == null) {
                throw new NullPointerException("is is marked @NonNull but is null");
            }
            this.is = is;
        }

        public void setFileDescription(String fileDescription) {
            this.fileDescription = fileDescription;
        }

        public void setParent(FolderContainer parent) {
            this.parent = parent;
        }

        public FileOptions(@NonNull String fileName, @NonNull InputStream is, String fileDescription, FolderContainer parent) {
            if (fileName == null) {
                throw new NullPointerException("fileName is marked @NonNull but is null");
            }
            if (is == null) {
                throw new NullPointerException("is is marked @NonNull but is null");
            }
            this.fileName = fileName;
            this.is = is;
            this.fileDescription = fileDescription;
            this.parent = parent;
        }

        public FileOptions(@NonNull String fileName, @NonNull InputStream is) {
            if (fileName == null) {
                throw new NullPointerException("fileName is marked @NonNull but is null");
            }
            if (is == null) {
                throw new NullPointerException("is is marked @NonNull but is null");
            }
            this.fileName = fileName;
            this.is = is;
        }
    }

    public static class FolderOptions {
        @NonNull
        private String folderName;
        private String folderDescription;
        private FolderContainer parent;

        @NonNull
        public String getFolderName() {
            return this.folderName;
        }

        public String getFolderDescription() {
            return this.folderDescription;
        }

        public FolderContainer getParent() {
            return this.parent;
        }

        public void setFolderName(@NonNull String folderName) {
            if (folderName == null) {
                throw new NullPointerException("folderName is marked @NonNull but is null");
            }
            this.folderName = folderName;
        }

        public void setFolderDescription(String folderDescription) {
            this.folderDescription = folderDescription;
        }

        public void setParent(FolderContainer parent) {
            this.parent = parent;
        }

        public FolderOptions(@NonNull String folderName, String folderDescription, FolderContainer parent) {
            if (folderName == null) {
                throw new NullPointerException("folderName is marked @NonNull but is null");
            }
            this.folderName = folderName;
            this.folderDescription = folderDescription;
            this.parent = parent;
        }

        public FolderOptions(@NonNull String folderName) {
            if (folderName == null) {
                throw new NullPointerException("folderName is marked @NonNull but is null");
            }
            this.folderName = folderName;
        }
    }
}

