/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.application.cms.plugins.reports;

import java.util.ArrayList;
import java.util.List;
import org.gcube.application.cms.plugins.faults.PluginExecutionException;

public class Report {
    private Status status;
    private List<String> messages;

    public Report(Status status, String ... messages) {
        this.status = status;
        this.messages = new ArrayList<String>();
        for (String s : messages) {
            this.messages.add(s);
        }
    }

    public Report putMessage(String msg) {
        if (this.messages == null) {
            this.messages = new ArrayList<String>();
        }
        this.messages.add(msg);
        return this;
    }

    public void validate() throws PluginExecutionException {
        if (this.status == null) {
            throw new PluginExecutionException("Status is null");
        }
        if (!this.status.equals((Object)Status.OK) && (this.messages == null || this.messages.isEmpty())) {
            throw new PluginExecutionException("Messages are mandatory for status != OK ");
        }
    }

    public Status getStatus() {
        return this.status;
    }

    public List<String> getMessages() {
        return this.messages;
    }

    public void setStatus(Status status) {
        this.status = status;
    }

    public void setMessages(List<String> messages) {
        this.messages = messages;
    }

    public Report() {
    }

    public static enum Status {
        ERROR,
        WARNING,
        OK;

    }
}

