/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.application.cms.plugins.reports;

import com.fasterxml.jackson.core.JsonProcessingException;
import java.util.ArrayList;
import java.util.List;
import lombok.NonNull;
import org.gcube.application.cms.plugins.faults.InvalidPluginRequestException;
import org.gcube.application.cms.plugins.faults.PluginExecutionException;
import org.gcube.application.cms.plugins.reports.DocumentHandlingReport;
import org.gcube.application.cms.plugins.requests.EventExecutionRequest;
import org.gcube.application.cms.plugins.requests.StepExecutionRequest;
import org.gcube.application.geoportal.common.model.document.Project;

public class StepExecutionReport
extends DocumentHandlingReport<StepExecutionRequest> {
    List<EventExecutionRequest> toTriggerEvents;
    List<StepExecutionRequest> cascadeSteps;

    public StepExecutionReport(@NonNull StepExecutionRequest theRequest) throws InvalidPluginRequestException {
        super(theRequest);
        if (theRequest == null) {
            throw new NullPointerException("theRequest is marked @NonNull but is null");
        }
        this.getToSetLifecycleInformation().cleanState();
        this.getToSetLifecycleInformation().setLastInvokedStep(theRequest.getStep());
    }

    public StepExecutionReport addToTriggerEvent(EventExecutionRequest req) {
        if (this.toTriggerEvents == null) {
            this.toTriggerEvents = new ArrayList<EventExecutionRequest>();
        }
        this.toTriggerEvents.add(req);
        return this;
    }

    public StepExecutionReport addCascadeStep(StepExecutionRequest req) {
        if (this.cascadeSteps == null) {
            this.cascadeSteps = new ArrayList<StepExecutionRequest>();
        }
        this.cascadeSteps.add(req);
        return this;
    }

    @Override
    public Project prepareResult() throws JsonProcessingException, PluginExecutionException {
        Project toReturn = super.prepareResult();
        return toReturn;
    }

    public List<EventExecutionRequest> getToTriggerEvents() {
        return this.toTriggerEvents;
    }

    public List<StepExecutionRequest> getCascadeSteps() {
        return this.cascadeSteps;
    }

    public void setToTriggerEvents(List<EventExecutionRequest> toTriggerEvents) {
        this.toTriggerEvents = toTriggerEvents;
    }

    public void setCascadeSteps(List<StepExecutionRequest> cascadeSteps) {
        this.cascadeSteps = cascadeSteps;
    }

    @Override
    public String toString() {
        return "StepExecutionReport(toTriggerEvents=" + this.getToTriggerEvents() + ", cascadeSteps=" + this.getCascadeSteps() + ")";
    }
}

