/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.application.cms.plugins.requests;

import lombok.NonNull;
import org.bson.Document;
import org.gcube.application.cms.plugins.faults.InvalidPluginRequestException;
import org.gcube.application.cms.serialization.Serialization;
import org.gcube.application.geoportal.common.model.document.accounting.Context;
import org.gcube.application.geoportal.common.model.document.accounting.User;
import org.gcube.application.geoportal.common.model.useCaseDescriptor.UseCaseDescriptor;

public class BaseRequest {
    @NonNull
    UseCaseDescriptor useCaseDescriptor;
    @NonNull
    User caller;
    @NonNull
    Context context;
    Document callParameters;

    public final String getMandatory(String param) throws InvalidPluginRequestException {
        return BaseRequest.getMandatory(param, this.callParameters);
    }

    public final String getWithDefault(String param, String defaultValue) {
        try {
            return BaseRequest.getMandatory(param, this.callParameters);
        }
        catch (InvalidPluginRequestException e) {
            return defaultValue;
        }
    }

    public static final String getMandatory(String param, Document params) throws InvalidPluginRequestException {
        if (params == null || params.isEmpty() || !params.containsKey((Object)param)) {
            throw new InvalidPluginRequestException("Missing mandatory parameter " + param);
        }
        return Serialization.convert(params.get((Object)param), String.class);
    }

    public BaseRequest validate() throws InvalidPluginRequestException {
        if (this.useCaseDescriptor == null) {
            throw new InvalidPluginRequestException("UseCaseDescriptor cannot be null ");
        }
        return this;
    }

    public BaseRequest setParameter(String key, Object value) {
        if (this.callParameters == null) {
            this.callParameters = new Document();
        }
        this.callParameters.put(key, value);
        return this;
    }

    @NonNull
    public UseCaseDescriptor getUseCaseDescriptor() {
        return this.useCaseDescriptor;
    }

    @NonNull
    public User getCaller() {
        return this.caller;
    }

    @NonNull
    public Context getContext() {
        return this.context;
    }

    public Document getCallParameters() {
        return this.callParameters;
    }

    public void setUseCaseDescriptor(@NonNull UseCaseDescriptor useCaseDescriptor) {
        if (useCaseDescriptor == null) {
            throw new NullPointerException("useCaseDescriptor is marked @NonNull but is null");
        }
        this.useCaseDescriptor = useCaseDescriptor;
    }

    public void setCaller(@NonNull User caller) {
        if (caller == null) {
            throw new NullPointerException("caller is marked @NonNull but is null");
        }
        this.caller = caller;
    }

    public void setContext(@NonNull Context context) {
        if (context == null) {
            throw new NullPointerException("context is marked @NonNull but is null");
        }
        this.context = context;
    }

    public void setCallParameters(Document callParameters) {
        this.callParameters = callParameters;
    }

    public String toString() {
        return "BaseRequest(super=" + super.toString() + ", useCaseDescriptor=" + this.getUseCaseDescriptor() + ", caller=" + this.getCaller() + ", context=" + this.getContext() + ", callParameters=" + this.getCallParameters() + ")";
    }

    public BaseRequest(@NonNull UseCaseDescriptor useCaseDescriptor, @NonNull User caller, @NonNull Context context) {
        if (useCaseDescriptor == null) {
            throw new NullPointerException("useCaseDescriptor is marked @NonNull but is null");
        }
        if (caller == null) {
            throw new NullPointerException("caller is marked @NonNull but is null");
        }
        if (context == null) {
            throw new NullPointerException("context is marked @NonNull but is null");
        }
        this.useCaseDescriptor = useCaseDescriptor;
        this.caller = caller;
        this.context = context;
    }
}

