/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.application.cms.plugins.implementations;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.bson.Document;
import org.gcube.application.cms.plugins.IndexerPluginInterface;
import org.gcube.application.cms.plugins.LifecycleManager;
import org.gcube.application.cms.plugins.MaterializationPlugin;
import org.gcube.application.cms.plugins.faults.EventException;
import org.gcube.application.cms.plugins.faults.IndexingException;
import org.gcube.application.cms.plugins.faults.InvalidPluginRequestException;
import org.gcube.application.cms.plugins.faults.MaterializationException;
import org.gcube.application.cms.plugins.implementations.AbstractLifeCycleManager;
import org.gcube.application.cms.plugins.implementations.executions.GuardedStepExecution;
import org.gcube.application.cms.plugins.reports.DocumentHandlingReport;
import org.gcube.application.cms.plugins.reports.EventExecutionReport;
import org.gcube.application.cms.plugins.reports.IndexDocumentReport;
import org.gcube.application.cms.plugins.reports.MaterializationReport;
import org.gcube.application.cms.plugins.reports.Report;
import org.gcube.application.cms.plugins.reports.StepExecutionReport;
import org.gcube.application.cms.plugins.requests.BaseExecutionRequest;
import org.gcube.application.cms.plugins.requests.BaseRequest;
import org.gcube.application.cms.plugins.requests.EventExecutionRequest;
import org.gcube.application.cms.plugins.requests.IndexDocumentRequest;
import org.gcube.application.cms.plugins.requests.MaterializationRequest;
import org.gcube.application.geoportal.common.model.JSONPathWrapper;
import org.gcube.application.geoportal.common.model.configuration.Configuration;
import org.gcube.application.geoportal.common.model.configuration.Index;
import org.gcube.application.geoportal.common.model.document.lifecycle.LifecycleInformation;
import org.gcube.application.geoportal.common.model.plugins.OperationDescriptor;
import org.gcube.application.geoportal.common.model.rest.ConfigurationException;
import org.gcube.application.geoportal.common.model.useCaseDescriptor.HandlerDeclaration;
import org.gcube.application.geoportal.common.model.useCaseDescriptor.UseCaseDescriptor;
import org.gcube.application.geoportal.common.utils.Files;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleLifeCycleManager
extends AbstractLifeCycleManager
implements LifecycleManager {
    private static final Logger log = LoggerFactory.getLogger(SimpleLifeCycleManager.class);
    public static final String PLUGIN_ID = "DEFAULT-SINGLE-STEP";

    public SimpleLifeCycleManager() {
        this.DESCRIPTOR.setId(PLUGIN_ID);
    }

    @Override
    public Configuration getCurrentConfiguration(BaseRequest req) throws ConfigurationException {
        Configuration toReturn = super.getCurrentConfiguration(req);
        toReturn.setIndexes(new ArrayList());
        IndexerPluginInterface indexerPlugin = (IndexerPluginInterface)this.pluginManager.getById("SDI-Indexer-Plugin");
        BaseRequest indexRequest = new BaseRequest(req.getUseCaseDescriptor(), req.getCaller(), req.getContext());
        try {
            indexRequest.setCallParameters(this.getPublicIndexParams(req));
            Index publicIndex = indexerPlugin.getIndex(indexRequest);
            publicIndex.put("flag", (Object)"public");
            toReturn.getIndexes().add(publicIndex);
        }
        catch (ConfigurationException e) {
            toReturn.addErrorMessage("Unable to gather information on public GIS Centroids Index : " + e.getMessage());
            log.error("Unable to gather information on public GIS Centroids Index", (Throwable)e);
        }
        return toReturn;
    }

    protected Document getPublicIndexParams(BaseRequest req) {
        Document callParameters = new Document();
        callParameters.put("workspace", (Object)Files.fixFilename((String)(req.getUseCaseDescriptor().getId() + req.getContext().getName())));
        callParameters.put("indexName", (Object)Files.fixFilename((String)(req.getUseCaseDescriptor().getId() + req.getContext().getName() + "_centroids")));
        return callParameters;
    }

    protected Document getMaterializationParameters(BaseRequest request) {
        Document params = new Document();
        String workspace = request.getUseCaseDescriptor().getId() + request.getContext().getId();
        params.put("workspace", (Object)Files.fixFilename((String)workspace));
        return params;
    }

    @Override
    protected void registerSteps() {
        this.setStep(new GuardedStepExecution(Steps.PUBLISH){

            @Override
            protected StepExecutionReport run() throws Exception {
                for (MaterializationPlugin mat : SimpleLifeCycleManager.this.getMaterializers((BaseRequest)((StepExecutionReport)this.theReport).getTheRequest())) {
                    this.theReport = SimpleLifeCycleManager.this.materializeDocument((StepExecutionReport)this.theReport, mat, SimpleLifeCycleManager.this.getMaterializationParameters((BaseRequest)((StepExecutionReport)this.theReport).getTheRequest()));
                }
                if (((StepExecutionReport)this.theReport).getToSetLifecycleInformation().getLastOperationStatus().equals((Object)LifecycleInformation.Status.OK)) {
                    for (IndexerPluginInterface indexer : SimpleLifeCycleManager.this.getIndexers((BaseRequest)((StepExecutionReport)this.theReport).getTheRequest())) {
                        this.theReport = SimpleLifeCycleManager.this.index((StepExecutionReport)this.theReport, indexer, SimpleLifeCycleManager.this.getPublicIndexParams((BaseRequest)((StepExecutionReport)this.theReport).getTheRequest()));
                    }
                    if (((StepExecutionReport)this.theReport).getToSetLifecycleInformation().getLastOperationStatus().equals((Object)LifecycleInformation.Status.OK)) {
                        ((StepExecutionReport)this.theReport).getToSetLifecycleInformation().setPhase("PUBLISHED");
                    }
                }
                return (StepExecutionReport)this.theReport;
            }
        });
    }

    protected void blockNonDraft(EventExecutionReport report) throws InvalidPluginRequestException {
        Boolean force = false;
        try {
            force = Boolean.parseBoolean(((EventExecutionRequest)report.getTheRequest()).getCallParameters().get((Object)"force").toString());
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (!((EventExecutionRequest)report.getTheRequest()).getDocument().getLifecycleInformation().getPhase().equals("DRAFT") && !force.booleanValue()) {
            throw new InvalidPluginRequestException("Document is not in DRAFT phase");
        }
    }

    @Override
    protected EventExecutionReport onInitDocument(EventExecutionReport report) throws InvalidPluginRequestException {
        this.blockNonDraft(report);
        return super.onInitDocument(report);
    }

    @Override
    protected EventExecutionReport onUpdateDocument(EventExecutionReport report) {
        return super.onUpdateDocument(report);
    }

    @Override
    protected EventExecutionReport onDeleteDocument(EventExecutionReport report) throws ConfigurationException, InvalidPluginRequestException, MaterializationException, EventException {
        Boolean force = Boolean.parseBoolean(((EventExecutionRequest)report.getTheRequest()).getWithDefault("force", "false"));
        log.debug("ON DELETE for {} : force is {}", (Object)((EventExecutionRequest)report.getTheRequest()).getDocument().getId(), (Object)force);
        if (!force.booleanValue()) {
            this.blockNonDraft(report);
        }
        JSONPathWrapper wrapper = new JSONPathWrapper(((EventExecutionRequest)report.getTheRequest()).getDocument().getTheDocument().toJson());
        for (String s : wrapper.getMatchingPaths("$..[?(@._payloads)]")) {
            log.info("Requesting dematerialization for {} ", (Object)s);
            for (MaterializationPlugin mat : this.getMaterializers((BaseRequest)report.getTheRequest())) {
                report = this.deMaterialize(report, mat, new Document("fileSetPath", (Object)s));
            }
            if (report.getToSetLifecycleInformation().getLastOperationStatus().equals((Object)LifecycleInformation.Status.OK)) continue;
            break;
        }
        if (report.getToSetLifecycleInformation().getLastOperationStatus().equals((Object)LifecycleInformation.Status.OK)) {
            for (IndexerPluginInterface indexer : this.getIndexers((BaseRequest)report.getTheRequest())) {
                report = this.deIndex(report, indexer, this.getPublicIndexParams((BaseRequest)report.getTheRequest()));
            }
        }
        return report;
    }

    @Override
    protected EventExecutionReport onDeleteFileSet(EventExecutionReport theReport) throws ConfigurationException, InvalidPluginRequestException, MaterializationException, EventException {
        this.blockNonDraft(theReport);
        for (MaterializationPlugin mat : this.getMaterializers((BaseRequest)theReport.getTheRequest())) {
            this.deMaterialize(theReport, mat, ((EventExecutionRequest)theReport.getTheRequest()).getCallParameters());
        }
        for (IndexerPluginInterface indexer : this.getIndexers((BaseRequest)theReport.getTheRequest())) {
            if (!theReport.getToSetLifecycleInformation().getLastOperationStatus().equals((Object)LifecycleInformation.Status.OK)) continue;
            this.deIndex(theReport, indexer, this.getPublicIndexParams((BaseRequest)theReport.getTheRequest()));
        }
        return theReport;
    }

    @Override
    protected void registerEvents() {
        super.registerEvents();
    }

    protected List<IndexerPluginInterface> getIndexers(BaseRequest request) throws ConfigurationException {
        log.trace("Looking for Indexers for {}", (Object)request);
        ArrayList<IndexerPluginInterface> toReturn = new ArrayList<IndexerPluginInterface>();
        UseCaseDescriptor desc = request.getUseCaseDescriptor();
        List indexers = desc.getHandlersByType("Indexer");
        log.debug("Found UCD [{}] Indexers : {}", (Object)desc.getId(), (Object)indexers.size());
        for (HandlerDeclaration handlerDeclaration : indexers) {
            toReturn.add((IndexerPluginInterface)this.pluginManager.getById(handlerDeclaration.getId()));
        }
        return toReturn;
    }

    protected List<MaterializationPlugin> getMaterializers(BaseRequest request) throws ConfigurationException {
        log.trace("Looking for materializers for {}", (Object)request);
        ArrayList<MaterializationPlugin> toReturn = new ArrayList<MaterializationPlugin>();
        UseCaseDescriptor desc = request.getUseCaseDescriptor();
        List materializers = desc.getHandlersByType("Materializer");
        log.debug("Found UCD [{}] Materializers : {}", (Object)desc.getId(), (Object)materializers.size());
        for (HandlerDeclaration handlerDeclaration : materializers) {
            toReturn.add((MaterializationPlugin)this.pluginManager.getById(handlerDeclaration.getId()));
        }
        return toReturn;
    }

    protected <T extends DocumentHandlingReport> T deIndex(T report, IndexerPluginInterface indexer, Document parameters) throws InvalidPluginRequestException {
        Object request = report.getTheRequest();
        IndexDocumentRequest indexRequest = new IndexDocumentRequest(((BaseRequest)request).getUseCaseDescriptor(), ((BaseRequest)request).getCaller(), ((BaseRequest)request).getContext(), ((BaseExecutionRequest)request).getDocument());
        indexRequest.setCallParameters(parameters);
        IndexDocumentReport indexReport = indexer.deindex(indexRequest);
        return this.handleReport(indexReport, report);
    }

    protected <T extends DocumentHandlingReport> T deMaterialize(T report, MaterializationPlugin plugin, Document parameters) throws InvalidPluginRequestException, MaterializationException {
        Object request = report.getTheRequest();
        MaterializationRequest matReq = new MaterializationRequest(((BaseRequest)request).getUseCaseDescriptor(), ((BaseRequest)request).getCaller(), ((BaseRequest)request).getContext(), ((BaseExecutionRequest)request).getDocument());
        Document params = new Document();
        params.putAll((Map)parameters);
        String workspace = ((BaseRequest)request).getUseCaseDescriptor().getId() + ((BaseRequest)request).getContext().getId();
        params.put("workspace", (Object)Files.fixFilename((String)workspace));
        matReq.setCallParameters(params);
        MaterializationReport matRep = plugin.dematerialize(matReq);
        return this.handleReport(matRep, report);
    }

    protected <T extends DocumentHandlingReport> T index(T report, IndexerPluginInterface indexer, Document parameters) throws InvalidPluginRequestException {
        Object request = report.getTheRequest();
        IndexDocumentRequest indexRequest = new IndexDocumentRequest(((BaseRequest)request).getUseCaseDescriptor(), ((BaseRequest)request).getCaller(), ((BaseRequest)request).getContext(), ((BaseExecutionRequest)request).getDocument());
        indexRequest.setCallParameters(parameters);
        IndexDocumentReport indexReport = null;
        try {
            indexRequest.setCallParameters(this.evaluateAdditionalIndexParameters(indexRequest));
            indexReport = indexer.index(indexRequest);
        }
        catch (IndexingException e) {
            log.error("Unable to serve index request.", (Throwable)e);
            indexReport = new IndexDocumentReport(indexRequest);
            indexReport.setStatus(Report.Status.ERROR);
            indexReport.setMessages(new ArrayList<String>());
            indexReport.getMessages().add("Unable to evaluate centroids : " + e.getMessage());
        }
        return this.handleReport(indexReport, report);
    }

    protected Document evaluateAdditionalIndexParameters(IndexDocumentRequest request) throws IndexingException {
        return request.getCallParameters();
    }

    protected <T extends DocumentHandlingReport> T materializeDocument(T report, MaterializationPlugin plugin, Document parameters) throws InvalidPluginRequestException, MaterializationException {
        Object request = report.getTheRequest();
        MaterializationRequest matReq = new MaterializationRequest(((BaseRequest)request).getUseCaseDescriptor(), ((BaseRequest)request).getCaller(), ((BaseRequest)request).getContext(), ((BaseExecutionRequest)request).getDocument());
        matReq.setCallParameters(parameters);
        MaterializationReport matRep = plugin.materialize(matReq);
        return this.handleReport(matRep, report);
    }

    private <T extends DocumentHandlingReport> T handleReport(DocumentHandlingReport toHandle, T toUpdate) {
        toUpdate.setResultingDocument(toHandle.getResultingDocument());
        LifecycleInformation info = toUpdate.getToSetLifecycleInformation();
        switch (toHandle.getStatus()) {
            case OK: {
                info.setLastOperationStatus(LifecycleInformation.Status.OK);
                if (toHandle instanceof IndexDocumentReport) {
                    toUpdate.setToSetIdentificationReferences(((IndexDocumentReport)toHandle).getToSetIdentificationReferences());
                }
                ((BaseExecutionRequest)toUpdate.getTheRequest()).getDocument().setTheDocument(toHandle.getResultingDocument());
                toUpdate.setToSetLifecycleInformation(toHandle.getToSetLifecycleInformation());
                break;
            }
            case ERROR: {
                info.setLastOperationStatus(LifecycleInformation.Status.ERROR);
                toHandle.getMessages().forEach(s -> info.addErrorMessage(s));
                break;
            }
            case WARNING: {
                info.setLastOperationStatus(LifecycleInformation.Status.WARNING);
                toHandle.getMessages().forEach(s -> info.addWarningMessage(s));
            }
        }
        return toUpdate;
    }

    private static class Steps {
        public static final OperationDescriptor PUBLISH = new OperationDescriptor("PUBLISH", "Materialize & index project");

        private Steps() {
        }

        static {
            PUBLISH.setAppliableToPhases(Collections.singletonList("DRAFT"));
        }
    }
}

