/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.application.cms.plugins.implementations;

import java.util.HashMap;
import java.util.Map;
import org.gcube.application.cms.implementations.ProjectAccess;
import org.gcube.application.cms.plugins.LifecycleManager;
import org.gcube.application.cms.plugins.PluginManagerInterface;
import org.gcube.application.cms.plugins.faults.EventException;
import org.gcube.application.cms.plugins.faults.InitializationException;
import org.gcube.application.cms.plugins.faults.InsufficientPrivileges;
import org.gcube.application.cms.plugins.faults.InvalidPluginRequestException;
import org.gcube.application.cms.plugins.faults.InvalidProfileException;
import org.gcube.application.cms.plugins.faults.MaterializationException;
import org.gcube.application.cms.plugins.faults.ShutDownException;
import org.gcube.application.cms.plugins.faults.StepException;
import org.gcube.application.cms.plugins.faults.UnrecognizedEventException;
import org.gcube.application.cms.plugins.faults.UnrecognizedStepException;
import org.gcube.application.cms.plugins.implementations.AbstractPlugin;
import org.gcube.application.cms.plugins.implementations.RoleManager;
import org.gcube.application.cms.plugins.implementations.executions.GuardedEventManager;
import org.gcube.application.cms.plugins.implementations.executions.GuardedStepExecution;
import org.gcube.application.cms.plugins.reports.EventExecutionReport;
import org.gcube.application.cms.plugins.reports.InitializationReport;
import org.gcube.application.cms.plugins.reports.Report;
import org.gcube.application.cms.plugins.reports.StepExecutionReport;
import org.gcube.application.cms.plugins.requests.BaseRequest;
import org.gcube.application.cms.plugins.requests.EventExecutionRequest;
import org.gcube.application.cms.plugins.requests.StepExecutionRequest;
import org.gcube.application.geoportal.common.model.configuration.Configuration;
import org.gcube.application.geoportal.common.model.document.accounting.User;
import org.gcube.application.geoportal.common.model.document.lifecycle.LifecycleInformation;
import org.gcube.application.geoportal.common.model.document.lifecycle.TriggeredEvents;
import org.gcube.application.geoportal.common.model.plugins.LifecycleManagerDescriptor;
import org.gcube.application.geoportal.common.model.plugins.OperationDescriptor;
import org.gcube.application.geoportal.common.model.plugins.PluginDescriptor;
import org.gcube.application.geoportal.common.model.rest.ConfigurationException;
import org.gcube.application.geoportal.common.model.useCaseDescriptor.HandlerDeclaration;
import org.gcube.application.geoportal.common.utils.ContextUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractLifeCycleManager
extends AbstractPlugin
implements LifecycleManager {
    private static final Logger log = LoggerFactory.getLogger(AbstractLifeCycleManager.class);
    protected PluginManagerInterface pluginManager;
    protected ProjectAccess projectAccess;
    private Map<String, GuardedStepExecution> registeredSteps = new HashMap<String, GuardedStepExecution>();
    private Map<String, GuardedEventManager> registeredEvent = new HashMap<String, GuardedEventManager>();
    protected LifecycleManagerDescriptor DESCRIPTOR = new LifecycleManagerDescriptor(";;;");

    protected void setEvent(GuardedEventManager m) {
        OperationDescriptor op = m.getOp();
        this.DESCRIPTOR.getSupportedEvents().put(op.getId(), op);
        this.registeredEvent.put(op.getId(), m);
    }

    protected void setStep(GuardedStepExecution e) {
        OperationDescriptor op = e.getOp();
        this.DESCRIPTOR.getSupportedSteps().put(op.getId(), op);
        this.registeredSteps.put(op.getId(), e);
    }

    public AbstractLifeCycleManager() {
        this.DESCRIPTOR.setSupportedSteps(new HashMap());
        this.DESCRIPTOR.setSupportedEvents(new HashMap());
        this.registerEvents();
        this.registerSteps();
    }

    protected EventExecutionReport onDeleteDocument(EventExecutionReport report) throws ConfigurationException, InvalidPluginRequestException, MaterializationException, EventException {
        return report;
    }

    protected EventExecutionReport onDeleteFileSet(EventExecutionReport report) throws ConfigurationException, InvalidPluginRequestException, MaterializationException, EventException {
        return report;
    }

    protected EventExecutionReport onUpdateDocument(EventExecutionReport report) {
        report = this.validate(report);
        report = this.setDefault(report);
        return report;
    }

    protected EventExecutionReport onInitDocument(EventExecutionReport report) throws InvalidPluginRequestException {
        report = this.validate(report);
        report = this.setDefault(report);
        return report;
    }

    protected void registerEvents() {
        this.setEvent(new GuardedEventManager(Events.INIT){

            @Override
            protected EventExecutionReport run() throws Exception {
                return AbstractLifeCycleManager.this.onInitDocument((EventExecutionReport)this.theReport);
            }
        });
        this.setEvent(new GuardedEventManager(Events.UPDATE){

            @Override
            protected EventExecutionReport run() throws Exception {
                return AbstractLifeCycleManager.this.onUpdateDocument((EventExecutionReport)this.theReport);
            }
        });
        this.setEvent(new GuardedEventManager(Events.DELETE){

            @Override
            protected EventExecutionReport run() throws Exception {
                return AbstractLifeCycleManager.this.onDeleteDocument((EventExecutionReport)this.theReport);
            }
        });
        this.setEvent(new GuardedEventManager(Events.DELETE_FS){

            @Override
            protected EventExecutionReport run() throws Exception {
                return AbstractLifeCycleManager.this.onDeleteFileSet((EventExecutionReport)this.theReport);
            }
        });
    }

    protected void registerSteps() {
    }

    @Override
    public StepExecutionReport performStep(StepExecutionRequest request) throws StepException, InvalidPluginRequestException, InvalidProfileException, ConfigurationException, InsufficientPrivileges {
        log.info("Serving Request {}", (Object)request);
        log.debug("Checking is STEP {} is supported by {}", (Object)request.getStep(), (Object)this.DESCRIPTOR.getId());
        if (!this.registeredSteps.containsKey(request.getStep())) {
            throw new UnrecognizedStepException("Invalid Step " + request.getStep());
        }
        HandlerDeclaration handlerDeclaration = this.getConfigurationFromProfile(request.getUseCaseDescriptor());
        log.debug("Checking user role {} against config {} ", (Object)request.getCaller(), (Object)handlerDeclaration);
        if (!this.canInvokeStep(request.getStep(), request.getCaller(), handlerDeclaration)) {
            throw new InsufficientPrivileges("User is not allowed to invoke " + request.getStep());
        }
        StepExecutionReport report = new StepExecutionReport(request);
        LifecycleInformation info = report.getToSetLifecycleInformation();
        report.setStatus(Report.Status.OK);
        info.setLastOperationStatus(LifecycleInformation.Status.OK);
        info.setLastInvokedStep(request.getStep());
        try {
            GuardedStepExecution exec = this.registeredSteps.get(request.getStep());
            exec.setTheReport(report);
            exec.setHandlerConfiguration(handlerDeclaration);
            log.debug("Actually executing Step with {} ", (Object)exec);
            return (StepExecutionReport)exec.execute();
        }
        catch (InvalidPluginRequestException | StepException e) {
            throw e;
        }
        catch (Throwable t) {
            log.error("Unable to perform step " + request.getStep(), t);
            String msg = "Unable to execute Step " + request.getStep() + ". Error was " + t.getMessage();
            report.setStatus(Report.Status.ERROR);
            report.putMessage(msg);
            info.setLastOperationStatus(LifecycleInformation.Status.ERROR);
            info.addErrorMessage(msg);
            return report;
        }
    }

    protected boolean canInvokeStep(String stepID, User u, HandlerDeclaration config) throws ConfigurationException {
        return new RoleManager(config).canInvokeStep(stepID, u);
    }

    @Override
    public InitializationReport initInContext() throws InitializationException {
        InitializationReport report = new InitializationReport();
        try {
            report.setStatus(Report.Status.OK);
        }
        catch (Throwable e) {
            log.error("Unable to initialize plugins in {} ", (Object)ContextUtils.getCurrentScope(), (Object)e);
            report.setStatus(Report.Status.WARNING);
            report.putMessage("Unable to initialize plugins in " + ContextUtils.getCurrentScope() + " : " + e.getMessage());
        }
        return report;
    }

    @Override
    public InitializationReport init() throws InitializationException {
        InitializationReport report = new InitializationReport();
        try {
            report.setStatus(Report.Status.OK);
        }
        catch (Throwable e) {
            log.error("Unable to initialize plugins ", e);
            report.setStatus(Report.Status.WARNING);
            report.putMessage("Unable to initialize plugins : " + e.getMessage());
        }
        return report;
    }

    @Override
    public PluginDescriptor getDescriptor() {
        return this.DESCRIPTOR;
    }

    @Override
    public EventExecutionReport onEvent(EventExecutionRequest request) throws EventException, InvalidPluginRequestException {
        log.info("Executing Event {}", (Object)request);
        EventExecutionReport report = new EventExecutionReport(request);
        report.getToSetLifecycleInformation().addEventReport(new TriggeredEvents());
        TriggeredEvents info = report.getToSetLifecycleInformation().getLastEvent();
        info.setLastOperationStatus(LifecycleInformation.Status.OK);
        info.setEvent(request.getEvent());
        try {
            if (!this.registeredEvent.containsKey(request.getEvent())) {
                throw new UnrecognizedEventException("Unexpected Event " + request.getEvent());
            }
            return this.registeredEvent.get(request.getEvent()).setTheReport(report).execute();
        }
        catch (EventException e) {
            throw e;
        }
        catch (Throwable t) {
            log.error("Unable to execute on event " + request.getEvent(), t);
            String msg = "Unable to execute on event " + request.getEvent() + ". Error was " + t.getMessage();
            info.setLastOperationStatus(LifecycleInformation.Status.ERROR);
            info.addErrorMessage(msg);
            report.setStatus(Report.Status.ERROR);
            report.putMessage(msg);
            return report;
        }
    }

    public EventExecutionReport setDefault(EventExecutionReport currentReport) {
        return currentReport;
    }

    public EventExecutionReport validate(EventExecutionReport currentReport) {
        return currentReport;
    }

    @Override
    public void shutdown() throws ShutDownException {
    }

    @Override
    public Configuration getCurrentConfiguration(BaseRequest request) throws ConfigurationException {
        return new Configuration();
    }

    @Override
    public void setPluginManager(PluginManagerInterface pluginManager) {
        this.pluginManager = pluginManager;
    }

    public void setProjectAccess(ProjectAccess projectAccess) {
        this.projectAccess = projectAccess;
    }

    protected static class Events {
        public static final OperationDescriptor INIT = new OperationDescriptor("INIT_DOCUMENT", "Sets defaults and validate");
        public static final OperationDescriptor UPDATE = new OperationDescriptor("UPDATE_DOCUMENT", "Sets defaults and validate");
        public static final OperationDescriptor DELETE = new OperationDescriptor("DELETE_DOCUMENT", "No op");
        public static final OperationDescriptor DELETE_FS = new OperationDescriptor("DELETE_FILESET", "No op");

        protected Events() {
        }
    }
}

