/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.application.cms.caches;

import lombok.NonNull;
import org.gcube.application.cms.caches.Engine;
import org.gcube.application.cms.caches.TimedMap;
import org.gcube.application.geoportal.common.model.rest.ConfigurationException;
import org.gcube.application.geoportal.common.utils.ContextUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractScopedMap<T>
extends TimedMap<String, T>
implements Engine<T> {
    private static final Logger log = LoggerFactory.getLogger(AbstractScopedMap.class);

    public AbstractScopedMap(@NonNull String name) {
        super(name);
        if (name == null) {
            throw new NullPointerException("name is marked @NonNull but is null");
        }
    }

    @Override
    public T getObject() throws ConfigurationException {
        return (T)this.get(ContextUtils.getCurrentScope());
    }

    @Override
    public void init() {
    }

    @Override
    public void shutdown() {
        log.warn(this.name + ": shutting down");
        this.scopeMap.forEach((s, o) -> {
            try {
                if (o != null && o.getTheObject() != null) {
                    this.dispose(o.getTheObject());
                }
            }
            catch (Throwable t) {
                log.warn(this.name + ": unable to dispose ", t);
            }
        });
    }
}

