/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.application.cms.implementations;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.gcube.application.cms.caches.Engine;
import org.gcube.application.cms.implementations.DefaultISProvider;
import org.gcube.application.cms.implementations.ISInterface;
import org.gcube.application.cms.implementations.StorageHubProvider;
import org.gcube.application.geoportal.common.model.rest.ConfigurationException;
import org.gcube.common.storagehub.client.dsl.StorageHubClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImplementationProvider {
    private static final Logger log = LoggerFactory.getLogger(ImplementationProvider.class);
    private static final Object $LOCK = new Object[0];
    private final Object $lock = new Object[0];
    private static ImplementationProvider instance = null;
    private ConcurrentHashMap<Class, Engine> implementationsRegistry = new ConcurrentHashMap();
    private boolean isInit = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ImplementationProvider get() {
        Object object = $LOCK;
        synchronized (object) {
            if (instance == null) {
                instance = new ImplementationProvider();
            }
            return instance;
        }
    }

    public <T> T getProvidedObjectByClass(Class<T> clazz) throws ConfigurationException {
        return this.implementationsRegistry.get(clazz).getObject();
    }

    public <T> Engine<T> getEngineByManagedClass(Class<T> clazz) throws ConfigurationException {
        return this.implementationsRegistry.get(clazz);
    }

    public <T> void setEngine(Engine<T> engine, Class<T> clazz) {
        this.implementationsRegistry.put(clazz, engine);
    }

    private ImplementationProvider() {
        this.setEngine(new DefaultISProvider(), ISInterface.class);
        this.setEngine(new StorageHubProvider(), StorageHubClient.class);
    }

    public Map<Class, String> getManagerList() {
        HashMap<Class, String> toReturn = new HashMap<Class, String>();
        this.implementationsRegistry.forEach((aClass, engine) -> toReturn.put(engine.getClass(), aClass.getCanonicalName()));
        return toReturn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initEngines() {
        Object object = this.$lock;
        synchronized (object) {
            if (!this.isInit) {
                log.info("INITIALIZING ENGINES. Size : {} ", (Object)this.implementationsRegistry.size());
                HashSet failed = new HashSet();
                this.implementationsRegistry.forEach((aClass, engine) -> {
                    log.info("Init : {} -> {}", (Object)engine.getClass().toGenericString(), (Object)aClass.getCanonicalName());
                    try {
                        engine.init();
                    }
                    catch (Throwable t) {
                        failed.add(engine.getClass());
                        log.error("Unable to start engine {} ", engine.getClass(), (Object)t);
                    }
                });
                if (failed.isEmpty()) {
                    log.info("INIT OK");
                } else {
                    log.warn("!!!!! Following  Engines FAILED INIT :");
                    failed.forEach(aClass -> log.warn(String.valueOf(aClass)));
                }
                this.isInit = true;
            } else {
                log.info("Received Init request but Engines already started");
            }
        }
    }

    public void shutdownEngines() {
        log.info("SHUTTING DOWN ENGINES. Size : {} ", (Object)this.implementationsRegistry.size());
        HashSet failed = new HashSet();
        this.implementationsRegistry.forEach((aClass, engine) -> {
            log.info("ShotDown : {} -> {}", (Object)engine.getClass().toGenericString(), (Object)aClass.getCanonicalName());
            try {
                engine.shutdown();
            }
            catch (Throwable t) {
                failed.add(engine.getClass());
                log.error("Unable to shutdown engine {} ", engine.getClass(), (Object)t);
            }
        });
        if (failed.isEmpty()) {
            log.info("SHUTDOWN OK");
        } else {
            log.warn("!!!!! Following  Engines FAILED SHUTDOWN :");
            failed.forEach(aClass -> log.warn(String.valueOf(aClass)));
        }
    }
}

