/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.application.aquamaps.aquamapsspeciesview.client.constants;

import com.google.gwt.core.client.GWT;
import com.google.gwt.i18n.client.DateTimeFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.gcube.application.aquamaps.aquamapsspeciesview.client.constants.AquaMapsSpeciesViewConstants;
import org.gcube.application.aquamaps.aquamapsspeciesview.client.rpc.fields.SpeciesFields;
import org.gcube.application.aquamaps.aquamapsspeciesview.client.rpc.types.ClientFieldType;
import org.gcube.application.aquamaps.aquamapsspeciesview.client.rpc.types.ClientFilterOperator;
import org.gcube.application.aquamaps.aquamapsspeciesview.client.rpc.types.ClientResourceType;

public class AquaMapsSpeciesViewConstants {
    public static String COMMONGUIDIV = "SPECIES_VIEW";
    public static final Map<String, String> servletUrl = new HashMap();
    public static final Map<ClientResourceType, String> resourceNames = new HashMap();
    public static final Map<SpeciesFields, String> speciesFieldsNames = new HashMap();
    public static final Map<String, String> mapFieldsNames = new HashMap();
    public static DateTimeFormat timeFormat = DateTimeFormat.getFormat((DateTimeFormat.PredefinedFormat)DateTimeFormat.PredefinedFormat.DATE_TIME_LONG);
    public static final Map<ClientFieldType, Object> defaultFilterValues = new HashMap();
    public static final Map<SpeciesFields, ClientFieldType> fieldTypes = new HashMap();
    public static final HashMap<ClientFieldType, ArrayList<ClientFilterOperator>> operatorsPerFieldType = new HashMap();
    public static final SpeciesFields[] nameSpeciesFields = new SpeciesFields[]{SpeciesFields.fbname, SpeciesFields.scientific_name, SpeciesFields.english_name, SpeciesFields.french_name, SpeciesFields.spanish_name};
    public static final SpeciesFields[] codesSpeciesFields = new SpeciesFields[]{SpeciesFields.speciesid, SpeciesFields.speccode};
    public static final SpeciesFields[] characteristicsSpeciesFields = new SpeciesFields[]{SpeciesFields.deepwater, SpeciesFields.m_mammals, SpeciesFields.angling, SpeciesFields.diving, SpeciesFields.dangerous, SpeciesFields.m_invertebrates, SpeciesFields.algae, SpeciesFields.seabirds, SpeciesFields.freshwater};
    public static final SpeciesFields[] taxonomySpeciesFields = new SpeciesFields[]{SpeciesFields.kingdom, SpeciesFields.phylum, SpeciesFields.classcolumn, SpeciesFields.ordercolumn, SpeciesFields.familycolumn, SpeciesFields.genus, SpeciesFields.species};
    private static final String BEGINS_LABEL = "Begins with";
    private static final String CONTAINS_LABEL = "Contains";
    private static final String ENDS_LABEL = "Ends with";
    private static final String GREATER_LABEL = ">";
    private static final String IS_LABEL = "IS";
    private static final String SMALLER_LABEL = "<";

    public static void init(String sessionId) {
        servletUrl.put("PhylogenyServlet", GWT.getModuleBaseURL() + "PhylogenyServlet" + ";jsessionid=" + sessionId);
        servletUrl.put("ResourceServlet", GWT.getModuleBaseURL() + "ResourceServlet" + ";jsessionid=" + sessionId);
        servletUrl.put("SpeciesServlet", GWT.getModuleBaseURL() + "SpeciesServlet" + ";jsessionid=" + sessionId);
        servletUrl.put("ImageServlet", GWT.getModuleBaseURL() + "ImageServlet");
        servletUrl.put("MapServlet", GWT.getModuleBaseURL() + "MapServlet" + ";jsessionid=" + sessionId);
        servletUrl.put("AquaMapsSpeciesViewLocalImpl", GWT.getModuleBaseURL() + "AquaMapsSpeciesViewLocalImpl" + ";jsessionid=" + sessionId);
        resourceNames.put(ClientResourceType.HCAF, "Environmental Data (" + ClientResourceType.HCAF + ")");
        resourceNames.put(ClientResourceType.HSPEC, "Simulation Data (" + ClientResourceType.HSPEC + ")");
        resourceNames.put(ClientResourceType.HSPEN, "Species Envelope Data (" + ClientResourceType.HSPEN + ")");
        resourceNames.put(ClientResourceType.OCCURRENCECELLS, "Species Occurrence Cells");
        speciesFieldsNames.put(SpeciesFields.genus, "Genus");
        speciesFieldsNames.put(SpeciesFields.species, "Species");
        speciesFieldsNames.put(SpeciesFields.fbname, "FishBase Name");
        speciesFieldsNames.put(SpeciesFields.speciesid, "Species ID");
        speciesFieldsNames.put(SpeciesFields.speccode, "Species Code");
        speciesFieldsNames.put(SpeciesFields.scientific_name, "Scientific Name");
        speciesFieldsNames.put(SpeciesFields.english_name, "English Name");
        speciesFieldsNames.put(SpeciesFields.french_name, "French Name");
        speciesFieldsNames.put(SpeciesFields.spanish_name, "Spanish Name");
        speciesFieldsNames.put(SpeciesFields.kingdom, "Kingdom");
        speciesFieldsNames.put(SpeciesFields.phylum, "Phylum");
        speciesFieldsNames.put(SpeciesFields.classcolumn, "Class");
        speciesFieldsNames.put(SpeciesFields.ordercolumn, "Order");
        speciesFieldsNames.put(SpeciesFields.familycolumn, "Family");
        speciesFieldsNames.put(SpeciesFields.deepwater, "Deepwater");
        speciesFieldsNames.put(SpeciesFields.m_mammals, "Mammal");
        speciesFieldsNames.put(SpeciesFields.angling, "Angling");
        speciesFieldsNames.put(SpeciesFields.diving, "Diving");
        speciesFieldsNames.put(SpeciesFields.dangerous, "Dangerous");
        speciesFieldsNames.put(SpeciesFields.m_invertebrates, "Invertebrate");
        speciesFieldsNames.put(SpeciesFields.algae, "Algae");
        speciesFieldsNames.put(SpeciesFields.seabirds, "Seabird");
        speciesFieldsNames.put(SpeciesFields.freshwater, "Freshwater");
        speciesFieldsNames.put(SpeciesFields.pelagic, "Pelagic");
        speciesFieldsNames.put(SpeciesFields.picname, "PicName");
        speciesFieldsNames.put(SpeciesFields.customized, "Customized");
        defaultFilterValues.put(ClientFieldType.BOOLEAN, Boolean.TRUE);
        defaultFilterValues.put(ClientFieldType.DOUBLE, new Double(0.0));
        defaultFilterValues.put(ClientFieldType.INTEGER, new Integer(0));
        defaultFilterValues.put(ClientFieldType.STRING, "");
        fieldTypes.put(SpeciesFields.genus, ClientFieldType.STRING);
        fieldTypes.put(SpeciesFields.species, ClientFieldType.STRING);
        fieldTypes.put(SpeciesFields.fbname, ClientFieldType.STRING);
        fieldTypes.put(SpeciesFields.speciesid, ClientFieldType.STRING);
        fieldTypes.put(SpeciesFields.speccode, ClientFieldType.INTEGER);
        fieldTypes.put(SpeciesFields.scientific_name, ClientFieldType.STRING);
        fieldTypes.put(SpeciesFields.english_name, ClientFieldType.STRING);
        fieldTypes.put(SpeciesFields.french_name, ClientFieldType.STRING);
        fieldTypes.put(SpeciesFields.spanish_name, ClientFieldType.STRING);
        fieldTypes.put(SpeciesFields.kingdom, ClientFieldType.STRING);
        fieldTypes.put(SpeciesFields.phylum, ClientFieldType.STRING);
        fieldTypes.put(SpeciesFields.classcolumn, ClientFieldType.STRING);
        fieldTypes.put(SpeciesFields.ordercolumn, ClientFieldType.STRING);
        fieldTypes.put(SpeciesFields.familycolumn, ClientFieldType.STRING);
        fieldTypes.put(SpeciesFields.deepwater, ClientFieldType.BOOLEAN);
        fieldTypes.put(SpeciesFields.m_mammals, ClientFieldType.BOOLEAN);
        fieldTypes.put(SpeciesFields.angling, ClientFieldType.BOOLEAN);
        fieldTypes.put(SpeciesFields.diving, ClientFieldType.BOOLEAN);
        fieldTypes.put(SpeciesFields.dangerous, ClientFieldType.BOOLEAN);
        fieldTypes.put(SpeciesFields.m_invertebrates, ClientFieldType.BOOLEAN);
        fieldTypes.put(SpeciesFields.algae, ClientFieldType.BOOLEAN);
        fieldTypes.put(SpeciesFields.seabirds, ClientFieldType.BOOLEAN);
        fieldTypes.put(SpeciesFields.freshwater, ClientFieldType.BOOLEAN);
        fieldTypes.put(SpeciesFields.pelagic, ClientFieldType.BOOLEAN);
        ArrayList<ClientFilterOperator> stringOperators = new ArrayList<ClientFilterOperator>();
        stringOperators.add(ClientFilterOperator.begins);
        stringOperators.add(ClientFilterOperator.contains);
        stringOperators.add(ClientFilterOperator.ends);
        stringOperators.add(ClientFilterOperator.is);
        operatorsPerFieldType.put(ClientFieldType.STRING, stringOperators);
        ArrayList<ClientFilterOperator> numberOperators = new ArrayList<ClientFilterOperator>();
        numberOperators.add(ClientFilterOperator.greater_then);
        numberOperators.add(ClientFilterOperator.smaller_then);
        operatorsPerFieldType.put(ClientFieldType.DOUBLE, numberOperators);
        operatorsPerFieldType.put(ClientFieldType.INTEGER, numberOperators);
        ArrayList<ClientFilterOperator> booleanOperators = new ArrayList<ClientFilterOperator>();
        booleanOperators.add(ClientFilterOperator.is);
        operatorsPerFieldType.put(ClientFieldType.BOOLEAN, booleanOperators);
        mapFieldsNames.put("algorithm", "Algorithm");
        mapFieldsNames.put("author", "Author");
        mapFieldsNames.put("coverage_field", "Coverage");
        mapFieldsNames.put("creation_date", "Creation Time");
        mapFieldsNames.put("data_generation_time", "Data Generation Time");
        mapFieldsNames.put("fileset_id", "FileSet id");
        mapFieldsNames.put("gis", "GIS Data");
        mapFieldsNames.put("image_count", "Static images");
        mapFieldsNames.put("image_list", "Images");
        mapFieldsNames.put("layer_id", "Layer id");
        mapFieldsNames.put("layer_preview", "Layer Preview url");
        mapFieldsNames.put("layer_url", "Layer url");
        mapFieldsNames.put("resource_id", "HSPEC ID");
        mapFieldsNames.put("species_list", "Selected Species");
        mapFieldsNames.put("thumbnail", "Map Thumbnail");
        mapFieldsNames.put("title", "Title");
        mapFieldsNames.put("type_field", "Map Type");
        mapFieldsNames.put("custom", "Is Customized");
    }

    public static final String getOperatorLabel(ClientFilterOperator op) {
        switch (1.$SwitchMap$org$gcube$application$aquamaps$aquamapsspeciesview$client$rpc$types$ClientFilterOperator[op.ordinal()]) {
            case 1: {
                return BEGINS_LABEL;
            }
            case 2: {
                return CONTAINS_LABEL;
            }
            case 3: {
                return ENDS_LABEL;
            }
            case 4: {
                return GREATER_LABEL;
            }
            case 5: {
                return IS_LABEL;
            }
            case 6: {
                return SMALLER_LABEL;
            }
        }
        throw new IllegalArgumentException("unable to handle " + op);
    }

    public static final ClientFilterOperator getOperatorFromString(String label) {
        if (label.equals(BEGINS_LABEL)) {
            return ClientFilterOperator.begins;
        }
        if (label.equals(CONTAINS_LABEL)) {
            return ClientFilterOperator.contains;
        }
        if (label.equals(ENDS_LABEL)) {
            return ClientFilterOperator.ends;
        }
        if (label.equals(GREATER_LABEL)) {
            return ClientFilterOperator.greater_then;
        }
        if (label.equals(IS_LABEL)) {
            return ClientFilterOperator.is;
        }
        if (label.equals(SMALLER_LABEL)) {
            return ClientFilterOperator.smaller_then;
        }
        throw new IllegalArgumentException(label + " is not a valid ClientFieldOperator label");
    }
}

