/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.application.aquamaps.aquamapsservice.stubs.datamodel.enhanced;

import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.gcube.application.aquamaps.aquamapsservice.stubs.datamodel.enhanced.DataModel;
import org.gcube.application.aquamaps.aquamapsservice.stubs.datamodel.enhanced.Field;
import org.gcube.application.aquamaps.aquamapsservice.stubs.datamodel.fields.AnalysisFields;
import org.gcube.application.aquamaps.aquamapsservice.stubs.datamodel.json.JSONException;
import org.gcube.application.aquamaps.aquamapsservice.stubs.datamodel.types.AnalysisType;
import org.gcube.application.aquamaps.aquamapsservice.stubs.datamodel.types.FieldType;
import org.gcube.application.aquamaps.aquamapsservice.stubs.datamodel.types.SubmittedStatus;
import org.gcube.application.aquamaps.aquamapsservice.stubs.datamodel.utils.CSVUtils;
import org.gcube.common.core.utils.logging.GCUBELog;

public class Analysis
extends DataModel {
    static GCUBELog logger = new GCUBELog(Analysis.class);
    private String id;
    private String title;
    private String author;
    private String description;
    private SubmittedStatus status = SubmittedStatus.Pending;
    private Long submissiontime = 0L;
    private Long endtime = 0L;
    private Long starttime = 0L;
    private Double currentphasepercent = 0.0;
    private ArrayList<Integer> reportID = new ArrayList();
    private ArrayList<AnalysisType> type = new ArrayList();
    private String archiveLocation;
    private ArrayList<Integer> sources = new ArrayList();
    private ArrayList<AnalysisType> performedAnalysis = new ArrayList();

    public Analysis() {
    }

    public static ArrayList<Analysis> loadResultSet(ResultSet rs) throws Exception {
        ArrayList<Analysis> toReturn = new ArrayList<Analysis>();
        while (rs.next()) {
            toReturn.add(new Analysis(Field.loadRow(rs)));
        }
        return toReturn;
    }

    public Analysis(ResultSet rs) throws Exception {
        this(Field.loadRow(rs));
    }

    public Analysis(List<Field> row) {
        for (Field f : row) {
            try {
                this.setField(f);
            }
            catch (Exception e) {}
        }
    }

    public boolean setField(Field f) throws JSONException {
        try {
            switch (AnalysisFields.valueOf(f.getName().toLowerCase())) {
                case author: {
                    this.setAuthor(f.getValue());
                    break;
                }
                case currentphasepercent: {
                    this.setCurrentphasepercent(f.getValueAsDouble());
                    break;
                }
                case description: {
                    this.setDescription(f.getValue());
                    break;
                }
                case endtime: {
                    this.setEndtime(f.getValueAsLong());
                    break;
                }
                case reportid: {
                    this.setReportID(CSVUtils.CSVTOIntegerList(f.getValue()));
                    break;
                }
                case starttime: {
                    this.setStarttime(f.getValueAsLong());
                    break;
                }
                case submissiontime: {
                    this.setSubmissiontime(f.getValueAsLong());
                    break;
                }
                case id: {
                    this.setId(f.getValue());
                    break;
                }
                case archivelocation: {
                    this.setArchiveLocation(f.getValue());
                    break;
                }
                case sources: {
                    this.setSources(CSVUtils.CSVTOIntegerList(f.getValue()));
                    break;
                }
                case status: {
                    this.setStatus(SubmittedStatus.valueOf(f.getValue()));
                    break;
                }
                case title: {
                    this.setTitle(f.getValue());
                    break;
                }
                case type: {
                    this.setType((List<String>)CSVUtils.CSVToStringList(f.getValue()));
                    break;
                }
                case performedanalysis: {
                    this.setPerformedAnalysis((List<String>)CSVUtils.CSVToStringList(f.getValue()));
                    break;
                }
                default: {
                    return false;
                }
            }
        }
        catch (Exception e) {
            logger.warn((Object)("Unable to parse field " + f.toJSONObject()), (Throwable)e);
        }
        return true;
    }

    public Field getField(AnalysisFields fieldName) throws JSONException {
        switch (fieldName) {
            case author: {
                return new Field((Object)((Object)fieldName) + "", this.getAuthor(), FieldType.STRING);
            }
            case currentphasepercent: {
                return new Field((Object)((Object)fieldName) + "", this.getCurrentphasepercent() + "", FieldType.DOUBLE);
            }
            case description: {
                return new Field((Object)((Object)fieldName) + "", this.getDescription(), FieldType.STRING);
            }
            case id: {
                return new Field((Object)((Object)fieldName) + "", this.getId(), FieldType.STRING);
            }
            case reportid: {
                return new Field((Object)((Object)fieldName) + "", CSVUtils.listToCSV(this.reportID), FieldType.STRING);
            }
            case starttime: {
                return new Field((Object)((Object)fieldName) + "", this.getStarttime() + "", FieldType.LONG);
            }
            case submissiontime: {
                return new Field((Object)((Object)fieldName) + "", this.getSubmissiontime() + "", FieldType.LONG);
            }
            case archivelocation: {
                return new Field((Object)((Object)fieldName) + "", this.getArchiveLocation(), FieldType.STRING);
            }
            case endtime: {
                return new Field((Object)((Object)fieldName) + "", this.getEndtime() + "", FieldType.INTEGER);
            }
            case sources: {
                return new Field((Object)((Object)fieldName) + "", CSVUtils.listToCSV(this.sources), FieldType.STRING);
            }
            case status: {
                return new Field((Object)((Object)fieldName) + "", (Object)((Object)this.getStatus()) + "", FieldType.STRING);
            }
            case title: {
                return new Field((Object)((Object)fieldName) + "", this.getTitle(), FieldType.STRING);
            }
            case type: {
                return new Field((Object)((Object)fieldName) + "", CSVUtils.listToCSV(this.getType()), FieldType.STRING);
            }
            case performedanalysis: {
                return new Field((Object)((Object)fieldName) + "", CSVUtils.listToCSV(this.getPerformedAnalysis()), FieldType.STRING);
            }
        }
        return null;
    }

    public List<Field> toRow() throws JSONException {
        ArrayList<Field> toReturn = new ArrayList<Field>();
        for (AnalysisFields f : AnalysisFields.values()) {
            toReturn.add(this.getField(f));
        }
        return toReturn;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getAuthor() {
        return this.author;
    }

    public void setAuthor(String author) {
        this.author = author;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public SubmittedStatus getStatus() {
        return this.status;
    }

    public void setStatus(SubmittedStatus status) {
        this.status = status;
    }

    public Long getSubmissiontime() {
        return this.submissiontime;
    }

    public void setSubmissiontime(Long submissiontime) {
        this.submissiontime = submissiontime;
    }

    public Long getEndtime() {
        return this.endtime;
    }

    public void setEndtime(Long endtime) {
        this.endtime = endtime;
    }

    public Long getStarttime() {
        return this.starttime;
    }

    public void setStarttime(Long starttime) {
        this.starttime = starttime;
    }

    public Double getCurrentphasepercent() {
        return this.currentphasepercent;
    }

    public void setCurrentphasepercent(Double currentphasepercent) {
        this.currentphasepercent = currentphasepercent;
    }

    public ArrayList<Integer> getReportID() {
        return this.reportID;
    }

    public void setReportID(List<Integer> reportID) {
        this.reportID.clear();
        this.reportID.addAll(reportID);
        Collections.sort(this.reportID);
    }

    public ArrayList<AnalysisType> getType() {
        return this.type;
    }

    public void addReportId(Integer id) {
        this.reportID.add(id);
        Collections.sort(this.reportID);
    }

    public void removeReportId(Integer id) {
        this.reportID.remove(id);
        Collections.sort(this.reportID);
    }

    public void setType(ArrayList<AnalysisType> type) {
        this.type.clear();
        this.type.addAll(type);
        Collections.sort(this.type);
    }

    public void setType(List<String> typeStrings) {
        ArrayList<AnalysisType> types = new ArrayList<AnalysisType>();
        for (String s : typeStrings) {
            types.add(AnalysisType.valueOf(s));
        }
        this.setType(types);
    }

    public String getArchiveLocation() {
        return this.archiveLocation;
    }

    public void setArchiveLocation(String archiveLocation) {
        this.archiveLocation = archiveLocation;
    }

    public ArrayList<Integer> getSources() {
        return this.sources;
    }

    public void setSources(List<Integer> sources) {
        this.sources.clear();
        this.sources.addAll(sources);
        Collections.sort(this.sources);
    }

    public void setPerformedAnalysis(ArrayList<AnalysisType> performedAnalysis) {
        this.performedAnalysis.clear();
        this.performedAnalysis.addAll(performedAnalysis);
        Collections.sort(this.performedAnalysis);
    }

    public ArrayList<AnalysisType> getPerformedAnalysis() {
        return this.performedAnalysis;
    }

    public void setPerformedAnalysis(List<String> toSet) {
        ArrayList<AnalysisType> types = new ArrayList<AnalysisType>();
        for (String s : toSet) {
            types.add(AnalysisType.valueOf(s));
        }
        this.setPerformedAnalysis(types);
    }

    public void addPerformedAnalysis(AnalysisType toAdd) {
        this.performedAnalysis.add(toAdd);
        Collections.sort(this.performedAnalysis);
    }

    public org.gcube.application.aquamaps.datamodel.Analysis toStubsVersion() {
        org.gcube.application.aquamaps.datamodel.Analysis toReturn = new org.gcube.application.aquamaps.datamodel.Analysis();
        toReturn.setArchiveLocation(this.archiveLocation);
        toReturn.setAuthor(this.author);
        toReturn.setCurrentPhasePercent(this.currentphasepercent);
        toReturn.setDescription(this.description);
        toReturn.setEndTime(this.endtime);
        toReturn.setId(this.id);
        toReturn.setReportIds(CSVUtils.listToCSV(this.reportID));
        toReturn.setSources(CSVUtils.listToCSV(this.sources));
        toReturn.setStartTime(this.starttime);
        toReturn.setStatus((Object)((Object)this.status) + "");
        toReturn.setSubmissionTime(this.submissiontime);
        toReturn.setTitle(this.title);
        toReturn.setType(CSVUtils.listToCSV(this.type));
        toReturn.setPerformedAnalysis(CSVUtils.listToCSV(this.performedAnalysis));
        return toReturn;
    }

    public Analysis(org.gcube.application.aquamaps.datamodel.Analysis stubs) {
        this.setArchiveLocation(stubs.getArchiveLocation());
        this.setAuthor(stubs.getAuthor());
        this.setCurrentphasepercent(stubs.getCurrentPhasePercent());
        this.setDescription(stubs.getDescription());
        this.setEndtime(stubs.getEndTime());
        this.setId(stubs.getId());
        this.setReportID(CSVUtils.CSVTOIntegerList(stubs.getReportIds()));
        this.setSources(CSVUtils.CSVTOIntegerList(stubs.getSources()));
        this.setStarttime(stubs.getStartTime());
        this.setStatus(SubmittedStatus.valueOf(stubs.getStatus()));
        this.setSubmissiontime(stubs.getSubmissionTime());
        this.setTitle(stubs.getTitle());
        this.setType((List<String>)CSVUtils.CSVToStringList(stubs.getType()));
        this.setPerformedAnalysis((List<String>)CSVUtils.CSVToStringList(stubs.getPerformedAnalysis()));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.archiveLocation == null ? 0 : this.archiveLocation.hashCode());
        result = 31 * result + (this.author == null ? 0 : this.author.hashCode());
        result = 31 * result + (this.currentphasepercent == null ? 0 : this.currentphasepercent.hashCode());
        result = 31 * result + (this.description == null ? 0 : this.description.hashCode());
        result = 31 * result + (this.endtime == null ? 0 : this.endtime.hashCode());
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        result = 31 * result + (this.reportID == null ? 0 : this.reportID.hashCode());
        result = 31 * result + (this.sources == null ? 0 : this.sources.hashCode());
        result = 31 * result + (this.starttime == null ? 0 : this.starttime.hashCode());
        result = 31 * result + (this.status == null ? 0 : this.status.hashCode());
        result = 31 * result + (this.submissiontime == null ? 0 : this.submissiontime.hashCode());
        result = 31 * result + (this.title == null ? 0 : this.title.hashCode());
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Analysis other = (Analysis)obj;
        if (this.archiveLocation == null ? other.archiveLocation != null : !this.archiveLocation.equals(other.archiveLocation)) {
            return false;
        }
        if (this.author == null ? other.author != null : !this.author.equals(other.author)) {
            return false;
        }
        if (this.currentphasepercent == null ? other.currentphasepercent != null : !this.currentphasepercent.equals(other.currentphasepercent)) {
            return false;
        }
        if (this.description == null ? other.description != null : !this.description.equals(other.description)) {
            return false;
        }
        if (this.endtime == null ? other.endtime != null : !this.endtime.equals(other.endtime)) {
            return false;
        }
        if (this.id == null ? other.id != null : !this.id.equals(other.id)) {
            return false;
        }
        if (this.reportID == null ? other.reportID != null : !this.reportID.equals(other.reportID)) {
            return false;
        }
        if (this.sources == null ? other.sources != null : !this.sources.equals(other.sources)) {
            return false;
        }
        if (this.starttime == null ? other.starttime != null : !this.starttime.equals(other.starttime)) {
            return false;
        }
        if (this.status != other.status) {
            return false;
        }
        if (this.submissiontime == null ? other.submissiontime != null : !this.submissiontime.equals(other.submissiontime)) {
            return false;
        }
        if (this.title == null ? other.title != null : !this.title.equals(other.title)) {
            return false;
        }
        return !(this.type == null ? other.type != null : !this.type.equals(other.type));
    }
}

