/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.application.aquamaps.aquamapsservice.stubs.wrapper;

import java.rmi.Remote;
import java.util.List;
import org.gcube.application.aquamaps.aquamapsservice.stubs.GetJSONSubmittedByFiltersRequestType;
import org.gcube.application.aquamaps.aquamapsservice.stubs.PublisherServicePortType;
import org.gcube.application.aquamaps.aquamapsservice.stubs.RetrieveMapsByCoverageRequestType;
import org.gcube.application.aquamaps.aquamapsservice.stubs.datamodel.enhanced.AquaMap;
import org.gcube.application.aquamaps.aquamapsservice.stubs.datamodel.enhanced.Field;
import org.gcube.application.aquamaps.aquamapsservice.stubs.datamodel.enhanced.File;
import org.gcube.application.aquamaps.aquamapsservice.stubs.datamodel.enhanced.Resource;
import org.gcube.application.aquamaps.aquamapsservice.stubs.service.PublisherServiceAddressingLocator;
import org.gcube.application.aquamaps.aquamapsservice.stubs.wrapper.AquaMapsCall;
import org.gcube.application.aquamaps.aquamapsservice.stubs.wrapper.PublisherInterface;
import org.gcube.application.aquamaps.aquamapsservice.stubs.wrapper.ServiceException;
import org.gcube.application.aquamaps.datamodel.PagedRequestSettings;
import org.gcube.common.core.contexts.GCUBERemotePortTypeContext;
import org.gcube.common.core.faults.GCUBEFault;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.common.core.security.GCUBESecurityManager;
import org.gcube.common.core.security.GCUBESecurityManagerImpl;
import org.gcube.common.core.types.StringArray;
import org.gcube.common.gis.datamodel.enhanced.LayerInfo;

public class PublisherServiceCall
extends AquaMapsCall
implements PublisherInterface {
    private PublisherServicePortType pt;

    public static PublisherInterface getWrapper(GCUBEScope scope, GCUBESecurityManager[] securityManager, String defaultURI, boolean queryIS) throws Exception {
        return new PublisherServiceCall(scope, securityManager, defaultURI, queryIS);
    }

    public static PublisherInterface getCall(GCUBEScope scope, String defaultURI, boolean queryIS) throws Exception {
        GCUBESecurityManagerImpl secMan = new GCUBESecurityManagerImpl(){

            public boolean isSecurityEnabled() {
                return false;
            }
        };
        return new PublisherServiceCall(scope, new GCUBESecurityManager[]{secMan}, defaultURI, queryIS);
    }

    private PublisherServiceCall(GCUBEScope scope, GCUBESecurityManager[] securityManager, String defaultURI, boolean queryIS) throws Exception {
        super(scope, securityManager, defaultURI, queryIS);
        this.pt = (PublisherServicePortType)GCUBERemotePortTypeContext.getProxy((Remote)new PublisherServiceAddressingLocator().getPublisherServicePortTypePort(this.epr), (GCUBEScope)scope, (int)120000, (GCUBESecurityManager[])securityManager);
    }

    protected String getPortTypeName() {
        return "gcube/application/aquamaps/aquamapsservice/PublisherService";
    }

    @Override
    public List<AquaMap> getMapsBySpecies(String[] speciesIds, boolean includeGis, boolean includeCustom, List<Resource> resources) throws Exception {
        try {
            RetrieveMapsByCoverageRequestType request = new RetrieveMapsByCoverageRequestType();
            request.setIncludeCustomMaps(includeCustom);
            request.setIncludeGisLayers(includeGis);
            request.setResourceList(Resource.toStubsVersion(resources));
            request.setSpeciesList(new StringArray(speciesIds));
            return AquaMap.load(this.pt.retrieveMapsByCoverage(request));
        }
        catch (GCUBEFault f) {
            logger.error((Object)"Service thrown Fault ", (Throwable)f);
            throw new ServiceException(f.getFaultMessage());
        }
    }

    @Override
    public String getJsonSubmittedByFilters(List<Field> filters, PagedRequestSettings settings) throws Exception {
        try {
            GetJSONSubmittedByFiltersRequestType request = new GetJSONSubmittedByFiltersRequestType();
            request.setFilters(Field.toStubsVersion(filters));
            request.setSettings(settings);
            return this.pt.getJSONSubmittedByFilters(request);
        }
        catch (GCUBEFault f) {
            logger.error((Object)"Service thrown Fault ", (Throwable)f);
            throw new ServiceException(f.getFaultMessage());
        }
    }

    @Override
    public List<File> getFileSetById(String fileSetId) throws Exception {
        try {
            return File.load(this.pt.getFileSetById(fileSetId));
        }
        catch (GCUBEFault f) {
            logger.error((Object)"Service thrown Fault ", (Throwable)f);
            throw new ServiceException(f.getFaultMessage());
        }
    }

    @Override
    public LayerInfo getLayerById(String layerId) throws Exception {
        try {
            return new LayerInfo(this.pt.getLayerById(layerId));
        }
        catch (GCUBEFault f) {
            logger.error((Object)"Service thrown Fault ", (Throwable)f);
            throw new ServiceException(f.getFaultMessage());
        }
    }

    @Override
    public List<LayerInfo> getLayersByCoverage(Resource source, String parameters) throws Exception {
        return null;
    }

    @Override
    public List<File> getFileSetsByCoverage(Resource source, String parameters) throws Exception {
        return null;
    }
}

