/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.application.aquamaps.aquamapsservice.impl.db.managers;

import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.gcube.application.aquamaps.aquamapsservice.impl.db.DBSession;
import org.gcube.application.aquamaps.aquamapsservice.impl.db.DBUtils;
import org.gcube.application.aquamaps.aquamapsservice.impl.db.managers.threads.SourceImporter;
import org.gcube.application.aquamaps.aquamapsservice.impl.util.ServiceUtils;
import org.gcube.application.aquamaps.aquamapsservice.impl.util.isconfig.ConfigurationManager;
import org.gcube.application.aquamaps.aquamapsservice.impl.util.isconfig.DBDescriptor;
import org.gcube.application.aquamaps.aquamapsservice.stubs.ExportCSVSettings;
import org.gcube.application.aquamaps.aquamapsservice.stubs.ImportResourceRequestType;
import org.gcube.application.aquamaps.aquamapsservice.stubs.datamodel.enhanced.Resource;
import org.gcube.application.aquamaps.aquamapsservice.stubs.fw.fields.MetaSourceFields;
import org.gcube.application.aquamaps.aquamapsservice.stubs.fw.model.Field;
import org.gcube.application.aquamaps.aquamapsservice.stubs.fw.types.FieldType;
import org.gcube.application.aquamaps.aquamapsservice.stubs.fw.types.ResourceStatus;
import org.gcube.application.aquamaps.aquamapsservice.stubs.fw.types.ResourceType;
import org.gcube_system.namespaces.application.aquamaps.types.OrderDirection;
import org.gcube_system.namespaces.application.aquamaps.types.PagedRequestSettings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SourceManager {
    static final Logger logger = LoggerFactory.getLogger(SourceManager.class);
    private static final String sourcesTable = "meta_sources";

    public static int getDefaultId(ResourceType type) throws Exception {
        DBSession session = null;
        try {
            session = DBSession.getInternalDBSession();
            ArrayList<Field> filter = new ArrayList<Field>();
            filter.add(new Field(MetaSourceFields.type + "", type + "", FieldType.STRING));
            filter.add(new Field(MetaSourceFields.defaultsource + "", "true", FieldType.BOOLEAN));
            Set<Resource> found = SourceManager.loadRS(session.executeFilteredQuery(filter, sourcesTable, MetaSourceFields.searchid + "", OrderDirection.ASC));
            if (found.isEmpty()) {
                throw new Exception("No Default Found for type " + type);
            }
            int n = found.iterator().next().getSearchId();
            return n;
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            if (session != null && session != null) {
                session.close();
            }
        }
    }

    public static Resource registerSource(Resource toRegister) throws Exception {
        logger.trace("registering source " + toRegister);
        try (DBSession session = null;){
            session = DBSession.getInternalDBSession();
            ArrayList<List<Field>> rows = new ArrayList<List<Field>>();
            ArrayList<Field> row = new ArrayList<Field>();
            for (MetaSourceFields field : MetaSourceFields.values()) {
                if (field.equals((Object)MetaSourceFields.searchid)) continue;
                row.add(toRegister.getField(field));
            }
            rows.add(row);
            List<List<Field>> ids = session.insertOperation(sourcesTable, rows);
            for (Field f : ids.get(0)) {
                if (!f.name().equals(MetaSourceFields.searchid + "")) continue;
                toRegister.setSearchId(f.getValueAsInteger().intValue());
            }
            logger.trace("registered source with id : " + toRegister.getSearchId());
            Resource resource = toRegister;
            return resource;
        }
    }

    public static void deleteSource(int id, boolean deleteTable) throws Exception {
        try (DBSession session = null;){
            session = DBSession.getInternalDBSession();
            Resource toDelete = SourceManager.getById(id);
            ArrayList<Field> filter = new ArrayList<Field>();
            filter.add(new Field(MetaSourceFields.searchid + "", id + "", FieldType.INTEGER));
            session.deleteOperation(sourcesTable, filter);
            if (deleteTable) {
                session.dropTable(toDelete.getTableName());
            }
        }
    }

    public static String getSourceName(int id) throws Exception {
        return (String)SourceManager.getField(id, MetaSourceFields.tablename);
    }

    public static String getSourceTitle(int id) throws Exception {
        return (String)SourceManager.getField(id, MetaSourceFields.title);
    }

    private static Object getField(int id, MetaSourceFields field) throws Exception {
        try (DBSession session = null;){
            session = DBSession.getInternalDBSession();
            ArrayList<Field> filter = new ArrayList<Field>();
            filter.add(new Field(MetaSourceFields.searchid + "", id + "", FieldType.INTEGER));
            ResultSet rs = session.executeFilteredQuery(filter, sourcesTable, MetaSourceFields.searchid + "", OrderDirection.ASC);
            if (rs.next()) {
                Object object = rs.getObject(field + "");
                return object;
            }
            Object var5_7 = null;
            return var5_7;
        }
    }

    private static int updateField(int id, MetaSourceFields field, FieldType objectType, Object value) throws Exception {
        try (DBSession session = null;){
            session = DBSession.getInternalDBSession();
            ArrayList<List<Field>> keys = new ArrayList<List<Field>>();
            ArrayList<Field> filter = new ArrayList<Field>();
            filter.add(new Field(MetaSourceFields.searchid + "", id + "", FieldType.INTEGER));
            keys.add(filter);
            ArrayList<List<Field>> values = new ArrayList<List<Field>>();
            ArrayList<Field> valueList = new ArrayList<Field>();
            valueList.add(new Field(field + "", value + "", objectType));
            values.add(valueList);
            int n = session.updateOperation(sourcesTable, keys, values);
            return n;
        }
    }

    public static void setTableTitle(int id, String tableTitle) throws Exception {
        SourceManager.updateField(id, MetaSourceFields.title, FieldType.STRING, tableTitle);
    }

    public static void setCountRow(int id, Long count) throws Exception {
        SourceManager.updateField(id, MetaSourceFields.rowcount, FieldType.INTEGER, count);
    }

    public static Set<Resource> getList(List<Field> filter) throws Exception {
        try (DBSession session = null;){
            session = DBSession.getInternalDBSession();
            Set<Resource> set = SourceManager.loadRS(session.executeFilteredQuery(filter, sourcesTable, MetaSourceFields.searchid + "", OrderDirection.ASC));
            return set;
        }
    }

    public static String getJsonList(List<Field> filter, PagedRequestSettings settings) throws Exception {
        try (DBSession session = null;){
            session = DBSession.getInternalDBSession();
            String string = DBUtils.toJSon(session.executeFilteredQuery(filter, sourcesTable, settings.getOrderField(), settings.getOrderDirection()), settings.getOffset(), settings.getLimit() + settings.getOffset());
            return string;
        }
    }

    private static Set<Resource> loadRS(ResultSet rs) throws Exception {
        HashSet<Resource> toReturn = new HashSet<Resource>();
        while (rs.next()) {
            toReturn.add(new Resource(rs));
        }
        return toReturn;
    }

    public static Resource getById(int id) throws Exception {
        if (id == 0) {
            return null;
        }
        try (DBSession session = null;){
            session = DBSession.getInternalDBSession();
            ArrayList<Field> filters = new ArrayList<Field>();
            filters.add(new Field(MetaSourceFields.searchid + "", id + "", FieldType.INTEGER));
            Resource resource = SourceManager.loadRS(session.executeFilteredQuery(filters, sourcesTable, MetaSourceFields.searchid + "", OrderDirection.ASC)).iterator().next();
            return resource;
        }
    }

    public static int update(Resource toUpdate) throws Exception {
        try (DBSession session = null;){
            ArrayList<List<Field>> keys;
            ArrayList<List<Field>> values;
            session = DBSession.getInternalDBSession();
            session.disableAutoCommit();
            if (toUpdate.getDefaultSource().booleanValue()) {
                values = new ArrayList<List<Field>>();
                ArrayList<Field> toSet = new ArrayList<Field>();
                toSet.add(new Field(MetaSourceFields.defaultsource + "", "false", FieldType.BOOLEAN));
                values.add(toSet);
                keys = new ArrayList();
                ArrayList<Field> key = new ArrayList<Field>();
                key.add(toUpdate.getField(MetaSourceFields.type));
                keys.add(key);
                session.updateOperation(sourcesTable, keys, values);
            }
            values = new ArrayList();
            ArrayList<Field> value = new ArrayList<Field>();
            for (MetaSourceFields field : MetaSourceFields.values()) {
                if (field.equals((Object)MetaSourceFields.searchid)) continue;
                value.add(toUpdate.getField(field));
            }
            values.add(value);
            keys = new ArrayList<List<Field>>();
            ArrayList<Field> key = new ArrayList<Field>();
            key.add(toUpdate.getField(MetaSourceFields.searchid));
            keys.add(key);
            int rows = session.updateOperation(sourcesTable, keys, values);
            session.commit();
            int n = rows;
            return n;
        }
    }

    public static Integer importFromCSVFile(ImportResourceRequestType request) throws Exception {
        try (DBSession session = null;){
            ResourceType type = ResourceType.valueOf((String)request.getResourceType());
            session = DBSession.getInternalDBSession();
            String tableName = ServiceUtils.generateId(type + "", "").toLowerCase();
            session.createLikeTable(tableName, SourceManager.getById(SourceManager.getDefaultId(type)).getTableName());
            Resource toRegister = new Resource(type, 0);
            toRegister.setAuthor(request.getUser());
            toRegister.setDefaultSource(Boolean.valueOf(false));
            toRegister.setGenerationTime(Long.valueOf(System.currentTimeMillis()));
            toRegister.setDescription("Imported csv file ");
            toRegister.setTableName(tableName);
            toRegister.setTitle("Import_" + request.getUser());
            toRegister.setStatus(ResourceStatus.Importing);
            toRegister.setRowCount(Long.valueOf(0L));
            toRegister = SourceManager.registerSource(toRegister);
            ExportCSVSettings settings = request.getCsvSettings();
            SourceImporter t = new SourceImporter(request.getRsLocator(), toRegister, SourceManager.getDefaultId(type), settings.getDelimiter().charAt(0), settings.getFieldsMask(), settings.isHasHeader(), settings.getEncoding());
            t.start();
            Integer n = toRegister.getSearchId();
            return n;
        }
    }

    public static void checkTables() throws Exception {
        Set<Resource> list = SourceManager.getList(new ArrayList<Field>());
        try (DBSession session = null;){
            session = DBSession.getInternalDBSession();
            for (Resource r : list) {
                try {
                    logger.trace("Checking " + r);
                    boolean existing = true;
                    try {
                        session.executeQuery("SELECT * FROM " + r.getTableName() + " LIMIT 1 OFFSET 0");
                    }
                    catch (Exception e) {
                        logger.trace("Unable to detect table " + r.getTableName() + ", going to delete resource");
                        SourceManager.deleteSource(r.getSearchId(), false);
                        existing = false;
                    }
                    if (!existing) continue;
                    if (r.getRowCount() == 0L) {
                        logger.trace("Updateing row count");
                        r.setRowCount(session.getCount(r.getTableName(), new ArrayList<Field>()));
                    }
                    HashMap sourcesLists = new HashMap();
                    sourcesLists.put(ResourceType.HCAF, new ArrayList(r.getSourceHCAFIds()));
                    sourcesLists.put(ResourceType.HSPEN, new ArrayList(r.getSourceHSPENIds()));
                    sourcesLists.put(ResourceType.HSPEC, new ArrayList(r.getSourceHSPECIds()));
                    sourcesLists.put(ResourceType.OCCURRENCECELLS, new ArrayList(r.getSourceOccurrenceCellsIds()));
                    boolean checkTableNames = false;
                    for (ResourceType type : ResourceType.values()) {
                        for (Integer id : (ArrayList)sourcesLists.get(type)) {
                            Resource toCheck = SourceManager.getById(id);
                            if (toCheck == null) {
                                logger.trace("Unable to find source , id was " + id);
                                r.removeSourceId(id);
                                checkTableNames = true;
                                continue;
                            }
                            r.removeSource(toCheck);
                            r.addSource(toCheck);
                        }
                    }
                    if (checkTableNames) {
                        HashMap tableLists = new HashMap();
                        tableLists.put(ResourceType.HCAF, new ArrayList(r.getSourceHCAFTables()));
                        tableLists.put(ResourceType.HSPEN, new ArrayList(r.getSourceHSPENTables()));
                        tableLists.put(ResourceType.HSPEC, new ArrayList(r.getSourceHSPECTables()));
                        tableLists.put(ResourceType.OCCURRENCECELLS, new ArrayList(r.getSourceOccurrenceCellsTables()));
                        for (ResourceType type : ResourceType.values()) {
                            for (String table : (ArrayList)tableLists.get(type)) {
                                if (session.checkTableExist(table)) continue;
                                logger.trace("Found non existing table reference : " + table);
                                r.removeSourceTableName(table);
                            }
                        }
                    }
                    SourceManager.update(r);
                }
                catch (Exception e) {
                    logger.warn("Unable to check resource " + r.getSearchId(), (Throwable)e);
                }
            }
        }
    }

    public static final String getToUseTableStore() throws Exception {
        try (DBSession session = null;){
            session = DBSession.getInternalDBSession();
            ResultSet rs = session.executeFilteredQuery(new ArrayList<Field>(), sourcesTable, MetaSourceFields.searchid + "", OrderDirection.DESC);
            int lastId = 0;
            if (rs.next()) {
                lastId = rs.getInt(MetaSourceFields.searchid + "");
                rs.close();
            }
            DBDescriptor dbDescr = ConfigurationManager.getVODescriptor().getInternalDB();
            int numTableSpaces = Integer.parseInt(dbDescr.getProperty(DBDescriptor.TABLESPACE_COUNT));
            int toUseTableSpace = (lastId + 1) % numTableSpaces + 1;
            String toReturn = dbDescr.getProperty(DBDescriptor.TABLESPACE_PREFIX) + toUseTableSpace;
            logger.debug("TableSpace to use : " + toReturn);
            String string = toReturn;
            return string;
        }
    }

    public static final String getMaxMinTable(Resource Hspen2) throws Exception {
        if (!Hspen2.getType().equals((Object)ResourceType.HSPEN)) {
            throw new Exception("Passed Resource is not HSPEN, resource was " + Hspen2);
        }
        try (DBSession session = null;){
            session = DBSession.getInternalDBSession();
            String candidateMaxMin = "maxminlat_" + Hspen2.getTableName();
            if (session.checkTableExist(candidateMaxMin)) {
                logger.debug("Found " + candidateMaxMin + " for HSPEN table " + Hspen2.getTableName());
                String string = candidateMaxMin;
                return string;
            }
            Resource defaultHSPEN = SourceManager.getById(SourceManager.getDefaultId(ResourceType.HSPEN));
            if (defaultHSPEN == null) {
                throw new Exception("Unable to evaluate default HSPEN Table");
            }
            candidateMaxMin = "maxminlat_" + defaultHSPEN.getTableName();
            if (session.checkTableExist(candidateMaxMin)) {
                logger.debug("Found " + candidateMaxMin + " (From Default HSPEN Table ID : " + defaultHSPEN.getSearchId() + ")for HSPEN table " + Hspen2.getTableName());
                String string = candidateMaxMin;
                return string;
            }
            throw new Exception("Unable to find default Max Min Hspen Table ");
        }
    }
}

