/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.application.aquamaps.aquamapsservice.impl.util;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathFactory;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class ParserXPath {
    protected static GCUBELog logger = new GCUBELog(ParserXPath.class);

    public static ArrayList<String> getTextFromXPathExpression(String xml, String xpathExpression) throws Exception {
        try {
            ArrayList<String> list = new ArrayList<String>();
            XPath xpath = XPathFactory.newInstance().newXPath();
            XPathExpression xPathExpression = xpath.compile(xpathExpression);
            InputSource inputSource = new InputSource(ParserXPath.stringToInputStream(xml));
            NodeList nodes = (NodeList)xPathExpression.evaluate(inputSource, XPathConstants.NODESET);
            int i = 0;
            while (i < nodes.getLength()) {
                Node node = nodes.item(i);
                list.add(node.getTextContent());
                ++i;
            }
            return list;
        }
        catch (Exception e) {
            logger.warn((Object)("Unexpected exception while getting " + xpathExpression), (Throwable)e);
            throw e;
        }
    }

    public static InputStream stringToInputStream(String text) throws UnsupportedEncodingException {
        try {
            return new ByteArrayInputStream(text.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            logger.warn((Object)"", (Throwable)e);
            throw e;
        }
    }
}

