/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.application.aquamaps.aquamapsservice.impl.engine.tables;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Semaphore;
import org.gcube.application.aquamaps.aquamapsservice.impl.CommonServiceLogic;
import org.gcube.application.aquamaps.aquamapsservice.impl.ServiceContext;
import org.gcube.application.aquamaps.aquamapsservice.impl.db.DBSession;
import org.gcube.application.aquamaps.aquamapsservice.impl.db.managers.SourceGenerationRequestsManager;
import org.gcube.application.aquamaps.aquamapsservice.impl.db.managers.SourceManager;
import org.gcube.application.aquamaps.aquamapsservice.impl.engine.predictions.BatchGeneratorI;
import org.gcube.application.aquamaps.aquamapsservice.impl.engine.predictions.EnvironmentalLogicManager;
import org.gcube.application.aquamaps.aquamapsservice.impl.engine.predictions.TableGenerationConfiguration;
import org.gcube.application.aquamaps.aquamapsservice.impl.engine.tables.Execution;
import org.gcube.application.aquamaps.aquamapsservice.impl.engine.tables.TableGenerationExecutionManager;
import org.gcube.application.aquamaps.aquamapsservice.impl.util.isconfig.ConfigurationManager;
import org.gcube.application.aquamaps.aquamapsservice.stubs.datamodel.enhanced.Field;
import org.gcube.application.aquamaps.aquamapsservice.stubs.datamodel.enhanced.Resource;
import org.gcube.application.aquamaps.aquamapsservice.stubs.datamodel.environments.SourceGenerationRequest;
import org.gcube.application.aquamaps.aquamapsservice.stubs.datamodel.fields.MetaSourceFields;
import org.gcube.application.aquamaps.aquamapsservice.stubs.datamodel.fields.SourceGenerationRequestFields;
import org.gcube.application.aquamaps.aquamapsservice.stubs.datamodel.types.AlgorithmType;
import org.gcube.application.aquamaps.aquamapsservice.stubs.datamodel.types.LogicType;
import org.gcube.application.aquamaps.aquamapsservice.stubs.datamodel.types.ResourceStatus;
import org.gcube.application.aquamaps.aquamapsservice.stubs.datamodel.types.ResourceType;
import org.gcube.application.aquamaps.aquamapsservice.stubs.datamodel.types.SourceGenerationPhase;
import org.gcube.common.core.utils.logging.GCUBELog;

public class HSPECGroupWorker
extends Thread {
    private SourceGenerationRequest request;
    private static final GCUBELog logger = new GCUBELog(HSPECGroupWorker.class);
    final Semaphore blocking = new Semaphore(0);
    final List<String> exceptions = new ArrayList<String>();

    public HSPECGroupWorker(SourceGenerationRequest request) {
        this.request = request;
    }

    /*
     * Could not resolve type clashes
     * Unable to fully structure code
     */
    @Override
    public void run() {
        block24: {
            try {
                HSPECGroupWorker.logger.trace((Object)("Starting execution for request ID " + this.request.getId()));
                HSPECGroupWorker.logger.debug((Object)("Request is " + this.request.toXML()));
                SourceGenerationRequestsManager.setStartTime(this.request.getId());
                SourceGenerationRequestsManager.setPhasePercent(0.0, this.request.getId());
                sourcesSubsets = HSPECGroupWorker.getComplexGenerationSubSets(this.request);
                if (sourcesSubsets.size() == 0) {
                    throw new Exception("No valid sources subset for generation request " + this.request.getId());
                }
                Ntabs_per_step = 1;
                if (this.request.getLogic().equals((Object)LogicType.HCAF)) {
                    for (Field f : this.request.getGenerationParameters()) {
                        if (!f.getName().equals("NUM_INTERPOLATIONS")) continue;
                        Ntabs_per_step = f.getValueAsInteger() - 2;
                    }
                }
                SourceGenerationRequestsManager.setEvaluatedComputationCount(sourcesSubsets.size() * this.request.getAlgorithms().size(), this.request.getId());
                SourceGenerationRequestsManager.setToGenerateTableCount(sourcesSubsets.size() * Ntabs_per_step * this.request.getAlgorithms().size(), this.request.getId());
                for (List sourcesSubset : sourcesSubsets) {
                    for (AlgorithmType algorithm : this.request.getAlgorithms()) {
                        batch = null;
                        try {
                            batch = EnvironmentalLogicManager.getBatch(this.request.getSubmissionBackend());
                            HSPECGroupWorker.logger.debug((Object)("Got batch Id " + batch.getReportId()));
                            SourceGenerationRequestsManager.addReportId(batch.getReportId(), this.request.getId());
                            try {
                                HSPECGroupWorker.simpleExecution(algorithm, this.request, sourcesSubset, batch, this);
                            }
                            catch (Exception e) {
                                HSPECGroupWorker.logger.error((Object)("Failed single execution step for " + this.request.getId() + ", sources subset was " + Arrays.toString(sourcesSubset.toArray())));
                            }
                        }
                        catch (Exception e) {
                            HSPECGroupWorker.logger.error((Object)"Unexpected Exception ", (Throwable)e);
                            if (batch == null) continue;
                            this.release(batch);
                        }
                    }
                }
                HSPECGroupWorker.logger.debug((Object)("Going to wait for generations, acquiring " + sourcesSubsets.size() * this.request.getAlgorithms().size() + " permits, currently available : " + this.blocking.availablePermits()));
                this.blocking.acquire(sourcesSubsets.size() * this.request.getAlgorithms().size());
                generatedSources = SourceGenerationRequestsManager.getById(this.request.getId()).getGeneratedSources();
                HSPECGroupWorker.logger.debug((Object)("Awaken process, generated " + generatedSources.size()));
                if (generatedSources.size() == 0) {
                    throw new Exception("No sources were generated/ registered. Check previous log.");
                }
                if (this.request.getLogic().equals((Object)LogicType.HSPEC)) {
                    forceRegeneration = false;
                    generateMaps = false;
                    generateGis = false;
                    for (Field f : this.request.getExecutionParameters()) {
                        if (f.getName().equals("FORCE_MAPS_REGENERATION")) {
                            forceRegeneration = f.getValueAsBoolean();
                            continue;
                        }
                        if (f.getName().equals("GENERATE_MAPS")) {
                            generateMaps = f.getValueAsBoolean();
                            continue;
                        }
                        if (!f.getName().equals("GIS_ENABLED")) continue;
                        generateGis = f.getValueAsBoolean();
                    }
                    if (generateMaps) {
                        HSPECGroupWorker.logger.trace((Object)("Generating jobs for request " + this.request.getId()));
                        jobIds = new ArrayList<Integer>();
                        SourceGenerationRequestsManager.setPhase(SourceGenerationPhase.mapgeneration, this.request.getId());
                        for (Integer hspecId : generatedSources) {
                            hspec = SourceManager.getById(hspecId);
                            HSPECGroupWorker.logger.trace((Object)("Requesting job for hspec " + hspec.getTitle() + ", ID :" + hspec.getSearchId()));
                            jobID = CommonServiceLogic.generateMaps_Logic(hspec.getSearchId(), new ArrayList<Field>(), this.request.getAuthor(), generateGis, forceRegeneration);
                            HSPECGroupWorker.logger.trace((Object)("Job is " + jobID));
                            SourceGenerationRequestsManager.addJobIds(jobID, this.request.getId());
                            jobIds.add(jobID);
                        }
                        if (jobIds.size() > 0) {
                            HSPECGroupWorker.logger.trace((Object)("Generation " + this.request.getId() + " : submitted  jobIds : " + jobIds));
                        }
                    } else {
                        SourceGenerationRequestsManager.setPhase(SourceGenerationPhase.completed, this.request.getId());
                    }
                } else {
                    SourceGenerationRequestsManager.setPhase(SourceGenerationPhase.completed, this.request.getId());
                }
                break block24;
            }
            catch (Exception e) {
                HSPECGroupWorker.logger.error((Object)("Unexpected Exception while executing request " + this.request.getId() + ", execution error messages were :"), (Throwable)e);
                ** for (msg : this.exceptions)
            }
lbl-1000:
            // 1 sources

            {
                HSPECGroupWorker.logger.error((Object)msg);
                continue;
            }
lbl81:
            // 1 sources

            try {
                SourceGenerationRequestsManager.setPhase(SourceGenerationPhase.error, this.request.getId());
            }
            catch (Exception e1) {
                HSPECGroupWorker.logger.fatal((Object)("Unable to update phase , request was " + this.request), (Throwable)e);
            }
        }
    }

    private static Set<Resource> getExisting(AlgorithmType algorithm, List<Resource> sources, String currentRequestId, LogicType logic, ArrayList<Field> generationParameters) throws Exception {
        ArrayList<Field> requestFilter = new ArrayList<Field>();
        SourceGenerationRequest requestFilterModel = new SourceGenerationRequest();
        requestFilterModel.setGenerationParameters(generationParameters);
        requestFilterModel.setLogic(logic);
        requestFilter.add(requestFilterModel.getField(SourceGenerationRequestFields.logic));
        requestFilter.add(requestFilterModel.getField(SourceGenerationRequestFields.generationparameters));
        for (SourceGenerationRequest request : SourceGenerationRequestsManager.getList(requestFilter)) {
            if (request.getId().equals(currentRequestId) || !request.getAlgorithms().contains(algorithm) || !request.getPhase().equals((Object)SourceGenerationPhase.pending) && !request.getPhase().equals((Object)SourceGenerationPhase.datageneration)) continue;
            ArrayList<ArrayList<Resource>> subsets = HSPECGroupWorker.getComplexGenerationSubSets(request);
            boolean found = false;
            for (ArrayList<Resource> subset : subsets) {
                if (subset.size() == sources.size()) {
                    int i = 0;
                    while (i < subset.size()) {
                        boolean bl = found = subset.get(i).getSearchId() == sources.get(i).getSearchId();
                        if (!found) break;
                        ++i;
                    }
                }
                if (found) break;
            }
            if (!found) continue;
            logger.trace((Object)("Found existing request [PHASE : " + request.getPhase() + " ; ID : " + request.getId() + "], waiting for generation"));
            int[] sourcesIds = new int[sources.size()];
            int i = 0;
            while (i < sourcesIds.length) {
                sourcesIds[i] = sources.get(i).getSearchId();
                ++i;
            }
            TableGenerationExecutionManager.signForGeneration(new Execution(algorithm, logic, sourcesIds, requestFilterModel.getField(SourceGenerationRequestFields.generationparameters).getValue()));
        }
        Resource filterModel = new Resource(ResourceType.valueOf((String)("" + logic)), 0);
        filterModel.setAlgorithm(algorithm);
        filterModel.setParameters(generationParameters);
        for (Resource r : sources) {
            filterModel.addSource(r);
        }
        ArrayList<Field> resourceFilter = new ArrayList<Field>();
        resourceFilter.add(filterModel.getField(MetaSourceFields.algorithm));
        resourceFilter.add(filterModel.getField(MetaSourceFields.sourcehcafids));
        resourceFilter.add(filterModel.getField(MetaSourceFields.sourcehspecids));
        resourceFilter.add(filterModel.getField(MetaSourceFields.sourcehspenids));
        resourceFilter.add(filterModel.getField(MetaSourceFields.sourceoccurrencecellsids));
        resourceFilter.add(filterModel.getField(MetaSourceFields.parameters));
        return SourceManager.getList(resourceFilter);
    }

    private static void simpleExecution(AlgorithmType algorithmType, final SourceGenerationRequest theRequest, final List<Resource> sourcesSubSet, BatchGeneratorI batch, final HSPECGroupWorker worker) throws Exception {
        batch.setConfiguration(String.valueOf(ServiceContext.getContext().getFile("generator", new boolean[]{false}).getAbsolutePath()) + File.separator, ConfigurationManager.getVODescriptor().getInternalDB());
        try {
            Set<Resource> existing = HSPECGroupWorker.getExisting(algorithmType, sourcesSubSet, theRequest.getId(), theRequest.getLogic(), theRequest.getGenerationParameters());
            if (existing.size() == 0) {
                logger.trace((Object)"No Resources found, submitting generation..");
                batch.generateTable(new TableGenerationConfiguration(theRequest.getLogic(), algorithmType, sourcesSubSet, theRequest.getSubmissionBackend(), theRequest.getExecutionEnvironment(), theRequest.getBackendURL(), theRequest.getEnvironmentConfiguration(), theRequest.getNumPartitions(), theRequest.getAuthor(), theRequest.getGenerationParameters(), worker){

                    @Override
                    public void registerGeneratedSourcesCallback(List<String> toRegisterTables) throws Exception {
                        List<Resource> toReturn = HSPECGroupWorker.registerSources(toRegisterTables, ResourceType.valueOf((String)("" + this.getLogic())), this.getAlgorithm(), this.getAuthor(), theRequest.getDescription(), this.getExecutionEnvironment(), sourcesSubSet, String.valueOf(theRequest.getGenerationname()) + "_" + this.getAlgorithm(), this.getAdditionalParameters());
                        if (toReturn.size() == 0) {
                            throw new Exception("No tables were generated");
                        }
                        int[] sourcesIds = new int[sourcesSubSet.size()];
                        int i = 0;
                        while (i < sourcesIds.length) {
                            sourcesIds[i] = ((Resource)sourcesSubSet.get(i)).getSearchId();
                            ++i;
                        }
                        TableGenerationExecutionManager.notifyGeneration(new Execution(this.getAlgorithm(), theRequest.getLogic(), sourcesIds, theRequest.getField(SourceGenerationRequestFields.generationparameters).getValue()));
                        worker.notifyGenerated(toReturn);
                    }

                    @Override
                    public void notifyError(Exception e) {
                        logger.warn((Object)"Unexpected Exception", (Throwable)e);
                        int[] sourcesIds = new int[sourcesSubSet.size()];
                        int i = 0;
                        while (i < sourcesIds.length) {
                            sourcesIds[i] = ((Resource)sourcesSubSet.get(i)).getSearchId();
                            ++i;
                        }
                        try {
                            TableGenerationExecutionManager.notifyGeneration(new Execution(this.getAlgorithm(), theRequest.getLogic(), sourcesIds, theRequest.getField(SourceGenerationRequestFields.generationparameters).getValue()));
                        }
                        catch (Exception e2) {
                            logger.warn((Object)"Unable to notify pending generations... ", (Throwable)e2);
                        }
                        try {
                            worker.notifyException(e, new Execution(this.getAlgorithm(), theRequest.getLogic(), sourcesIds, theRequest.getField(SourceGenerationRequestFields.generationparameters).getValue()));
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }

                    @Override
                    public void release(BatchGeneratorI batch) {
                        worker.release(batch);
                    }
                });
            } else {
                logger.trace((Object)("Found " + existing.size() + " existing sources "));
                ArrayList<Resource> generated = new ArrayList<Resource>();
                for (Resource r : existing) {
                    generated.add(r);
                }
                worker.notifyGenerated(generated);
                worker.release(batch);
            }
        }
        catch (Exception e) {
            logger.error((Object)("Unable to generate data for  algorithm " + algorithmType + " subset was : " + Arrays.toString(sourcesSubSet.toArray())), (Throwable)e);
            worker.release(batch);
        }
    }

    private static ArrayList<ArrayList<Resource>> getComplexGenerationSubSets(SourceGenerationRequest request) throws Exception {
        ArrayList<ArrayList<Resource>> toReturn = new ArrayList<ArrayList<Resource>>();
        switch (request.getLogic()) {
            case HSPEC: {
                boolean combineMatching = true;
                for (Field f : request.getExecutionParameters()) {
                    if (!f.getName().equals("COMBINE_MATCHING")) continue;
                    combineMatching = f.getValueAsBoolean();
                }
                if (request.getHcafIds().size() == 0) {
                    throw new Exception("No HCAF resources found for request " + request.getId() + ", Logic was " + request.getLogic());
                }
                if (request.getHspenIds().size() == 0) {
                    throw new Exception("No HSPEN resources found for request " + request.getId() + ", Logic was " + request.getLogic());
                }
                for (Integer hcafId : request.getHcafIds()) {
                    Resource hcaf = SourceManager.getById(hcafId);
                    if (hcaf == null) {
                        logger.warn((Object)("Selected HCAF Resource [ID = " + hcafId + " ] was null , skipping.."));
                        continue;
                    }
                    for (Integer hspenId : request.getHspenIds()) {
                        Resource hspen = SourceManager.getById(hspenId);
                        if (combineMatching && !hspen.getSourceHCAFIds().contains(hcafId)) {
                            logger.debug((Object)("HSPEN (" + hspenId + ")doesn't match current hcaf (" + hcafId + "), hspen sources where " + hspen.getSourceHCAFIds()));
                            continue;
                        }
                        if (hcaf == null) {
                            logger.warn((Object)("Selected HSPEN Resource [ID = " + hspenId + " ] was null , skipping.."));
                            continue;
                        }
                        toReturn.add(new ArrayList<Resource>(Arrays.asList(hcaf, hspen)));
                    }
                }
                break;
            }
            case HSPEN: {
                if (request.getHcafIds().size() == 0) {
                    throw new Exception("No HCAF resources found for request " + request.getId() + ", Logic was " + request.getLogic());
                }
                if (request.getHspenIds().size() == 0) {
                    throw new Exception("No HSPEN resources found for request " + request.getId() + ", Logic was " + request.getLogic());
                }
                if (request.getOccurrenceCellIds().size() == 0) {
                    throw new Exception("No Occurrence Cells resources found for request " + request.getId() + ", Logic was " + request.getLogic());
                }
                for (Integer hcafId : request.getHcafIds()) {
                    Resource hcaf = SourceManager.getById(hcafId);
                    if (hcaf == null) {
                        logger.warn((Object)("Selected HCAF Resource [ID = " + hcafId + " ] was null , skipping.."));
                        continue;
                    }
                    for (Integer hspenId : request.getHspenIds()) {
                        Resource hspen = SourceManager.getById(hspenId);
                        if (hspen == null) {
                            logger.warn((Object)("Selected HSPEN Resource [ID = " + hspenId + " ] was null , skipping.."));
                            continue;
                        }
                        for (Integer occurId : request.getOccurrenceCellIds()) {
                            Resource occurrence = SourceManager.getById(occurId);
                            if (occurrence == null) {
                                logger.warn((Object)("Selected Occurrence Cells Resource [ID = " + occurId + " ] was null , skipping.."));
                                continue;
                            }
                            toReturn.add(new ArrayList<Resource>(Arrays.asList(hcaf, hspen, occurrence)));
                        }
                    }
                }
                break;
            }
            case HCAF: {
                if (request.getHcafIds().size() == 0) {
                    throw new Exception("No HCAF resources found for request " + request.getId() + ", Logic was " + request.getLogic());
                }
                ArrayList<Resource> sources = new ArrayList<Resource>();
                for (Integer hcafId : request.getHcafIds()) {
                    Resource hcaf = SourceManager.getById(hcafId);
                    if (hcaf == null) {
                        throw new Exception("Selected HCAF Resource [ID = " + hcafId + " ] was null , skipping..");
                    }
                    sources.add(hcaf);
                }
                toReturn.add(sources);
            }
        }
        return toReturn;
    }

    public static List<Resource> registerSources(List<String> toRegister, ResourceType type, AlgorithmType alg, String author, String description, String environment, List<Resource> sources, String titlePattern, ArrayList<Field> additionalParameters) throws Exception {
        ArrayList<String> unregisteredTables = new ArrayList<String>();
        ArrayList<Resource> toReturn = new ArrayList<Resource>();
        int i = 0;
        while (i < toRegister.size()) {
            block20: {
                String generatedTable = toRegister.get(i);
                try {
                    Long count;
                    Resource toRegisterSource;
                    block18: {
                        toRegisterSource = new Resource(type, 0);
                        toRegisterSource.setAlgorithm(alg);
                        toRegisterSource.setAuthor(author);
                        toRegisterSource.setGenerationTime(Long.valueOf(System.currentTimeMillis()));
                        toRegisterSource.setDescription(description);
                        toRegisterSource.setProvenance("Generated on AquaMaps VRE, submitted on " + environment);
                        for (Resource r : sources) {
                            toRegisterSource.addSource(r);
                        }
                        toRegisterSource.setStatus(ResourceStatus.Completed);
                        toRegisterSource.setTableName(generatedTable);
                        toRegisterSource.setParameters(additionalParameters);
                        String title = toRegister.size() > 1 ? String.valueOf(titlePattern) + "_step" + i : titlePattern;
                        toRegisterSource.setTitle(title);
                        count = 0L;
                        DBSession session = null;
                        try {
                            session = DBSession.getInternalDBSession();
                            if (session.checkTableExist(generatedTable)) {
                                count = session.getTableCount(generatedTable);
                                break block18;
                            }
                            throw new Exception("TABLE " + generatedTable + " NOT FOUND!!");
                        }
                        finally {
                            if (session != null) {
                                session.close();
                            }
                        }
                    }
                    toRegisterSource.setRowCount(count);
                    toRegisterSource = SourceManager.registerSource(toRegisterSource);
                    logger.trace((Object)("Registered Resource with id " + toRegisterSource.getSearchId()));
                    toReturn.add(toRegisterSource);
                }
                catch (Exception e) {
                    unregisteredTables.add(generatedTable);
                    logger.error((Object)("Unable to register source table " + generatedTable), (Throwable)e);
                    DBSession session = null;
                    try {
                        try {
                            session = DBSession.getInternalDBSession();
                            if (session.checkTableExist(generatedTable)) {
                                session.dropTable(generatedTable);
                            }
                        }
                        catch (Exception e1) {
                            logger.warn((Object)("Unable to delete table " + generatedTable), (Throwable)e);
                            if (session != null) {
                                session.close();
                            }
                            break block20;
                        }
                    }
                    catch (Throwable throwable) {
                        if (session != null) {
                            session.close();
                        }
                        throw throwable;
                    }
                    if (session == null) break block20;
                    session.close();
                }
            }
            ++i;
        }
        return toReturn;
    }

    public void notifyGenerated(List<Resource> generated) throws Exception {
        for (Resource r : generated) {
            SourceGenerationRequestsManager.addGeneratedResource(r.getSearchId(), this.request.getId());
        }
        this.blocking.release();
    }

    public void notifyException(Exception e, Execution exec) {
        this.exceptions.add("Execution " + exec + " threw exception : " + e.getMessage());
        this.blocking.release();
    }

    public void release(BatchGeneratorI batch) {
        logger.debug((Object)("leaving batch ID " + batch.getReportId()));
        try {
            if (batch != null) {
                EnvironmentalLogicManager.leaveBatch(batch);
                SourceGenerationRequestsManager.removeReportId(batch.getReportId(), this.request.getId());
            }
        }
        catch (Exception e) {
            logger.fatal((Object)"Unable to leave generator", (Throwable)e);
        }
    }
}

