/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.application.aquamaps.aquamapsservice.impl.engine.maps;

import java.util.Iterator;
import java.util.List;
import org.gcube.application.aquamaps.aquamapsservice.impl.db.managers.SubmittedManager;
import org.gcube.application.aquamaps.aquamapsservice.impl.engine.maps.JobExecutionManager;
import org.gcube.application.aquamaps.aquamapsservice.stubs.datamodel.enhanced.Submitted;
import org.gcube.application.aquamaps.aquamapsservice.stubs.datamodel.types.SubmittedStatus;
import org.gcube.common.core.utils.logging.GCUBELog;

public class RequestsMonitor
extends Thread {
    private static final GCUBELog logger = new GCUBELog(RequestsMonitor.class);
    private boolean object;
    private static RequestsMonitor jobInstance = null;
    private static RequestsMonitor objInstance = null;

    public static RequestsMonitor get(boolean object) {
        if (object) {
            if (objInstance == null) {
                objInstance = new RequestsMonitor(object);
            }
            return objInstance;
        }
        if (jobInstance == null) {
            jobInstance = new RequestsMonitor(object);
        }
        return jobInstance;
    }

    private RequestsMonitor(boolean object) {
        super(String.valueOf(object ? "OBJ" : "JOB") + "_REQUESTS_MONITOR");
        this.object = object;
    }

    @Override
    public void run() {
        block13: while (true) {
            try {
                try {
                    List<Submitted> foundList = JobExecutionManager.getAvailableRequests(this.object, 1);
                    if (foundList.size() > 0) {
                        logger.debug((Object)("FOUND " + foundList.size() + " PENDING " + (this.object ? "OBJ" : "JOB") + " REQUESTS "));
                    }
                    Iterator<Submitted> iterator = foundList.iterator();
                    while (true) {
                        if (!iterator.hasNext()) continue block13;
                        Submitted found = iterator.next();
                        logger.trace((Object)("handling pending " + (this.object ? "OBJ " : "JOB ") + found.getTitle() + ", ID : " + found.getSearchId()));
                        try {
                            JobExecutionManager.start(found);
                        }
                        catch (Exception e) {
                            logger.error((Object)("Unable to execute " + found), (Throwable)e);
                            if (found == null) continue;
                            SubmittedManager.updateStatus(found.getSearchId(), SubmittedStatus.Error);
                        }
                    }
                }
                catch (Exception e) {
                    logger.error((Object)"Unexpected exception", (Throwable)e);
                    try {
                        Thread.sleep(2000L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
                continue;
            }
            finally {
                try {
                    Thread.sleep(2000L);
                }
                catch (InterruptedException interruptedException) {}
                continue;
            }
            break;
        }
    }
}

