/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.application.aquamaps.aquamapsservice.impl.db.managers;

import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.List;
import org.gcube.application.aquamaps.aquamapsservice.impl.ServiceContext;
import org.gcube.application.aquamaps.aquamapsservice.impl.db.DBSession;
import org.gcube.application.aquamaps.aquamapsservice.impl.util.ServiceUtils;
import org.gcube.application.aquamaps.aquamapsservice.stubs.ExportCSVSettings;
import org.gcube.application.aquamaps.aquamapsservice.stubs.ExportStatus;
import org.gcube.application.aquamaps.aquamapsservice.stubs.ExportTableStatusType;
import org.gcube.application.aquamaps.aquamapsservice.stubs.datamodel.enhanced.Field;
import org.gcube.application.aquamaps.aquamapsservice.stubs.datamodel.types.FieldType;
import org.gcube.application.aquamaps.aquamapsservice.stubs.datamodel.xstream.AquaMapsXStream;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube_system.namespaces.application.aquamaps.types.OrderDirection;

public class ExportManager
extends Thread {
    private static final GCUBELog logger = new GCUBELog(ExportManager.class);
    private static final String EXPORT_REFERENCE_TABLE = "exports";
    private static final String EXPORT_ID = "id";
    private static final String EXPORT_TABLE = "toexporttable";
    private static final String EXPORT_SETTINGS = "settings";
    private static final String EXPORT_STATUS = "status";
    private static final String EXPORT_ERROR_MSG = "errors";
    private static final String EXPORT_LOCAL_PATH = "localpath";
    private static final String EXPORT_TIME = "time";
    private static final String EXPORT_LOCATOR = "locator";
    private static final String EXPORT_SCOPE = "scope";
    private static final String EXPORT_OPERATION = "operation";
    private static final String EXPORT_USER = "user";
    private static final String EXPORT_BASKET = "basket";
    private static final String EXPORT_NAME = "name";
    private String referenceId;

    public static String submitExportOperation(String tableName, ExportCSVSettings settings) throws Exception {
        DBSession session = null;
        try {
            session = DBSession.getInternalDBSession();
            String referenceId = ServiceUtils.generateId("EXPORT", "").toLowerCase();
            ArrayList<Field> row = new ArrayList<Field>();
            row.add(new Field(EXPORT_ID, referenceId, FieldType.STRING));
            row.add(new Field(EXPORT_TABLE, tableName, FieldType.STRING));
            row.add(new Field(EXPORT_SETTINGS, AquaMapsXStream.getXMLInstance().toXML((Object)settings), FieldType.STRING));
            row.add(new Field(EXPORT_STATUS, "PENDING", FieldType.STRING));
            row.add(new Field(EXPORT_SCOPE, "" + ServiceContext.getContext().getScope(), FieldType.STRING));
            ArrayList<List<Field>> rows = new ArrayList<List<Field>>();
            rows.add(row);
            session.insertOperation(EXPORT_REFERENCE_TABLE, rows);
            ExportManager thread = new ExportManager(referenceId);
            thread.start();
            String string = referenceId;
            return string;
        }
        finally {
            if (session != null) {
                session.close();
            }
        }
    }

    public static ExportTableStatusType getStatus(String requestId) throws Exception {
        DBSession session = null;
        try {
            session = DBSession.getInternalDBSession();
            ArrayList<Field> field = new ArrayList<Field>();
            field.add(new Field(EXPORT_ID, requestId, FieldType.STRING));
            ResultSet rs = session.executeFilteredQuery(field, EXPORT_REFERENCE_TABLE, EXPORT_ID, OrderDirection.ASC);
            if (rs.next()) {
                ExportTableStatusType status = new ExportTableStatusType();
                status.setCsvSettings((ExportCSVSettings)AquaMapsXStream.getXMLInstance().fromXML(rs.getString(EXPORT_SETTINGS)));
                status.setStatus(ExportStatus.fromValue((String)rs.getString(EXPORT_STATUS)));
                status.setRsLocator(rs.getString(EXPORT_LOCATOR));
                status.setTableName(rs.getString(EXPORT_TABLE));
                status.setErrors(rs.getString(EXPORT_ERROR_MSG));
                logger.debug((Object)("Found export status [refID:" + requestId + "] : " + status.getStatus() + "," + status.getTableName() + "," + status.getRsLocator()));
                ExportTableStatusType exportTableStatusType = status;
                return exportTableStatusType;
            }
            throw new Exception("Reference " + requestId + " not found");
        }
        finally {
            if (session != null) {
                session.close();
            }
        }
    }

    private static int updateField(String id, String field, FieldType objectType, Object value) throws Exception {
        DBSession session = null;
        try {
            session = DBSession.getInternalDBSession();
            ArrayList<List<Field>> keys = new ArrayList<List<Field>>();
            ArrayList<Field> filter = new ArrayList<Field>();
            filter.add(new Field(EXPORT_ID, id, FieldType.STRING));
            keys.add(filter);
            ArrayList<List<Field>> values = new ArrayList<List<Field>>();
            ArrayList<Field> valueList = new ArrayList<Field>();
            valueList.add(new Field(String.valueOf(field), "" + value, objectType));
            values.add(valueList);
            int n = session.updateOperation(EXPORT_REFERENCE_TABLE, keys, values);
            return n;
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            if (session != null) {
                session.close();
            }
        }
    }

    private ExportManager(String referenceId) {
        this.referenceId = referenceId;
        this.setName("EXPORTER_" + this.getId());
    }

    @Override
    public void run() {
        throw new Error("Unresolved compilation problem: \n\tsave cannot be resolved to a variable\n");
    }
}

