/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.application.aquamaps.aquamapsservice.impl.engine.analysis;

import java.awt.Image;
import java.util.ArrayList;
import java.util.Map;
import org.gcube.application.aquamaps.aquamapsservice.impl.ServiceContext;
import org.gcube.application.aquamaps.aquamapsservice.impl.engine.analysis.AnalysisRequest;
import org.gcube.application.aquamaps.aquamapsservice.impl.engine.analysis.AnalysisResponseDescriptor;
import org.gcube.application.aquamaps.aquamapsservice.impl.engine.analysis.ImageDescriptor;
import org.gcube.application.aquamaps.aquamapsservice.stubs.datamodel.environments.EnvironmentalExecutionReportItem;
import org.gcube.application.aquamaps.aquamapsservice.stubs.datamodel.fields.HCAF_SFields;
import org.gcube.application.aquamaps.aquamapsservice.stubs.datamodel.fields.HSPECFields;
import org.gcube.application.aquamaps.aquamapsservice.stubs.datamodel.types.AnalysisType;
import org.gcube.application.aquamaps.aquamapsservice.stubs.datamodel.types.ResourceType;
import org.gcube.application.aquamaps.enabling.model.DBDescriptor;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.dataanalysis.ecoengine.evaluation.bioclimate.BioClimateAnalysis;

public class Analyzer {
    private static final GCUBELog logger = new GCUBELog(Analyzer.class);
    private BioClimateAnalysis bioClimate = null;
    private Integer internalId;

    public Analyzer(int i) {
        this.internalId = i;
        logger.trace((Object)("Created batch analyzer with ID " + this.internalId));
    }

    public EnvironmentalExecutionReportItem getReport(boolean getResources) {
        EnvironmentalExecutionReportItem toReturn = new EnvironmentalExecutionReportItem();
        float status = this.bioClimate.getStatus();
        logger.debug((Object)("bioclimate status for analyzer id " + this.internalId + " = " + status));
        toReturn.setPercent(new Double(status));
        return toReturn;
    }

    public void setConfiguration(String path, DBDescriptor credentials) throws Exception {
        logger.trace((Object)("***** SETTING ANALYZER GENERATOR CONFIGURATION (path : " + path + ")"));
        String user = credentials.getUser();
        String password = credentials.getPassword();
        String url = "jdbc:postgresql:" + credentials.getEntryPoint();
        logger.trace((Object)("passed argument : user " + user));
        logger.trace((Object)("passed argument : password " + password));
        logger.trace((Object)("passed argument : url " + url));
        this.bioClimate = new BioClimateAnalysis(path, ServiceContext.getContext().getFolderPath(ServiceContext.FOLDERS.ANALYSIS), url, user, password, false);
    }

    public void produceImages(final AnalysisRequest toPerform) throws Exception {
        final Analyzer instance = this;
        Thread t = new Thread(){

            @Override
            public void run() {
                AnalysisResponseDescriptor toReturn = new AnalysisResponseDescriptor(toPerform.getToPerformAnalysis());
                logger.debug((Object)("Analyzer inner thread, request is " + toPerform));
                try {
                    try {
                        String groupLabel = Analyzer.getLabel(toPerform.getToPerformAnalysis());
                        switch (toPerform.getToPerformAnalysis()) {
                            case HCAF: {
                                Analyzer.this.bioClimate.hcafEvolutionAnalysis(toPerform.getTables(ResourceType.HCAF), toPerform.getLabels(ResourceType.HCAF));
                                break;
                            }
                            case HSPEC: {
                                Analyzer.this.bioClimate.hspecEvolutionAnalysis(toPerform.getTables(ResourceType.HSPEC), toPerform.getLabels(ResourceType.HSPEC), "" + HSPECFields.probability, "" + HCAF_SFields.csquarecode, toPerform.getHspecThreshold());
                                break;
                            }
                            case MIXED: {
                                Analyzer.this.bioClimate.globalEvolutionAnalysis(toPerform.getTables(ResourceType.HCAF), toPerform.getTables(ResourceType.HSPEC), toPerform.getLabels(ResourceType.HCAF), toPerform.getLabels(ResourceType.HSPEC), "" + HSPECFields.probability, "" + HCAF_SFields.csquarecode, toPerform.getHspecThreshold());
                                break;
                            }
                            case GEOGRAPHIC_HCAF: {
                                Analyzer.this.bioClimate.geographicEvolutionAnalysis(toPerform.getTables(ResourceType.HCAF), toPerform.getLabels(ResourceType.HCAF));
                                break;
                            }
                            case GEOGRAPHIC_HSPEC: {
                                Analyzer.this.bioClimate.speciesGeographicEvolutionAnalysis(toPerform.getTables(ResourceType.HSPEC), toPerform.getLabels(ResourceType.HSPEC), toPerform.getHspecThreshold());
                                break;
                            }
                            case HSPEN: {
                                Analyzer.this.bioClimate.speciesEvolutionAnalysis(toPerform.getTables(ResourceType.HSPEN), toPerform.getLabels(ResourceType.HSPEN), BioClimateAnalysis.salinityMinFeature, BioClimateAnalysis.salinityDefaultRange);
                            }
                        }
                        ArrayList<ImageDescriptor> generated = new ArrayList<ImageDescriptor>();
                        for (Map.Entry entry : Analyzer.this.bioClimate.getProducedImages().entrySet()) {
                            logger.debug((Object)("Adding image " + (String)entry.getKey()));
                            generated.add(new ImageDescriptor((String)entry.getKey(), (Image)entry.getValue()));
                        }
                        toReturn.getCategorizedImages().put(groupLabel, generated);
                    }
                    catch (Exception e) {
                        toReturn.getResults().put(toPerform.getToPerformAnalysis(), false);
                        toReturn.getMessages().put(toPerform.getToPerformAnalysis(), "CAUSE : " + e.getMessage());
                        toPerform.notify(toReturn, instance);
                    }
                }
                finally {
                    toPerform.notify(toReturn, instance);
                }
            }
        };
        t.start();
    }

    private static final String getLabel(AnalysisType type) {
        switch (type) {
            case GEOGRAPHIC_HCAF: {
                return "Environment_Analysis_By_Area";
            }
            case GEOGRAPHIC_HSPEC: {
                return "Prediction_Analysis_By_Area";
            }
            case HCAF: {
                return "Overall_Environment_Analysis";
            }
            case HSPEC: {
                return "Overall_Prediction_Analysis";
            }
            case HSPEN: {
                return "Envelope_Analysis";
            }
        }
        throw new IllegalArgumentException();
    }

    public Integer getReportId() {
        return this.internalId;
    }
}

