/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.application.aquamaps.publisher.impl.model;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.axis.components.uuid.UUIDGenFactory;
import org.apache.commons.io.FileUtils;
import org.gcube.application.aquamaps.publisher.MetaInformations;
import org.gcube.application.aquamaps.publisher.impl.PublisherImpl;
import org.gcube.application.aquamaps.publisher.impl.model.CoverageDescriptor;
import org.gcube.application.aquamaps.publisher.impl.model.File;
import org.gcube.application.aquamaps.publisher.impl.model.Storable;
import org.gcube.application.aquamaps.publisher.impl.model.searchsupport.FileSetSpeciesIdPair;
import org.gcube.application.aquamaps.publisher.impl.model.searchsupport.LayerSpeciesIdPair;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.common.dbinterface.Specification;
import org.gcube.common.dbinterface.persistence.ObjectPersistency;
import org.gcube.common.dbinterface.persistence.PersistencyCallback;
import org.gcube.common.dbinterface.persistence.annotations.FieldDefinition;
import org.gcube.common.dbinterface.persistence.annotations.TableRootDefinition;

@TableRootDefinition
public class FileSet
extends CoverageDescriptor
implements Storable {
    private static GCUBELog logger = new GCUBELog(FileSet.class);
    @FieldDefinition(precision={40}, specifications={Specification.NOT_NULL, Specification.PRIMARY_KEY})
    private String id;
    @FieldDefinition
    private List<File> files;
    @FieldDefinition
    private MetaInformations metaInfo;
    @FieldDefinition
    private String storingPath;
    private String[] speciesIds;

    private FileSet() {
    }

    public FileSet(List<File> files, CoverageDescriptor coverage, String storingPath, MetaInformations metainfo) {
        super(coverage.getTableId(), coverage.getParameters());
        this.storingPath = storingPath;
        this.id = UUIDGenFactory.getUUIDGen().nextUUID();
        this.files = files;
        this.metaInfo = metainfo;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void setId(String id) {
        this.id = id;
    }

    public List<File> getFiles() {
        return this.files;
    }

    public void setFiles(List<File> files) {
        this.files = files;
    }

    public MetaInformations getMetaInfo() {
        return this.metaInfo;
    }

    public String getStoringPath() {
        return this.storingPath;
    }

    public String[] getSpeciesIds() {
        return this.speciesIds;
    }

    public void setSpeciesIds(String[] speciesIds) {
        this.speciesIds = speciesIds;
    }

    static {
        try {
            ObjectPersistency.get(FileSet.class).addCallback((PersistencyCallback)new PersistencyCallback<FileSet>(){

                public void onObjectDeleted(FileSet obj) {
                    for (File file : obj.getFiles()) {
                        try {
                            file.unpublish();
                        }
                        catch (Exception e) {
                            logger.warn((Object)"error publisshing file", (Throwable)e);
                        }
                    }
                    java.io.File path = new java.io.File(obj.getStoringPath());
                    while (path.getParent() != null) {
                        path = path.getParentFile();
                    }
                    try {
                        FileUtils.deleteDirectory((java.io.File)path);
                    }
                    catch (Exception e) {
                        logger.warn((Object)"error deleting directory", (Throwable)e);
                    }
                    try {
                        ObjectPersistency.get(LayerSpeciesIdPair.class).deleteByValue("id", (Object)obj.getId());
                    }
                    catch (Exception e) {
                        logger.warn((Object)"error deleting layer speciesId relation", (Throwable)e);
                    }
                    try {
                        ObjectPersistency.get(FileSetSpeciesIdPair.class).deleteByValue("id", (Object)obj.getId());
                    }
                    catch (Exception e) {
                        logger.warn((Object)"error removing fileset speciesId relation", (Throwable)e);
                    }
                }

                public void onBeforeStore(FileSet obj) {
                    java.io.File dir = new java.io.File(PublisherImpl.serverPathDir.getAbsolutePath() + java.io.File.separator + obj.getStoringPath());
                    dir.mkdirs();
                    logger.trace((Object)("publishing files in dir " + dir.getAbsolutePath()));
                    for (File file : obj.getFiles()) {
                        try {
                            logger.trace((Object)("publishing file " + file.getName()));
                            file.publish(obj.getStoringPath(), false);
                            logger.trace((Object)(file.getName() + " published"));
                        }
                        catch (Exception e) {
                            logger.warn((Object)("error publishing file " + file.getName()), (Throwable)e);
                        }
                    }
                }

                public void onObjectUpdated(FileSet obj) {
                    java.io.File dir = new java.io.File(PublisherImpl.serverPathDir.getAbsolutePath() + java.io.File.separator + obj.getStoringPath());
                    if (!dir.exists()) {
                        dir.mkdirs();
                    }
                    for (File file : obj.getFiles()) {
                        try {
                            if (file.getOriginalUri() == null) continue;
                            file.publish(obj.getStoringPath(), true);
                        }
                        catch (Exception e) {
                            logger.warn((Object)("error publishing file " + file.getName()), (Throwable)e);
                        }
                    }
                    try {
                        ObjectPersistency.get(FileSetSpeciesIdPair.class).deleteByValue("id", (Object)obj.getId());
                        for (String speciesId : obj.getSpeciesIds()) {
                            ObjectPersistency.get(FileSetSpeciesIdPair.class).insert((Object)new FileSetSpeciesIdPair(speciesId, obj.getId()));
                        }
                    }
                    catch (Exception e) {
                        logger.warn((Object)"error updating fileset speciesId relation", (Throwable)e);
                    }
                }

                public void onObjectLoaded(FileSet obj) {
                    ArrayList<String> toSet = new ArrayList<String>();
                    try {
                        Iterator it = ObjectPersistency.get(FileSetSpeciesIdPair.class).getObjectByField("id", (Object)obj.getId()).iterator();
                        while (it.hasNext()) {
                            toSet.add(((FileSetSpeciesIdPair)it.next()).getSpeciesId());
                        }
                    }
                    catch (Exception e) {
                        toSet = new ArrayList();
                    }
                    obj.setSpeciesIds(toSet.toArray(new String[toSet.size()]));
                }

                public void onObjectStored(FileSet obj) {
                    try {
                        for (String speciesId : obj.getSpeciesIds()) {
                            ObjectPersistency.get(FileSetSpeciesIdPair.class).insert((Object)new FileSetSpeciesIdPair(speciesId, obj.getId()));
                        }
                    }
                    catch (Exception e) {
                        logger.warn((Object)"error storing fileset speciesId relation", (Throwable)e);
                    }
                }
            });
        }
        catch (Exception e) {
            logger.error((Object)"error adding callback", (Throwable)e);
        }
    }
}

