/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.application.aquamaps.aquamapsservice.stubs.wrapper;

import java.io.File;
import java.net.URI;
import java.rmi.Remote;
import java.util.List;
import org.gcube.application.aquamaps.aquamapsservice.stubs.DataManagementPortType;
import org.gcube.application.aquamaps.aquamapsservice.stubs.GenerateMapsRequestType;
import org.gcube.application.aquamaps.aquamapsservice.stubs.GetGenerationLiveReportResponseType;
import org.gcube.application.aquamaps.aquamapsservice.stubs.ImportResourceRequestType;
import org.gcube.application.aquamaps.aquamapsservice.stubs.RemoveHSPECGroupGenerationRequestResponseType;
import org.gcube.application.aquamaps.aquamapsservice.stubs.SetUserCustomQueryRequestType;
import org.gcube.application.aquamaps.aquamapsservice.stubs.ViewCustomQueryRequestType;
import org.gcube.application.aquamaps.aquamapsservice.stubs.datamodel.enhanced.Analysis;
import org.gcube.application.aquamaps.aquamapsservice.stubs.datamodel.enhanced.Field;
import org.gcube.application.aquamaps.aquamapsservice.stubs.datamodel.enhanced.Resource;
import org.gcube.application.aquamaps.aquamapsservice.stubs.datamodel.environments.EnvironmentalExecutionReportItem;
import org.gcube.application.aquamaps.aquamapsservice.stubs.datamodel.environments.SourceGenerationRequest;
import org.gcube.application.aquamaps.aquamapsservice.stubs.datamodel.types.ResourceType;
import org.gcube.application.aquamaps.aquamapsservice.stubs.service.DataManagementServiceAddressingLocator;
import org.gcube.application.aquamaps.aquamapsservice.stubs.wrapper.AquaMapsCall;
import org.gcube.application.aquamaps.aquamapsservice.stubs.wrapper.DataManagementInterface;
import org.gcube.application.aquamaps.aquamapsservice.stubs.wrapper.ServiceException;
import org.gcube.application.aquamaps.aquamapsservice.stubs.wrapper.utils.RSWrapper;
import org.gcube.common.core.contexts.GCUBERemotePortTypeContext;
import org.gcube.common.core.faults.GCUBEFault;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.common.core.security.GCUBESecurityManager;
import org.gcube.common.core.security.GCUBESecurityManagerImpl;
import org.gcube.common.core.types.StringArray;
import org.gcube.common.core.types.VOID;
import org.gcube_system.namespaces.application.aquamaps.types.PagedRequestSettings;

public class DataManagementCall
extends AquaMapsCall
implements DataManagementInterface {
    private DataManagementPortType pt;

    public static DataManagementInterface getWrapper(GCUBEScope scope, GCUBESecurityManager[] securityManager, String defaultURI, boolean queryIS) throws Exception {
        return new DataManagementCall(scope, securityManager, defaultURI, queryIS);
    }

    public static DataManagementInterface getCall(GCUBEScope scope, String defaultURI, boolean queryIS) throws Exception {
        GCUBESecurityManagerImpl secMan = new GCUBESecurityManagerImpl(){

            public boolean isSecurityEnabled() {
                return false;
            }
        };
        return new DataManagementCall(scope, new GCUBESecurityManager[]{secMan}, defaultURI, queryIS);
    }

    private DataManagementCall(GCUBEScope scope, GCUBESecurityManager[] securityManager, String defaultURI, boolean queryIS) throws Exception {
        super(scope, securityManager, defaultURI, queryIS);
        this.pt = (DataManagementPortType)GCUBERemotePortTypeContext.getProxy((Remote)new DataManagementServiceAddressingLocator().getDataManagementPortTypePort(this.epr), (GCUBEScope)scope, (int)120000, (GCUBESecurityManager[])securityManager);
    }

    protected String getPortTypeName() {
        return "gcube/application/aquamaps/aquamapsservice/DataManagement";
    }

    @Override
    public String submitRequest(SourceGenerationRequest request) throws Exception {
        try {
            return this.pt.generateHSPECGroup(request.toStubsVersion());
        }
        catch (GCUBEFault f) {
            logger.error((Object)"Service thrown Fault ", (Throwable)f);
            throw new ServiceException(f.getFaultMessage());
        }
    }

    @Override
    public EnvironmentalExecutionReportItem getReport(List<String> ids) throws Exception {
        try {
            GetGenerationLiveReportResponseType report = this.pt.getGenerationLiveReportGroup(new StringArray(ids.toArray(new String[ids.size()])));
            return new EnvironmentalExecutionReportItem(report.getPercent(), report.getResourceLoad(), report.getResourceMap(), report.getElaboratedSpecies());
        }
        catch (GCUBEFault f) {
            logger.error((Object)"Service thrown Fault ", (Throwable)f);
            throw new ServiceException(f.getFaultMessage());
        }
    }

    @Override
    public String getJSONSPECGroupGenreationRequests(PagedRequestSettings settings) throws Exception {
        try {
            return this.pt.getJSONSubmittedHSPECGroup(settings);
        }
        catch (GCUBEFault f) {
            logger.error((Object)"Service thrown Fault ", (Throwable)f);
            throw new ServiceException(f.getFaultMessage());
        }
    }

    @Override
    public Integer generateMaps(String author, boolean enableGIS, Integer hspecId, List<Field> speciesFilter, boolean forceRegeneration) throws Exception {
        try {
            GenerateMapsRequestType request = new GenerateMapsRequestType();
            request.setAuthor(author);
            request.setGenerateLayers(enableGIS);
            request.setHSPECId(hspecId.intValue());
            request.setSpeciesFilter(Field.toStubsVersion(speciesFilter));
            request.setForceRegeneration(forceRegeneration);
            return this.pt.generateMaps(request);
        }
        catch (GCUBEFault f) {
            logger.error((Object)"Service thrown Fault ", (Throwable)f);
            throw new ServiceException(f.getFaultMessage());
        }
    }

    @Override
    public SourceGenerationRequest getRequest(String id) throws Exception {
        try {
            throw new GCUBEFault(new String[]{"not Ready"});
        }
        catch (GCUBEFault f) {
            logger.error((Object)"Service thrown Fault ", (Throwable)f);
            throw new ServiceException(f.getFaultMessage());
        }
    }

    @Override
    public String removeRequest(String id, boolean deleteData, boolean deleteJobs) throws Exception {
        try {
            RemoveHSPECGroupGenerationRequestResponseType request = new RemoveHSPECGroupGenerationRequestResponseType();
            request.setRequestId(id);
            request.setRemoveTables(deleteData);
            request.setRemoveJobs(deleteJobs);
            this.pt.removeHSPECGroup(request);
            return "Done";
        }
        catch (GCUBEFault f) {
            logger.error((Object)"Service thrown Fault ", (Throwable)f);
            throw new ServiceException(f.getFaultMessage());
        }
    }

    @Override
    public void editRequest(SourceGenerationRequest request) throws Exception {
        try {
            throw new GCUBEFault(new String[]{"Not Ymplemented"});
        }
        catch (GCUBEFault f) {
            logger.error((Object)"Service thrown Fault ", (Throwable)f);
            throw new ServiceException(f.getFaultMessage());
        }
    }

    @Override
    public List<Field> getDefaultSources() throws Exception {
        try {
            return Field.load(this.pt.getDefaultSources(new VOID()));
        }
        catch (GCUBEFault f) {
            logger.error((Object)"Service thrown Fault ", (Throwable)f);
            throw new ServiceException(f.getFaultMessage());
        }
    }

    @Override
    public Resource updateResource(Resource toUpdate) throws Exception {
        try {
            return new Resource(this.pt.editResource(toUpdate.toStubsVersion()));
        }
        catch (GCUBEFault f) {
            logger.error((Object)"Service thrown Fault ", (Throwable)f);
            throw new ServiceException(f.getFaultMessage());
        }
    }

    @Override
    public void deleteResource(int resourceId) throws Exception {
        try {
            this.pt.removeResource(resourceId);
        }
        catch (GCUBEFault f) {
            logger.error((Object)"Service thrown Fault ", (Throwable)f);
            throw new ServiceException(f.getFaultMessage());
        }
    }

    @Override
    public File exportResource(int resourceId) throws Exception {
        try {
            String locator = this.pt.exportResource(resourceId);
            return RSWrapper.getStreamFromLocator(new URI(locator));
        }
        catch (GCUBEFault f) {
            logger.error((Object)"Service thrown Fault ", (Throwable)f);
            throw new ServiceException(f.getFaultMessage());
        }
    }

    @Override
    public Boolean deleteCustomQuery(String userId) throws Exception {
        try {
            return this.pt.deleteCustomQuery(userId);
        }
        catch (GCUBEFault f) {
            logger.error((Object)"Service thrown Fault ", (Throwable)f);
            throw new ServiceException(f.getFaultMessage());
        }
    }

    @Override
    public void setCustomQuery(String userId, String queryString) throws Exception {
        try {
            this.pt.setCustomQuery(new SetUserCustomQueryRequestType(queryString, userId));
        }
        catch (GCUBEFault f) {
            logger.error((Object)"Service thrown Fault ", (Throwable)f);
            throw new ServiceException(f.getFaultMessage());
        }
    }

    @Override
    public String viewCustomQuery(String userId, PagedRequestSettings settings) throws Exception {
        try {
            return this.pt.viewCustomQuery(new ViewCustomQueryRequestType(settings, userId));
        }
        catch (GCUBEFault f) {
            logger.error((Object)"Service thrown Fault ", (Throwable)f);
            throw new ServiceException(f.getFaultMessage());
        }
    }

    @Override
    public Integer getImportStatus(Integer resourceId) throws Exception {
        try {
            return this.pt.getImportStatus(resourceId.intValue());
        }
        catch (GCUBEFault f) {
            logger.error((Object)"Service thrown Fault ", (Throwable)f);
            throw new ServiceException(f.getFaultMessage());
        }
    }

    @Override
    public Integer importResource(File toImport, String userId, ResourceType type, String encoding, boolean[] fieldsMask, boolean hasHeader, char delimiter) throws Exception {
        try {
            logger.trace((Object)("Caller scope is " + this.scope));
            RSWrapper wrapper = new RSWrapper(this.scope);
            wrapper.add(toImport);
            String locator = wrapper.getLocator().toString();
            logger.trace((Object)("Added file to locator " + locator));
            return this.pt.importResource(new ImportResourceRequestType(String.valueOf(delimiter), encoding, fieldsMask, hasHeader, "" + (Object)((Object)type), locator, userId));
        }
        catch (GCUBEFault f) {
            logger.error((Object)"Service thrown Fault ", (Throwable)f);
            throw new ServiceException(f.getFaultMessage());
        }
    }

    @Override
    public List<Field> getCustomQueryFields(String userId) throws Exception {
        try {
            return Field.load(this.pt.isCustomQueryReady(userId));
        }
        catch (GCUBEFault f) {
            logger.error((Object)"Service thrown Fault ", (Throwable)f);
            throw new ServiceException(f.getFaultMessage());
        }
    }

    @Override
    public File exportTableAsCSV(String table) throws Exception {
        try {
            String locator = this.pt.exportTableAsCSV(table);
            return RSWrapper.getStreamFromLocator(new URI(locator));
        }
        catch (GCUBEFault f) {
            logger.error((Object)"Service thrown Fault ", (Throwable)f);
            throw new ServiceException(f.getFaultMessage());
        }
    }

    @Override
    public String analyzeTables(Analysis request) throws Exception {
        try {
            return this.pt.analyzeTables(request.toStubsVersion());
        }
        catch (GCUBEFault f) {
            logger.error((Object)"Service thrown Fault ", (Throwable)f);
            throw new ServiceException(f.getFaultMessage());
        }
    }

    @Override
    public String getJsonSubmittedAnalysis(PagedRequestSettings settings) throws Exception {
        try {
            return this.pt.getJSONSubmittedAnalysis(settings);
        }
        catch (GCUBEFault f) {
            logger.error((Object)"Service thrown Fault ", (Throwable)f);
            throw new ServiceException(f.getFaultMessage());
        }
    }

    @Override
    public File loadAnalysisResults(String id) throws Exception {
        try {
            String locator = this.pt.loadAnalysis(id);
            return RSWrapper.getStreamFromLocator(new URI(locator));
        }
        catch (GCUBEFault f) {
            logger.error((Object)"Service thrown Fault ", (Throwable)f);
            throw new ServiceException(f.getFaultMessage());
        }
    }

    @Override
    public String resubmitGeneration(String id) throws Exception {
        try {
            return this.pt.resubmitGeneration(id);
        }
        catch (GCUBEFault f) {
            logger.error((Object)"Service thrown Fault ", (Throwable)f);
            throw new ServiceException(f.getFaultMessage());
        }
    }

    @Override
    public File exportCurrentCustomQuery(String userId) throws Exception {
        try {
            String locator = this.pt.exportCustomQuery(userId);
            return RSWrapper.getStreamFromLocator(new URI(locator));
        }
        catch (GCUBEFault f) {
            logger.error((Object)"Service thrown Fault ", (Throwable)f);
            throw new ServiceException(f.getFaultMessage());
        }
    }

    @Override
    public void deleteAnalysis(String id) throws Exception {
        try {
            this.pt.deleteAnalysis(id);
        }
        catch (GCUBEFault f) {
            logger.error((Object)"Service thrown Fault ", (Throwable)f);
            throw new ServiceException(f.getFaultMessage());
        }
    }
}

