/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.application.aquamaps.aquamapsservice.stubs.datamodel.enhanced;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.gcube.application.aquamaps.aquamapsservice.stubs.datamodel.enhanced.File;
import org.gcube.application.aquamaps.aquamapsservice.stubs.datamodel.enhanced.Resource;
import org.gcube.application.aquamaps.aquamapsservice.stubs.fw.model.Map;
import org.gcube.application.aquamaps.aquamapsservice.stubs.fw.model.collections.MapArray;
import org.gcube.application.aquamaps.aquamapsservice.stubs.fw.types.ObjectType;
import org.gcube.application.aquamaps.aquamapsservice.stubs.fw.types.ResourceType;
import org.gcube.common.gis.datamodel.enhanced.LayerInfo;
import org.json.JSONException;

@XStreamAlias(value="AquaMap")
public class AquaMap {
    private LayerInfo layer = null;
    private boolean gis = false;
    private String title = "";
    private ObjectType mapType = ObjectType.SpeciesDistribution;
    private ArrayList<File> files = new ArrayList();
    private Resource resource = new Resource(ResourceType.HSPEC, 0);
    private String coverage = "";
    private Long creationDate = 0L;
    private String author = "";
    private String fileSetId = "";
    private String layerId = "";
    private String speciesCsvList = "";
    private Boolean custom = false;

    public AquaMap() {
    }

    public Map toStubsVersion() throws JSONException {
        Map toReturn = new Map();
        toReturn.author(this.author);
        toReturn.coverage(this.coverage);
        toReturn.creationDate(this.creationDate);
        toReturn.fileSetId(this.fileSetId);
        toReturn.gis(this.gis);
        if (this.gis) {
            toReturn.gisLayer(this.layer.toStubsVersion());
        }
        toReturn.layerId(this.layerId);
        toReturn.mapType((Object)((Object)this.mapType) + "");
        toReturn.resource(this.resource.toStubsVersion());
        toReturn.speciesListCSV(this.speciesCsvList);
        toReturn.staticImages(File.toStubsVersion(this.files));
        toReturn.title(this.title);
        toReturn.custom(this.isCustom());
        return toReturn;
    }

    public AquaMap(Map toLoad) {
        this.setAuthor(toLoad.author());
        this.setCoverage(toLoad.coverage());
        this.setCreationDate(toLoad.creationDate());
        this.setFiles(File.load(toLoad.staticImages()));
        this.setFileSetId(toLoad.fileSetId());
        this.setGis(toLoad.gis());
        if (this.isGis()) {
            this.setLayer(new LayerInfo(toLoad.gisLayer()));
        }
        this.setLayerId(toLoad.layerId());
        this.setMapType(ObjectType.valueOf(toLoad.mapType()));
        this.setResource(new Resource(toLoad.resource()));
        this.setSpeciesCsvList(toLoad.speciesListCSV());
        this.setTitle(toLoad.title());
        this.setCustom(toLoad.custom());
    }

    public static MapArray toStubsVersion(Collection<AquaMap> toConvert) throws JSONException {
        ArrayList<Map> list = new ArrayList<Map>();
        if (toConvert != null) {
            for (AquaMap a : toConvert) {
                list.add(a.toStubsVersion());
            }
        }
        return new MapArray(list);
    }

    public static List<AquaMap> load(MapArray toLoad) {
        ArrayList<AquaMap> toReturn = new ArrayList<AquaMap>();
        if (toLoad != null && toLoad.theList() != null) {
            for (Map m : toLoad.theList()) {
                toReturn.add(new AquaMap(m));
            }
        }
        return toReturn;
    }

    public LayerInfo getLayer() {
        return this.layer;
    }

    public void setLayer(LayerInfo layer) {
        this.layer = layer;
    }

    public boolean isGis() {
        return this.gis;
    }

    public void setGis(boolean gis) {
        this.gis = gis;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public ObjectType getMapType() {
        return this.mapType;
    }

    public void setMapType(ObjectType mapType) {
        this.mapType = mapType;
    }

    public ArrayList<File> getFiles() {
        return this.files;
    }

    public void setFiles(ArrayList<File> files) {
        this.files = files;
    }

    public Resource getResource() {
        return this.resource;
    }

    public Boolean isCustom() {
        return this.custom;
    }

    public void setCustom(Boolean custom) {
        this.custom = custom;
    }

    public void setResource(Resource resource) {
        this.resource = resource;
    }

    public String getCoverage() {
        return this.coverage;
    }

    public void setCoverage(String coverage) {
        this.coverage = coverage;
    }

    public Long getCreationDate() {
        return this.creationDate;
    }

    public void setCreationDate(Long creationDate) {
        this.creationDate = creationDate;
    }

    public String getAuthor() {
        return this.author;
    }

    public void setAuthor(String author) {
        this.author = author;
    }

    public String getFileSetId() {
        return this.fileSetId;
    }

    public void setFileSetId(String fileSetId) {
        this.fileSetId = fileSetId;
    }

    public String getLayerId() {
        return this.layerId;
    }

    public void setLayerId(String layerId) {
        this.layerId = layerId;
    }

    public String getSpeciesCsvList() {
        return this.speciesCsvList;
    }

    public void setSpeciesCsvList(String speciesCsvList) {
        this.speciesCsvList = speciesCsvList;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.coverage == null ? 0 : this.coverage.hashCode());
        result = 31 * result + (this.resource == null ? 0 : this.resource.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AquaMap other = (AquaMap)obj;
        if (this.coverage == null ? other.coverage != null : !this.coverage.equals(other.coverage)) {
            return false;
        }
        return !(this.resource == null ? other.resource != null : !this.resource.equals(other.resource));
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("AquaMap [layer=");
        builder.append(this.layer);
        builder.append(", gis=");
        builder.append(this.gis);
        builder.append(", title=");
        builder.append(this.title);
        builder.append(", mapType=");
        builder.append((Object)this.mapType);
        builder.append(", files=");
        builder.append(this.files);
        builder.append(", resource=");
        builder.append(this.resource);
        builder.append(", coverage=");
        builder.append(this.coverage);
        builder.append(", creationDate=");
        builder.append(this.creationDate);
        builder.append(", author=");
        builder.append(this.author);
        builder.append(", fileSetId=");
        builder.append(this.fileSetId);
        builder.append(", layerId=");
        builder.append(this.layerId);
        builder.append(", speciesCsvList=");
        builder.append(this.speciesCsvList);
        builder.append(", custom=");
        builder.append(this.custom);
        builder.append("]");
        return builder.toString();
    }
}

