/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.application.aquamaps.aquamapsservice.client.proxies;

import java.rmi.RemoteException;
import java.util.List;
import org.gcube.application.aquamaps.aquamapsservice.client.proxies.Publisher;
import org.gcube.application.aquamaps.aquamapsservice.stubs.GetJSONSubmittedByFiltersRequestType;
import org.gcube.application.aquamaps.aquamapsservice.stubs.PublisherServicePortType;
import org.gcube.application.aquamaps.aquamapsservice.stubs.RetrieveMapsByCoverageRequestType;
import org.gcube.application.aquamaps.aquamapsservice.stubs.datamodel.enhanced.AquaMap;
import org.gcube.application.aquamaps.aquamapsservice.stubs.datamodel.enhanced.Field;
import org.gcube.application.aquamaps.aquamapsservice.stubs.datamodel.enhanced.File;
import org.gcube.application.aquamaps.aquamapsservice.stubs.datamodel.enhanced.Resource;
import org.gcube.common.clients.Call;
import org.gcube.common.clients.delegates.ProxyDelegate;
import org.gcube.common.core.types.StringArray;
import org.gcube.common.gis.datamodel.enhanced.LayerInfo;
import org.gcube_system.namespaces.application.aquamaps.types.PagedRequestSettings;

public class DefaultPublisher
implements Publisher {
    private final ProxyDelegate<PublisherServicePortType> delegate;

    public DefaultPublisher(ProxyDelegate<PublisherServicePortType> delegate) {
        this.delegate = delegate;
    }

    @Override
    public List<File> getFileSetById(final String fileSetId) throws RemoteException, Exception {
        Call<PublisherServicePortType, List<File>> call = new Call<PublisherServicePortType, List<File>>(){

            public List<File> call(PublisherServicePortType endpoint) throws Exception {
                return File.load(endpoint.getFileSetById(fileSetId));
            }
        };
        return (List)this.delegate.make((Call)call);
    }

    @Override
    public List<File> getFileSetsByCoverage(Resource source, String parameters) throws RemoteException, Exception {
        throw new Exception("Feature not available");
    }

    @Override
    public String getJsonSubmittedByFilters(List<Field> filters, PagedRequestSettings settings) throws RemoteException, Exception {
        final GetJSONSubmittedByFiltersRequestType request = new GetJSONSubmittedByFiltersRequestType();
        request.setFilters(Field.toStubsVersion(filters));
        request.setSettings(settings);
        Call<PublisherServicePortType, String> call = new Call<PublisherServicePortType, String>(){

            public String call(PublisherServicePortType endpoint) throws Exception {
                return endpoint.getJSONSubmittedByFilters(request);
            }
        };
        return (String)this.delegate.make((Call)call);
    }

    @Override
    public LayerInfo getLayerById(final String layerId) throws RemoteException, Exception {
        Call<PublisherServicePortType, LayerInfo> call = new Call<PublisherServicePortType, LayerInfo>(){

            public LayerInfo call(PublisherServicePortType endpoint) throws Exception {
                return new LayerInfo(endpoint.getLayerById(layerId));
            }
        };
        return (LayerInfo)this.delegate.make((Call)call);
    }

    @Override
    public List<LayerInfo> getLayersByCoverage(Resource source, String parameters) throws RemoteException, Exception {
        throw new Exception("Feature not available");
    }

    @Override
    public List<AquaMap> getMapsBySpecies(String[] speciesIds, boolean includeGis, boolean includeCustom, List<Resource> resources) throws RemoteException, Exception {
        final RetrieveMapsByCoverageRequestType request = new RetrieveMapsByCoverageRequestType();
        request.setIncludeCustomMaps(includeCustom);
        request.setIncludeGisLayers(includeGis);
        request.setResourceList(Resource.toStubsVersion(resources));
        request.setSpeciesList(new StringArray(speciesIds));
        Call<PublisherServicePortType, List<AquaMap>> call = new Call<PublisherServicePortType, List<AquaMap>>(){

            public List<AquaMap> call(PublisherServicePortType endpoint) throws Exception {
                return AquaMap.load(endpoint.retrieveMapsByCoverage(request));
            }
        };
        return (List)this.delegate.make((Call)call);
    }
}

