package org.gcube.application.aquamaps.aquamapsservice.client.plugins;

import org.gcube.application.aquamaps.aquamapsservice.client.Constants;
import org.gcube.application.aquamaps.aquamapsservice.client.proxies.DataManagement;
import org.gcube.application.aquamaps.aquamapsservice.client.proxies.Maps;
import org.gcube.application.aquamaps.aquamapsservice.client.proxies.Publisher;
import org.gcube.application.aquamaps.aquamapsservice.stubs.AquaMapsServicePortType;
import org.gcube.application.aquamaps.aquamapsservice.stubs.DataManagementPortType;
import org.gcube.application.aquamaps.aquamapsservice.stubs.PublisherServicePortType;
import org.gcube.common.clients.gcore.builders.StatelessBuilder;
import org.gcube.common.clients.gcore.builders.StatelessBuilderImpl;
import org.gcube.common.clients.gcore.plugins.Plugin;

public abstract class AbstractPlugin<S,P> implements Plugin<S,P> {

	private static final PublisherPlugin publisher_plugin=new PublisherPlugin();
	
	private static final DataManagementPlugin data_management_plugin=new DataManagementPlugin();
	
	private static final MapsPlugin maps_plugin=new MapsPlugin();
	
	
	public static StatelessBuilder<Publisher> publisher(){
		return new StatelessBuilderImpl<PublisherServicePortType, Publisher>(publisher_plugin);
	}
	
	public static StatelessBuilder<DataManagement> dataManagement(){
		return new StatelessBuilderImpl<DataManagementPortType, DataManagement>(data_management_plugin);
	}
	
	public static StatelessBuilder<Maps> maps(){
		return new StatelessBuilderImpl<AquaMapsServicePortType, Maps>(maps_plugin);
	}
	
	
	
	public final String name;
	
	public AbstractPlugin(String name) {
		this.name=name;
	}
	
	@Override
	public String serviceClass() {
		return Constants.SERVICE_CLASS;
	}
	
	@Override
	public String serviceName() {
		return Constants.SERVICE_NAME;
	}
	
	@Override
	public String namespace() {
		return Constants.NAMESPACE;
	}
	
	@Override
	public String name() {
		return name;
	}
}
