/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.application.aquamaps.aquamapsportlet.client.filters;

import com.gwtext.client.data.BooleanFieldDef;
import com.gwtext.client.data.FieldDef;
import com.gwtext.client.data.Record;
import com.gwtext.client.data.RecordDef;
import com.gwtext.client.data.Store;
import com.gwtext.client.data.StringFieldDef;
import com.gwtext.client.widgets.Component;
import com.gwtext.client.widgets.grid.BaseColumnConfig;
import com.gwtext.client.widgets.grid.ColumnConfig;
import com.gwtext.client.widgets.grid.ColumnModel;
import com.gwtext.client.widgets.grid.EditorGridPanel;
import com.gwtext.client.widgets.grid.Renderer;
import com.gwtext.client.widgets.grid.event.GridCellListener;
import com.gwtext.client.widgets.layout.ContainerLayout;
import com.gwtext.client.widgets.layout.FitLayout;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.gcube.application.aquamaps.aquamapsportlet.client.AquaMapsPortlet;
import org.gcube.application.aquamaps.aquamapsportlet.client.constants.fields.SpeciesFields;
import org.gcube.application.aquamaps.aquamapsportlet.client.constants.types.ClientFieldType;
import org.gcube.application.aquamaps.aquamapsportlet.client.constants.types.ClientFilterType;
import org.gcube.application.aquamaps.aquamapsportlet.client.filters.CustomFieldSet;
import org.gcube.application.aquamaps.aquamapsportlet.client.filters.FilterSummary;
import org.gcube.application.aquamaps.aquamapsportlet.client.rpc.data.ClientField;
import org.gcube.application.aquamaps.aquamapsportlet.client.rpc.data.ClientFilter;

public class TrueFalseGrid
extends CustomFieldSet {
    EditorGridPanel grid;
    RecordDef recordDef = new RecordDef(new FieldDef[]{new BooleanFieldDef("enabled"), new StringFieldDef("attribute"), new BooleanFieldDef("value")});
    static Map<String, ClientField> fields = new HashMap();
    String summaryFilterType = FilterSummary.additional;
    Store store = new Store(this.recordDef);
    ColumnModel colModel = new ColumnModel(new BaseColumnConfig[]{new ColumnConfig("Enabled", "enabled", 70, false, (Renderer)new /* Unavailable Anonymous Inner Class!! */, "enabled"), new ColumnConfig("Attribute", "attribute", 90, false, null, "attribute"), new ColumnConfig("Value", "value", 100, false, null, "value")});

    public TrueFalseGrid(String title) {
        this.setTitle(title);
        this.setWidth(340);
        this.setLayout((ContainerLayout)new FitLayout());
        this.setCollapsible(true);
        this.collapse();
        for (String fieldName : fields.keySet()) {
            this.store.add(this.recordDef.createRecord(new Object[]{false, fieldName, false}));
        }
        this.colModel.setEditable("attribute", false);
        this.colModel.setEditable("enabled", true);
        this.colModel.setEditable("value", true);
        this.grid = new EditorGridPanel(this.store, this.colModel);
        this.grid.setStripeRows(true);
        this.grid.setFrame(true);
        this.grid.addGridCellListener((GridCellListener)new /* Unavailable Anonymous Inner Class!! */);
        this.add((Component)this.grid);
    }

    public List<ClientFilter> getFilter() {
        ArrayList<ClientFilter> toReturn = new ArrayList<ClientFilter>();
        for (Record record : this.store.getRecords()) {
            if (!record.getAsBoolean("enabled")) continue;
            ClientField field = (ClientField)fields.get(record.getAsString("attribute"));
            field.setValue(String.valueOf(record.getAsBoolean("value")));
            field.setType(ClientFieldType.BOOLEAN);
            ClientFilter filter = new ClientFilter();
            filter.setField(field);
            filter.setType(ClientFilterType.is);
            toReturn.add(filter);
        }
        return toReturn;
    }

    public void reset() {
        this.store.removeAll();
        for (String fieldName : fields.keySet()) {
            this.store.add(this.recordDef.createRecord(new Object[]{false, fieldName, false}));
        }
        this.updateSummary();
    }

    public void updateSummary() {
        for (Record record : this.store.getRecords()) {
            if (record.getAsBoolean("enabled")) {
                AquaMapsPortlet.get().species.filter.filterDetails.addFilter(this.summaryFilterType, record.getAsString("attribute"), "=", record.getAsString("value"));
                continue;
            }
            AquaMapsPortlet.get().species.filter.filterDetails.removeFilter(this.summaryFilterType, record.getAsString("attribute"));
        }
    }

    static {
        ClientField pelagicField = new ClientField();
        pelagicField.setName(SpeciesFields.pelagic + "");
        pelagicField.setType(ClientFieldType.BOOLEAN);
        ClientField deepwaterField = new ClientField();
        deepwaterField.setName(SpeciesFields.deepwater + "");
        deepwaterField.setType(ClientFieldType.BOOLEAN);
        ClientField anglingField = new ClientField();
        anglingField.setName(SpeciesFields.angling + "");
        anglingField.setType(ClientFieldType.BOOLEAN);
        ClientField divingField = new ClientField();
        divingField.setName(SpeciesFields.diving + "");
        divingField.setType(ClientFieldType.BOOLEAN);
        ClientField dangerousField = new ClientField();
        dangerousField.setName(SpeciesFields.dangerous + "");
        dangerousField.setType(ClientFieldType.BOOLEAN);
        ClientField mammalField = new ClientField();
        mammalField.setName(SpeciesFields.m_mammals + "");
        mammalField.setType(ClientFieldType.BOOLEAN);
        ClientField invertebrateField = new ClientField();
        invertebrateField.setName(SpeciesFields.m_invertebrates + "");
        invertebrateField.setType(ClientFieldType.BOOLEAN);
        ClientField algaeField = new ClientField();
        algaeField.setName(SpeciesFields.algae + "");
        algaeField.setType(ClientFieldType.BOOLEAN);
        fields.put(pelagicField.getName(), pelagicField);
        fields.put(deepwaterField.getName(), deepwaterField);
        fields.put(anglingField.getName(), anglingField);
        fields.put(divingField.getName(), divingField);
        fields.put(dangerousField.getName(), dangerousField);
        fields.put(mammalField.getName(), mammalField);
        fields.put(invertebrateField.getName(), invertebrateField);
        fields.put(algaeField.getName(), algaeField);
    }
}

