/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.application.aquamaps.aquamapsportlet.servlet;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import net.sf.csv4j.CSVLineProcessor;
import net.sf.csv4j.CSVReaderProcessor;
import org.gcube.application.aquamaps.aquamapsportlet.servlet.db.DBManager;
import org.gcube.application.aquamaps.aquamapsservice.client.plugins.AbstractPlugin;
import org.gcube.application.aquamaps.aquamapsservice.client.proxies.Maps;
import org.gcube.application.aquamaps.aquamapsservice.stubs.fw.types.ResourceType;
import org.gcube.application.framework.core.session.ASLSession;
import org.gcube.common.scope.api.ScopeProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SpeciesImporterThread
extends Thread {
    private static final Logger logger = LoggerFactory.getLogger(SpeciesImporterThread.class);
    private Integer totalCount;
    private ASLSession session;

    public SpeciesImporterThread(Integer totalCount, ASLSession session, String sortColumn, String sortDir) {
        super("Species Selection Importer");
        this.totalCount = totalCount;
        this.session = session;
    }

    @Override
    public void run() {
        int hspenId = (Integer)this.session.getAttribute(ResourceType.HSPEN + "");
        this.session.setAttribute("IMPORT_PROGRESS", (Object)new Integer(0));
        try {
            logger.debug("Importing filtered species..");
            List speciesFilter = (List)this.session.getAttribute("SPECIES_FILTER");
            ArrayList ids = new ArrayList();
            ScopeProvider.instance.set(this.session.getScope().toString());
            File toImport = ((Maps)AbstractPlugin.maps().build()).getCSVSpecies(hspenId, new ArrayList(), speciesFilter);
            CSVReaderProcessor processor = new CSVReaderProcessor();
            processor.setDelimiter(',');
            processor.setHasHeader(true);
            InputStreamReader reader = new InputStreamReader((InputStream)new FileInputStream(toImport), Charset.defaultCharset());
            processor.processStream((Reader)reader, (CSVLineProcessor)new /* Unavailable Anonymous Inner Class!! */);
            if (ids.size() > 0) {
                DBManager.getInstance((String)this.session.getScope()).addToUserBasket(ids, this.session.getUsername());
                this.session.setAttribute("IMPORT_PROGRESS", (Object)this.totalCount);
            }
        }
        catch (Exception e) {
            logger.warn("Unable to add portion of selection ", (Throwable)e);
            e.printStackTrace();
        }
    }

    static /* synthetic */ ASLSession access$000(SpeciesImporterThread x0) {
        return x0.session;
    }

    static /* synthetic */ Logger access$100() {
        return logger;
    }
}

