/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.application.aquamaps.aquamapsportlet.client.filters;

import com.gwtext.client.data.BooleanFieldDef;
import com.gwtext.client.data.FieldDef;
import com.gwtext.client.data.IntegerFieldDef;
import com.gwtext.client.data.Record;
import com.gwtext.client.data.RecordDef;
import com.gwtext.client.data.Store;
import com.gwtext.client.data.StringFieldDef;
import com.gwtext.client.widgets.Component;
import com.gwtext.client.widgets.form.Field;
import com.gwtext.client.widgets.form.TextField;
import com.gwtext.client.widgets.grid.BaseColumnConfig;
import com.gwtext.client.widgets.grid.ColumnConfig;
import com.gwtext.client.widgets.grid.ColumnModel;
import com.gwtext.client.widgets.grid.EditorGridPanel;
import com.gwtext.client.widgets.grid.GridEditor;
import com.gwtext.client.widgets.grid.Renderer;
import com.gwtext.client.widgets.grid.event.EditorGridListener;
import com.gwtext.client.widgets.grid.event.GridCellListener;
import com.gwtext.client.widgets.layout.ContainerLayout;
import com.gwtext.client.widgets.layout.FitLayout;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.gcube.application.aquamaps.aquamapsportlet.client.AquaMapsPortlet;
import org.gcube.application.aquamaps.aquamapsportlet.client.constants.fields.EnvelopeFieldsClient;
import org.gcube.application.aquamaps.aquamapsportlet.client.constants.types.ClientFieldType;
import org.gcube.application.aquamaps.aquamapsportlet.client.constants.types.ClientFilterType;
import org.gcube.application.aquamaps.aquamapsportlet.client.filters.CustomFieldSet;
import org.gcube.application.aquamaps.aquamapsportlet.client.filters.FilterSummary;
import org.gcube.application.aquamaps.aquamapsportlet.client.rpc.data.ClientEnvelope;
import org.gcube.application.aquamaps.aquamapsportlet.client.rpc.data.ClientField;
import org.gcube.application.aquamaps.aquamapsportlet.client.rpc.data.ClientFilter;

public class MinMaxGrid
extends CustomFieldSet {
    EditorGridPanel grid;
    RecordDef recordDef = new RecordDef(new FieldDef[]{new StringFieldDef("attribute"), new IntegerFieldDef("min"), new IntegerFieldDef("max"), new BooleanFieldDef("enabled")});
    static Map<String, ClientField> fields = new HashMap();
    Store store = new Store(this.recordDef);
    String summaryFilterType = FilterSummary.MinMax;
    ColumnModel colModel = new ColumnModel(new BaseColumnConfig[]{new ColumnConfig("Enabled", "enabled", 50, false, (Renderer)new /* Unavailable Anonymous Inner Class!! */, "enabled"), new ColumnConfig("Attribute", "attribute", 90, false, null, "attribute"), new ColumnConfig("Min", "min", 70, false, null, "min"), new ColumnConfig("Max", "max", 70, false, null, "max")});

    public MinMaxGrid(String title) {
        this.setTitle(title);
        this.setWidth(340);
        this.setLayout((ContainerLayout)new FitLayout());
        this.setCollapsible(true);
        this.collapse();
        for (String fieldName : fields.keySet()) {
            this.store.add(this.recordDef.createRecord(new Object[]{fieldName, 0, 0, false}));
        }
        TextField minValueField = new TextField();
        minValueField.setAllowBlank(false);
        minValueField.setBlankText("0");
        TextField maxValueField = new TextField();
        maxValueField.setAllowBlank(false);
        maxValueField.setBlankText("0");
        this.colModel.setEditor("min", new GridEditor((Field)minValueField));
        this.colModel.setEditor("max", new GridEditor((Field)maxValueField));
        this.colModel.setEditable(1, false);
        this.grid = new EditorGridPanel(this.store, this.colModel);
        this.grid.setStripeRows(true);
        this.grid.addGridCellListener((GridCellListener)new /* Unavailable Anonymous Inner Class!! */);
        this.grid.setClicksToEdit(1);
        this.grid.setFrame(true);
        this.grid.addEditorGridListener((EditorGridListener)new /* Unavailable Anonymous Inner Class!! */);
        this.add((Component)this.grid);
    }

    public List<ClientFilter> getFilter() throws Exception {
        ArrayList<ClientFilter> toReturn = new ArrayList<ClientFilter>();
        for (Record record : this.store.getRecords()) {
            if (!record.getAsBoolean("enabled")) continue;
            ClientField field = (ClientField)fields.get(record.getAsString("attribute"));
            ClientField min = new ClientField();
            min.setName(ClientEnvelope.getMinName((EnvelopeFieldsClient)EnvelopeFieldsClient.valueOf((String)field.getName())) + "");
            min.setType(field.getType());
            min.setValue(String.valueOf(record.getAsInteger("min")));
            ClientFilter minFilter = new ClientFilter();
            minFilter.setField(min);
            minFilter.setType(ClientFilterType.greater_then);
            toReturn.add(minFilter);
            ClientField max = new ClientField();
            max.setName(ClientEnvelope.getMaxName((EnvelopeFieldsClient)EnvelopeFieldsClient.valueOf((String)field.getName())) + "");
            max.setType(field.getType());
            max.setValue(String.valueOf(record.getAsInteger("max")));
            ClientFilter maxFilter = new ClientFilter();
            maxFilter.setField(min);
            maxFilter.setType(ClientFilterType.smaller_then);
            toReturn.add(maxFilter);
            if (Integer.parseInt(min.getValue()) <= Integer.parseInt(max.getValue())) continue;
            throw new Exception("Incorrect range bounds for attribute " + field.getName());
        }
        return toReturn;
    }

    public void reset() {
        this.store.removeAll();
        for (String fieldName : fields.keySet()) {
            this.store.add(this.recordDef.createRecord(new Object[]{fieldName, 0, 0, false}));
        }
        this.updateSummary();
    }

    public void updateSummary() {
        for (Record record : this.store.getRecords()) {
            if (record.getAsBoolean("enabled")) {
                AquaMapsPortlet.get().species.filter.filterDetails.addFilter(this.summaryFilterType, record.getAsString("attribute") + "Min", "=>", record.getAsString("min"));
                AquaMapsPortlet.get().species.filter.filterDetails.addFilter(this.summaryFilterType, record.getAsString("attribute") + "Max", "=<", record.getAsString("max"));
                continue;
            }
            AquaMapsPortlet.get().species.filter.filterDetails.removeFilter(this.summaryFilterType, record.getAsString("attribute") + "Min");
            AquaMapsPortlet.get().species.filter.filterDetails.removeFilter(this.summaryFilterType, record.getAsString("attribute") + "Max");
        }
    }

    static {
        ClientField depthField = new ClientField();
        depthField.setName(EnvelopeFieldsClient.Depth + "");
        depthField.setType(ClientFieldType.DOUBLE);
        ClientField tempField = new ClientField();
        tempField.setName(EnvelopeFieldsClient.Temperature + "");
        tempField.setType(ClientFieldType.DOUBLE);
        ClientField salinityField = new ClientField();
        salinityField.setName(EnvelopeFieldsClient.Salinity + "");
        salinityField.setType(ClientFieldType.DOUBLE);
        ClientField iceConField = new ClientField();
        iceConField.setName(EnvelopeFieldsClient.IceConcentration + "");
        iceConField.setType(ClientFieldType.DOUBLE);
        ClientField primProdField = new ClientField();
        primProdField.setName(EnvelopeFieldsClient.PrimaryProduction + "");
        primProdField.setType(ClientFieldType.DOUBLE);
        fields.put(depthField.getName(), depthField);
        fields.put(tempField.getName(), tempField);
        fields.put(salinityField.getName(), salinityField);
        fields.put(iceConField.getName(), iceConField);
        fields.put(primProdField.getName(), primProdField);
    }
}

