/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.application.aquamaps.aquamapsportlet.servlet;

import java.io.IOException;
import java.util.ArrayList;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.gcube.application.aquamaps.aquamapsportlet.client.constants.types.ClientObjectType;
import org.gcube.application.aquamaps.aquamapsportlet.servlet.CustomServlet;
import org.gcube.application.aquamaps.aquamapsportlet.servlet.db.DBManager;
import org.gcube.application.aquamaps.aquamapsportlet.servlet.utils.Utils;
import org.gcube.application.aquamaps.aquamapsservice.client.plugins.AbstractPlugin;
import org.gcube.application.aquamaps.aquamapsservice.client.proxies.DataManagement;
import org.gcube.application.aquamaps.aquamapsservice.stubs.fw.fields.SubmittedFields;
import org.gcube.application.aquamaps.aquamapsservice.stubs.fw.model.Field;
import org.gcube.application.aquamaps.aquamapsservice.stubs.fw.model.PagedRequestSettings;
import org.gcube.application.aquamaps.aquamapsservice.stubs.fw.types.FieldType;
import org.gcube.application.aquamaps.aquamapsservice.stubs.fw.types.OrderDirection;
import org.gcube.application.aquamaps.aquamapsservice.stubs.fw.types.SystemTable;
import org.gcube.application.framework.core.session.ASLSession;
import org.gcube.common.scope.api.ScopeProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JobServlet
extends CustomServlet {
    private static final long serialVersionUID = -2979246371174057352L;
    private static final Logger logger = LoggerFactory.getLogger(JobServlet.class);

    protected void handleRequest(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        int startIndex = 0;
        int limit = 100;
        try {
            startIndex = Integer.parseInt(request.getParameter("start"));
            limit = Integer.parseInt(request.getParameter("limit"));
        }
        catch (NumberFormatException e) {
            // empty catch block
        }
        try {
            ASLSession session = Utils.getSession((HttpSession)request.getSession());
            response.setContentType("application/json; charset=utf-8");
            response.setStatus(200);
            String sortColumn = request.getParameter("sort");
            String sortDir = request.getParameter("dir");
            if (sortColumn == null) {
                sortColumn = SubmittedFields.title + "";
            }
            if (sortDir == null) {
                sortDir = "ASC";
            }
            String toReturnJSON = null;
            if (request.getParameter("type") != null) {
                toReturnJSON = DBManager.getInstance((String)session.getScope()).getJSONObjectsByType(session.getUsername(), ClientObjectType.valueOf((String)request.getParameter("type")), startIndex, limit, sortColumn, sortDir);
            } else {
                String scope = session.getScope().toString();
                logger.debug("Serving request to remote service in scope " + scope);
                ScopeProvider.instance.set(session.getScope().toString());
                DataManagement dm = (DataManagement)AbstractPlugin.dataManagement().build();
                String submittedTableName = dm.getSystemTableName(SystemTable.SUBMITTED_MAP_REQUESTS);
                ArrayList<Field> filter = new ArrayList<Field>();
                filter.add(new Field(SubmittedFields.author + "", session.getUsername(), FieldType.STRING));
                PagedRequestSettings settings = new PagedRequestSettings(limit, startIndex, sortColumn, OrderDirection.valueOf((String)sortDir));
                if (request.getParameter("Settings") != null) {
                    filter.add(new Field(SubmittedFields.isaquamap + "", "false", FieldType.BOOLEAN));
                } else {
                    String flag = (String)session.getAttribute("submittedObjectFlag");
                    boolean showAquaMaps = flag != null ? Boolean.parseBoolean(flag) : true;
                    filter.add(new Field(SubmittedFields.isaquamap + "", showAquaMaps + "", FieldType.BOOLEAN));
                    if (session.hasAttribute("submittedJobId")) {
                        filter.add(new Field(SubmittedFields.jobid + "", (String)session.getAttribute("submittedJobId"), FieldType.INTEGER));
                    }
                    if (session.hasAttribute("submittedStatus")) {
                        filter.add(new Field(SubmittedFields.status + "", (String)session.getAttribute("submittedStatus"), FieldType.STRING));
                    }
                    if (session.hasAttribute("submittedObjectType")) {
                        filter.add(new Field(SubmittedFields.type + "", (String)session.getAttribute("submittedObjectType"), FieldType.STRING));
                    }
                }
                toReturnJSON = dm.getJSONView(settings, submittedTableName, filter);
            }
            response.getWriter().write(toReturnJSON);
        }
        catch (Exception e) {
            logger.error("Exception on retrieving informations from server", (Throwable)e);
            response.setStatus(500);
        }
    }
}

