/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.application.aquamaps.aquamapsportlet.servlet;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.gcube.application.aquamaps.aquamapsportlet.client.constants.fields.SpeciesFields;
import org.gcube.application.aquamaps.aquamapsportlet.servlet.CustomServlet;
import org.gcube.application.aquamaps.aquamapsportlet.servlet.utils.Utils;
import org.gcube.application.aquamaps.aquamapsservice.client.plugins.AbstractPlugin;
import org.gcube.application.aquamaps.aquamapsservice.client.proxies.DataManagement;
import org.gcube.application.aquamaps.aquamapsservice.stubs.datamodel.enhanced.Job;
import org.gcube.application.aquamaps.aquamapsservice.stubs.fw.fields.SpeciesOccursumFields;
import org.gcube.application.aquamaps.aquamapsservice.stubs.fw.model.Field;
import org.gcube.application.aquamaps.aquamapsservice.stubs.fw.model.PagedRequestSettings;
import org.gcube.application.aquamaps.aquamapsservice.stubs.fw.types.FieldType;
import org.gcube.application.aquamaps.aquamapsservice.stubs.fw.types.OrderDirection;
import org.gcube.application.aquamaps.aquamapsservice.stubs.fw.types.ResourceType;
import org.gcube.application.framework.core.session.ASLSession;
import org.gcube.common.scope.api.ScopeProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OccurrenceCellsServlet
extends CustomServlet {
    private static final long serialVersionUID = -8721935904371361436L;
    private static final Logger logger = LoggerFactory.getLogger(OccurrenceCellsServlet.class);

    protected void handleRequest(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String speciesId = request.getParameter(SpeciesFields.speciesid + "");
        logger.trace("Occurrence cells : serving request for speciesId " + speciesId);
        response.setContentType("application/json; charset=utf-8");
        response.setStatus(200);
        if (speciesId == null) {
            response.getWriter().write("{\"totalcount\" : 0, \"data\":[]");
        } else {
            try {
                String occurrenceTable;
                String sortDir;
                String sortColumn;
                int limit;
                int startIndex;
                block11: {
                    startIndex = 0;
                    limit = 100;
                    sortColumn = request.getParameter("sort");
                    sortDir = request.getParameter("dir");
                    try {
                        startIndex = Integer.parseInt(request.getParameter("start"));
                        limit = Integer.parseInt(request.getParameter("limit"));
                    }
                    catch (NumberFormatException e) {
                        // empty catch block
                    }
                    ASLSession session = Utils.getSession((HttpSession)request.getSession());
                    ScopeProvider.instance.set(session.getScope().toString());
                    DataManagement dm = (DataManagement)AbstractPlugin.dataManagement().build();
                    occurrenceTable = null;
                    try {
                        Job obj = Utils.loadSettings((ASLSession)session, (boolean)false, (boolean)false);
                        occurrenceTable = (String)obj.getSourceHSPEN().getSourceOccurrenceCellsTables().get(0);
                        if (occurrenceTable == null) {
                            throw new Exception("Occurrence table not set in session.");
                        }
                    }
                    catch (Exception e) {
                        List defaults = dm.getDefaultSources();
                        logger.debug("Trying to use occurrence default...");
                        for (Field f : defaults) {
                            if (!f.name().equals(ResourceType.OCCURRENCECELLS)) continue;
                            occurrenceTable = dm.loadResource(f.getValueAsInteger().intValue()).getTableName();
                        }
                        if (occurrenceTable != null) break block11;
                        for (Field f : defaults) {
                            if (!f.name().equals(ResourceType.HSPEN)) continue;
                            occurrenceTable = (String)dm.loadResource(f.getValueAsInteger().intValue()).getSourceOccurrenceCellsTables().get(0);
                        }
                    }
                }
                ArrayList<Field> filter = new ArrayList<Field>();
                filter.add(new Field(SpeciesOccursumFields.speciesid + "", speciesId, FieldType.STRING));
                response.getWriter().write(((DataManagement)AbstractPlugin.dataManagement().build()).getJSONView(new PagedRequestSettings(limit, startIndex, sortColumn, OrderDirection.valueOf((String)sortDir)), occurrenceTable, filter));
            }
            catch (Exception e) {
                logger.trace("Exception on retrieving informations from server", (Throwable)e);
                response.setStatus(500);
            }
        }
    }
}

