/*
//sample calls and input data
doVisualiseJSON(dataJSON, visualisationFields, this.canvasID, this.width, this.height);


dataJSON =
{"type":"FeatureCollection","features":[{"type":"Feature","id":"count_occurences_skew.fid--967417f_13da238bba9_-7705","geometry":null,"properties":{"scientific_name":"Gobiidae","occurrences":64}},{"type":"Feature","id":"count_occurences_skew.fid--967417f_13da238bba9_-7704","geometry":null,"properties":{"scientific_name":"Notropis bifrenatus","occurrences":62}},{"type":"Feature","id":"count_occurences_skew.fid--967417f_13da238bba9_-7703","geometry":null,"properties":{"scientific_name":"Eviota","occurrences":62}},{"type":"Feature","id":"count_occurences_skew.fid--967417f_13da238bba9_-7702","geometry":null,"properties":{"scientific_name":"Astyanax","occurrences":53}},{"type":"Feature","id":"count_occurences_skew.fid--967417f_13da238bba9_-7701","geometry":null,"properties":{"scientific_name":"Trimma macrophthalma","occurrences":46}},{"type":"Feature","id":"count_occurences_skew.fid--967417f_13da238bba9_-7700","geometry":null,"properties":{"scientific_name":"Geophagus","occurrences":45}}]}


visualisationFields=
{"idFieldName":"scientific_name", "populationFieldName":"occurrences", "skewFieldName":"skew"}

canvasID=
bubbleplot
*/



var connectionLinks,
	visualisationFields,
	visData,
	dID,
	w,h;

//this is the entry point when the data is provided in GeoJSON format by the caller. 
function doBubbleVisualiseJSON(dataJSON, visualisationFieldsJSON, divID, width, height){
	dID = divID;
	w = width;
	h = height;
	visualisationFields = JSON.parse(visualisationFieldsJSON);
	initiateBubbleVisualisationJSON(dataJSON, divID);
}


function initiateBubbleVisualisationJSON(dataJSON,divID){
	$("#"+divID).children("svg").remove();
	vis = visual(divID,visualisationFields, w, h);
	doVisualisation(JSON.parse(dataJSON))
}


function doVisualisation(visualisationData){
	visData = visualisationData;
	//this is the actual visualisation
	vis.init(visualisationData);
}

function resizeVisualisation(width,height){
	w = width;
	h = height;
	//remove the previous visualisation
	$("#"+dID).children("svg").remove();
	//initiate the visualisation
	vis = visual(dID,visualisationFields, w, h);
	vis.init(visData);
}
