
function createInteractiveCatchLayer(geoserverWMSpath, geoserverWFSpath, workspaceCountries, layernameCountries, workspaceCatches, layernameCatches , slidebarID, countryColumnName, startYear, endYear){
	console.log("creating InteractiveCatchLayer");
	
//	OpenLayers.ProxyHost = "http://dionysus.di.uoa.gr:8080/geoserver/rest/proxy?url=";
//	OpenLayers.ProxyHost = "/geoserver/rest/proxy?url=";
	
//	var startDateTimestamp = Date.parse(startDateString);
//	var endDateTimestamp = Date.parse(endDateString);
	
	
//	var borders = new OpenLayers.Layer.WMS(
//			layernameCountries,
//			geoserverWMSpath,
//            {
//                layers: workspaceCountries+":"+layernameCountries,
//                format: 'image/png',
//                transparent: true
//            }, 
//            {
//            	isBaseLayer: false,
//                opacity: 0.5
////                singleTile: true
//            }
//    );
	
	var refresh = new OpenLayers.Strategy.Refresh({force: true, active: true});
	
	var renderer = OpenLayers.Util.getParameters(window.location.href).renderer;
    renderer = (renderer) ? [renderer] : OpenLayers.Layer.Vector.prototype.renderers;
	
	var countriesLayer = new OpenLayers.Layer.Vector("Countries", {
//        strategies: [ 
//                      new OpenLayers.Strategy.Fixed(),
//                     new OpenLayers.Strategy.BBOX(),
//                     refresh
//        ],
//        protocol: OpenLayers.Protocol.WFS.fromWMSLayer(borders),
		strategies: [new OpenLayers.Strategy.Fixed()],
		projection: new OpenLayers.Projection("EPSG:4326"),
        protocol: new OpenLayers.Protocol.WFS({
            url:  geoserverWFSpath,
            srsName: "EPSG:4326",
            featurePrefix: workspaceCountries,
            featureType: layernameCountries,
            geometryName: 'the_geom'
        }),
	    styleMap: new OpenLayers.StyleMap({
	      "default": new OpenLayers.Style({
//	          graphicName: "circle",
//	          pointRadius: 3,
	          fillOpacity: 0.70,
	          fillColor: "#ffcc66",
	          strokeColor: "#ff9933",
	          strokeWidth: 1
	      })

	    }),
        renderers: OpenLayers.Layer.Vector.prototype.renderers//renderer
    });
    
	
	countriesLayer.countryColumnName = countryColumnName;
	
	$(document.body).append("<div id='"+slidebarID+"container'></div>");
	$(document.body).append("<div id="+slidebarID+"></div>");
	
	
	var VisSelectID = slidebarID+"VisSel";
	var visSelHTML = "<select id='"+VisSelectID+"'><option value='nav'>Navigation</option><option value='vis'>Multiselect and Visualise</option></select>";
	if($("#"+VisSelectID).length==0){
		$(document.body).append(visSelHTML);
	}
	
	
	
	var slider = $("#"+slidebarID);
	
	countriesLayer.slider = slider; //add it on the layer too
	
	var container = $("#"+slidebarID+"container");
	
	container.css("position","absolute"); //if this creates trouble, comment it out
	
	$(function() {
		slider.slider({
			range : true,
			min : startYear,
			max : endYear,
			step: 1,
			values : [startYear, endYear],
			start: function(event,ui){
				($("#"+slidebarID)).slider().find(".ui-slider-handle").attr("title", "");
		    },
			slide : function(event, ui) {
		        ($("#"+slidebarID+" a:first")).tooltip({content:"Year: "+ui.values[0],track: true});
		        ($("#"+slidebarID+" a:last")).tooltip({content:"Year: "+ui.values[1],track: true});
			},
			stop: function(event,ui){
				($("#"+slidebarID)).slider().find(".ui-slider-handle").attr("title", "");
//				console.log("features: "+countriesFeatures.features.length);
				paintCountries(countriesLayer, computeFeaturesByCountry(countriesFeatures.features, slider));
		    }
		});
		
	    slider.slider().find(".ui-slider-handle").attr("title", "");

	    ($("#"+slidebarID+" a:first")).tooltip({
		    content: "Year: "+startYear,
			track: true
    	});
    
	    ($("#"+slidebarID+" a:last")).tooltip({
    		content:"Year: "+endYear,
    		track: true
    	});
	    
	});	
	
	
	$("#"+slidebarID).click(function(e) {e.stopPropagation();});
	$("#"+slidebarID).dblclick(function(e) {e.stopPropagation();});
	$("#"+slidebarID).mousedown(function(e) {e.stopPropagation();});
	
	$("#"+VisSelectID).click(function(e) {e.stopPropagation();});
	$("#"+VisSelectID).dblclick(function(e) {e.stopPropagation();});
	$("#"+VisSelectID).mousedown(function(e) {e.stopPropagation();});
	$("#"+VisSelectID).hide();
	
	
	$("#"+slidebarID+"container").append(document.getElementById(slidebarID));
	$("#"+slidebarID+"container").append(document.getElementById(VisSelectID));
	countriesLayer.div.appendChild(document.getElementById(slidebarID+"container"));
	
	
	
	countriesLayer.events.register("move",this,function(){
		var wPerc = 0.95; //width percentage
		var mapWidth = countriesLayer.map.getSize().w; //map width in pixels
		container.offset({"top":slider.height()+2,"left":(mapWidth*(1-wPerc))/1.5});
	});
	
	countriesLayer.events.register("moveend",this,function(){
		var wPerc = 0.95; //width percentage
		var mapWidth = countriesLayer.map.getSize().w; //map width in pixels
		container.offset({"top":slider.height()+2,"left":(mapWidth*(1-wPerc))/1.5});
	});
	
	
	countriesLayer.events.register("loadstart", this, function(){
		var wPerc = 0.92; //width percentage
		var mapWidth = countriesLayer.map.getSize().w; //map width in pixels
		container.offset({"top":slider.height()+2,"left":(mapWidth*(1-wPerc))/1.5});
		container.css('width', wPerc*mapWidth);
	});
	countriesLayer.events.register("loadend", this, function(){
		container.css("z-index",$("#layerSlidercontainer").parent().parent().css("z-index"));
		var wPerc = 0.92; //width percentage
		var mapWidth = countriesLayer.map.getSize().w; //map width in pixels
		container.offset({"top":slider.height()+2,"left":(mapWidth*(1-wPerc))/1.5});
		container.css('width', wPerc*mapWidth);
	});

	countriesLayer.countrySelect = new OpenLayers.Control.SelectFeature(countriesLayer, {
		clickout : true,
		toggle : true,
		multiple : false,
		hover : false,
		highlightOnly: false,
		box : false,
		autoActivate: true
	});
	
	countriesLayer.countryHover = new OpenLayers.Control.SelectFeature(countriesLayer, {
        hover: true,
        highlightOnly: true,  
        overFeature: function(feature) {
        	console.log("overFeature: "+feature.data.NAME);
        	//get all the feature information
        	var countryInfo = getFeatureInfo(feature.data.NAME);
        	//here we create the tooltip for the country
        	$(feature.layer.div).attr("title", "");
        	
        	$(feature.layer.div).tooltip({
        		content:"Country: "+countryInfo.name+
        				"<br>Total amount (for enumerable): "+countryInfo.totalNumber+
        				"<br>Total amount (tonnes): "+countryInfo.totalTonnes,
//        		show: { effect: "blind", duration: 150 },
//        		hide: {effect: "blind", duration: 150},
        		track: true
        	});
        	$(feature.layer.div).tooltip('open');
        },     
        outFeature: function(feature) {
        	console.log("outFeature: "+feature.data.NAME);
        	//here we destroy the tooltip
        	$(feature.layer.div).attr("title", "");
        	$(feature.layer.div).removeAttr('title');
//        	$(feature.layer.div).attr("title", "");
        	//$(feature.layer.div).tooltip('disable');
        	$(feature.layer.div).tooltip('close');
        },
        autoActivate: true
    });

	//gets for a country the already computed information by function 'computeFeaturesByCountry'
	function getFeatureInfo(countryName){
		for(var c=0;c<countriesLayer.tooltipCountryInfo.length;c++)
			if(countriesLayer.tooltipCountryInfo[c].name == countryName)
				return {
					name: countriesLayer.tooltipCountryInfo[c].name,
					totalNumber: countriesLayer.tooltipCountryInfo[c].totalNumber,
					totalTonnes: countriesLayer.tooltipCountryInfo[c].totalTonnes
				}
	}
	
	var countriesFeatures = new OpenLayers.Layer.Vector("countriesFeatures", {
		strategies: [new OpenLayers.Strategy.Fixed()],
        protocol: new OpenLayers.Protocol.WFS({
            url: geoserverWFSpath,
            featurePrefix: workspaceCatches,
            featureType: layernameCatches,
            geometryName: countriesLayer.protocol.geometryName,
            //two lines below -- June 2013
            readFormat: new OpenLayers.Format.GeoJSON(),
            outputFormat: "JSON"
        }),
        displayInLayerSwitcher: false
    });

	var countryFeatures = new OpenLayers.Layer.Vector("countryFeatures", {
		strategies: [new OpenLayers.Strategy.Fixed()],
        protocol: new OpenLayers.Protocol.WFS({
            url: geoserverWFSpath,
            featurePrefix: workspaceCatches,
            featureType: layernameCatches,
            geometryName: countriesLayer.protocol.geometryName            
        }),
	   	filter: new OpenLayers.Filter.Comparison({
		    type: OpenLayers.Filter.Comparison.EQUAL_TO,
		    property: countryColumnName,
		    value: ""  //here we should change it just before requesting any data with the country value
		}),
		displayInLayerSwitcher: false
    });

	
	//enable controls when the layer is inserted in the map (add it to the map)
	countriesLayer.events.register("added",this,function(object){
		object.layer.map.addControl(object.layer.countryHover);
		object.layer.map.addControl(object.layer.countrySelect);
		object.layer.map.addLayer(countryFeatures);
		object.layer.map.addLayer(countriesFeatures);
	});
	
	//also remove the controls when layer is deleted from map
	countriesLayer.events.register("removed",this,function(object){
		object.layer.map.removeControl(object.layer.countryHover);
		object.layer.map.removeControl(object.layer.countrySelect);
		object.layer.map.removeLayer(countryFeatures);
		object.layer.map.removeLayer(countriesFeatures);
	});
	
	//add some callbacks for the control 
	countriesLayer.countrySelect.onSelect = function(selected){
		console.log(selected.data.NAME);
		//set country filter and trigger the countryFeatures layer for the specific country
		countryFeatures.filter = new OpenLayers.Filter.Comparison({
		    type: OpenLayers.Filter.Comparison.EQUAL_TO,
		    property: countryColumnName,
		    value: selected.data.NAME
		});
		countryFeatures.filter.value = selected.data.NAME;
		countryFeatures.refresh();
	};
	
	
	countriesFeatures.events.register("featuresadded",this,function(features){
		console.log("new features on countriesFeatures");
//		console.log(features);
		//here compute for each country and paint the map
		paintCountries(countriesLayer, computeFeaturesByCountry(features.features, slider));
	});
	
	
	countryFeatures.events.register("featuresadded",this,function(features){
		console.log("new features on countryFeatures");
		//here do all the visualisation for the country selected
		country_bubbleplot(features, slider);
	});
	
	return countriesLayer;
}



function computeFeaturesByCountry(features, slider){
	var fromYear = slider.slider("values")[0];
	var toYear = slider.slider("values")[1];
	//first sort by country
	function SortByCountry(a, b){
		  var aCountry = a.data.country;//.toLowerCase();
		  var bCountry = b.data.country;//.toLowerCase(); 
		  return ((aCountry < bCountry) ? -1 : ((aCountry > bCountry) ? 1 : 0));
		}
	features.sort(SortByCountry);
	//now compute the features for the countries
	var countries = Array();
	var species = Array();
	var countryName = features[0].data.country;
	var sum = 0.0;
	for(var year=fromYear;year<=toYear;year++)
		sum += parseFloat(features[0].data['year'+year]);
	species.push([
		features[0].data.asfis_species,
		features[0].data.measure,
		sum
	]);
	for(var i=1;i<features.length;i++){
		if(features[i].data.country == countryName){
			sum = 0;
			for(var year=fromYear;year<=toYear;year++)
				sum += parseFloat(features[i].data['year'+year]);
			species.push([
				features[i].data.asfis_species,
				features[i].data.measure,
				sum
			]);
		}
		if(features[i].data.country != countryName){
			//save the computed values to the countries array
			countries.push({
				'name':countryName,
				'values':species
			});
			//and reset them to current 
			species = [];
			countryName = features[i].data.country;
			sum = 0;
			for(var year=fromYear;year<=toYear;year++)
				sum += parseFloat(features[i].data['year'+year]);
			species.push([
				features[i].data.asfis_species,
				features[i].data.measure,
				sum
			]);
		}
	}

	//last object (special case)
	countries.push({
		'name':countryName,
		'values':species
	});

	//go through the dataset and compute total tonnes and total number of fishes
	for(var c=0;c<countries.length;c++){ //each one of these is about a country
		var totalTonnes = 0, totalNumber = 0;
		for(var i=0;i<countries[c].values.length;i++){  //each one of these is about a species
			countries[c].values[i][1]=="Quantity (tonnes)" ? 
					totalTonnes += countries[c].values[i][2] : totalNumber += countries[c].values[i][2];
		}
		countries[c].totalTonnes = totalTonnes;
		countries[c].totalNumber = totalNumber;
	}
	
	return countries;
}


function paintCountries(countriesLayer, countryFeaturesComputed){
	
//	var min=countryFeaturesComputed[0].totalTonnes;
	var min=0;
	var max=countryFeaturesComputed[0].totalTonnes;
	for(var i=1;i<countryFeaturesComputed.length;i++){
		if(countryFeaturesComputed[i].totalTonnes > max) max = countryFeaturesComputed[i].totalTonnes;
//		if(countryFeaturesComputed[i].totalTonnes < min) min = countryFeaturesComputed[i].totalTonnes;
	}
	
	//could improve the search by using a binary search instead of the naive 246x246 checking
	//since country names are sorted
	for(var i=0;i<countryFeaturesComputed.length;i++){
		for(var j=0;j<countriesLayer.features.length;j++){
			if(countriesLayer.features[j].data.NAME == countryFeaturesComputed[i].name){
				//hue should be from 0.416 to 0
//				var hue = (0.416 - ((countryFeaturesComputed[i].totalTonnes / max) * 0.416));
//				var color = $.colors( [hue,0.98,0.99], 'array3Normalized', 'HSL' ).toString('hex');
				//next two lines scale it by hue
//				var hue = Math.floor(251 - ((countryFeaturesComputed[i].totalTonnes / max) * 250));
//				var color = $.Color({ hue: hue, saturation: 0.5 , lightness: 0.5, alpha: 0.5 }).toHexString();
				//next two lines scale it by lightness and alpha
				var lightness = 0.75 - ((countryFeaturesComputed[i].totalTonnes / max) * 0.5);  //50 levels
				
				var color = $.Color({ hue: 240, saturation: 1 , lightness: lightness, alpha: 1 }).toHexString();

				countriesLayer.drawFeature(countriesLayer.features[j],new OpenLayers.Style());
				
				countriesLayer.features[j].style = {
					fillOpacity: 0.70,
					fillColor: color,
					strokeColor: color,
					strokeWidth: 1
				};
			}
		}
	}
	countriesLayer.redraw();
	
	//keep the computed information for the hover tooltips
	countriesLayer.tooltipCountryInfo = countryFeaturesComputed;
	
}


function country_bubbleplot(e, slider){
	
	var popupSize = new OpenLayers.Size(e.object.map.getSize().w-30,e.object.map.getSize().h-30);
	
	var popup = new OpenLayers.Popup( "VisualisationPopup",
		e.object.map.getLonLatFromPixel({x:15,y:15}),
		popupSize,
	    "",
	    false
	);
	e.object.map.addPopup(popup);
	popup.panIntoView();
	popup.padding = 20;
	
	popup.addCloseBox(function(){
		popup.destroy();
	});
	
	//this fixes the overflow problem
	$(popup.contentDiv).css({ 'overflow': 'hidden'});
	//this fixes the close button visibility
	$(popup.closeDiv).css({ 'z-index': $(popup.groupDiv).parent().css("z-index")});
	
	var visFieldsArray = {"idFieldName":"asfis_species", "populationFieldName":"occurrences", "skewFieldName":"skew"};
	
	doBubbleVisualiseJSON(constructCountryBubbleVisJSON(e, slider), JSON.stringify(visFieldsArray), popup.contentDiv.id, popupSize.w, popupSize.h);
	
}

function constructCountryBubbleVisJSON(e, slider){
	
	var fromYear = slider.slider("values")[0];
	var toYear = slider.slider("values")[1];
	
	//now make the computations :)
	var data = Array();
	var dates = Array();
	var asfis_species, occurrences, skew; //here occurrences are catches
	
	for(var sp=0;sp<e.features.length;sp++){
		asfis_species = e.features[sp].data.asfis_species;
		occurrences = 0;
		for(var year=fromYear;year<=toYear;year++)
			occurrences += parseFloat(e.features[sp].data["year"+String(year)]);
		var midYear = parseFloat(fromYear+((toYear-fromYear)/2));
		//computing a simplified skewness-style parameter
		skew = 0;
		for(var year=fromYear;year<=toYear;year++)
			skew += parseFloat(midYear-year) * parseFloat(e.features[sp].data["year"+String(year)]/occurrences);
		
		data.push({
			'asfis_species':asfis_species,
			'occurrences':occurrences,
			'skew':skew
		});
	}
	
	
	//construct array
	var visArray = {
			"type": "FeatureCollection",
			"features": new Array()
	}
	for(var i=0;i<data.length;i++){
		if(data[i].occurrences<1)
			continue;
		visArray.features.push({
	      "properties": {
	        "asfis_species": data[i].asfis_species,
	        "occurrences": data[i].occurrences,
	        "skew": data[i].skew
	      }
	    });
	}
	
	return JSON.stringify(visArray);
	
}




