/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.accounting.messaging;

import java.util.HashMap;
import javax.jms.JMSException;
import javax.jms.QueueConnection;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.gcube.common.messaging.endpoints.BrokerEndpoints;
import org.gcube.common.messaging.endpoints.BrokerNotConfiguredInScopeException;
import org.gcube.common.messaging.endpoints.ScheduledRetriever;
import org.gcube.common.scope.api.ScopeProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConnectionsManager {
    private static long refreshTime = 1800L;
    private static long waitingTime = 60L;
    private static Logger logger = LoggerFactory.getLogger(ConnectionsManager.class);
    private static HashMap<String, ActiveMQConnectionFactory> connectionFactoryMap = null;
    private static HashMap<String, QueueConnection> queueConnectionMap = null;

    public void init(long waitingTime, long refreshTime) {
        ConnectionsManager.refreshTime = refreshTime;
        ConnectionsManager.waitingTime = waitingTime;
    }

    public static QueueConnection getQueueConnection(String scope) {
        QueueConnection connection = queueConnectionMap.get(scope);
        if (connection == null) {
            logger.debug("CONNECTION MAP NULL");
        }
        return connection;
    }

    public static synchronized void addScope(String scope) throws BrokerNotConfiguredInScopeException, Exception {
        ScopeProvider.instance.set(scope);
        logger.debug("scope added");
        logger.debug("getRetriever");
        BrokerEndpoints.getRetriever((long)waitingTime, (long)refreshTime);
        logger.debug("broker retrieved");
        ConnectionsManager.reloadConnection(scope);
    }

    public static ScheduledRetriever getBrokerRetriever(String scope) throws BrokerNotConfiguredInScopeException, Exception {
        ScopeProvider.instance.set(scope);
        return BrokerEndpoints.getRetriever((long)waitingTime, (long)refreshTime);
    }

    public static synchronized void reloadConnection(String scope) {
        ConnectionsManager.stopConnections(scope);
        ActiveMQConnectionFactory factory = null;
        QueueConnection queueConnection = null;
        logger.debug("Reload JMS connections");
        try {
            factory = new ActiveMQConnectionFactory((String)ConnectionsManager.getBrokerRetriever(scope).getEndpoints().get(0));
            queueConnection = factory.createQueueConnection();
            queueConnection.start();
        }
        catch (JMSException e1) {
            logger.debug("Error creating Topic Connection - jms");
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.debug("Error creating Topic Connection - general");
        }
        queueConnectionMap.put(scope, queueConnection);
        connectionFactoryMap.put(scope, factory);
    }

    private static void stopConnections(String scope) {
        if (queueConnectionMap != null && queueConnectionMap.get(scope) != null) {
            QueueConnection con = queueConnectionMap.get(scope);
            try {
                con.stop();
                con.close();
            }
            catch (JMSException e) {
                logger.debug("Error stopping queueConnections");
            }
        }
    }

    static {
        connectionFactoryMap = new HashMap();
        queueConnectionMap = new HashMap();
    }
}

