package org.gcube.accounting.messaging;

import org.apache.log4j.Logger;
import org.gcube.accounting.datamodel.RawUsageRecord;


public class ResourceAccounting {
	private static Logger logger = Logger.getLogger(ResourceAccounting.class);


	private MSGClient client = null;
	
	public ResourceAccounting() {
		try {
			client = MSGClientFactory.getMSGClientInstance();
		} catch (Exception e) {
			e.printStackTrace();
		}
	}
	
	public void sendAccountingMessage(RawUsageRecord message){
		logger.debug("ResourceAccounting.sendAccountingMessage");
		client.sendMessage(message);
	}
	
	public RawUsageRecord receiveAccountingMessage(QueueCouple queueCouple){
		return client.receiveMessage(queueCouple);

	}
	
	



}
