package org.gcube.accounting.messaging.consumer;
import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.ObjectMessage;
import javax.jms.Session;

import org.apache.activemq.ActiveMQConnectionFactory;
import org.gcube.accounting.datamodel.RawUsageRecord;
import org.gcube.accounting.messaging.QueueCouple;


/**
 * JMS Client that receives message from ActiveMQ Broker
 * 
 * @author Andrea Manzi (CERN)
 * @author Ermanno Travaglino (E-IIS)
 *
 */

public class Consumer{

	private static Consumer singleton;

	//private static String url = "tcp://192.168.125.190:61616";//"tcp://message-broker.d.d4science.research-infrastructures.eu:6166?trace=true";
	protected static boolean transacted = false;
	protected static int ackMode = Session.AUTO_ACKNOWLEDGE;
	// Name of the queue we will receive messages from
	private static String subject = "resource-accounting";
	//private String url;

	static {

		singleton = new Consumer();
		
	}



	/**
	 * no object instantiation possible
	 */
	private Consumer() {}

	public static Consumer getSingleton() {
		return singleton;
	}



	/**
	 * Receives message from a QUEUE
	 * 	@param message the RawUsageRecord to send
	 */
	public RawUsageRecord receiveMessageFromQueue(QueueCouple queueCouple) {
		RawUsageRecord p = null;
		System.out.println("receiveMessageFromQueue");
		ActiveMQConnectionFactory connectionFactory = new ActiveMQConnectionFactory(queueCouple.getBroker());
		try{
			//Create Connection
			Connection connection = connectionFactory.createConnection();
			System.out.println("new Connection");
			//Start/restart a connection
			connection.start();

			//Create Session
			Session session = connection.createSession(false, Session.AUTO_ACKNOWLEDGE);
			//Create Queue
			Destination queue = session.createQueue(queueCouple.getScope()+"."+subject);
			//Create Consumer
			MessageConsumer consumer = session.createConsumer(queue);

			System.out.println("Consumer waiting...");

			//Consume Message. Call block until message is received or until close is called
			Message message = consumer.receive();
			System.out.println("new Message");

			if(message instanceof ObjectMessage){
				ObjectMessage obj = (ObjectMessage)message;
				p = (RawUsageRecord)obj.getObject();
				System.out.println("Received"+p.getId());   
			}else{
				System.out.println("Received message of unknown type");
			}
			consumer.close();
			session.close();
			connection.close();

		}catch(JMSException e){          
			System.out.println("Problem creating connection to ActiveMQ"); 
			e.printStackTrace();
		}catch(Exception e){
			e.printStackTrace();
		}
		return p;
	}



}