/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.accounting.usagetracker.persistence;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.gcube.accounting.usagetracker.persistence.AggregatedResult;
import org.gcube.accounting.usagetracker.persistence.DimensionValueMap;
import org.gcube.accounting.usagetracker.persistence.Helper;
import org.gcube.accounting.usagetracker.persistence.Record;
import org.gcube.accounting.usagetracker.persistence.UsageTrackerDB;

public class ResultSet {
    public static final Double MILLS_IN_DAY = 8.64E7;
    private String dimensionKey;
    private Map<String, DimensionValueMap> dimensionValue2records;

    public ResultSet(String dimensionKey) {
        this.dimensionKey = dimensionKey;
        this.dimensionValue2records = new HashMap();
    }

    private DimensionValueMap getValueMap(String dimensionValue) {
        if (!this.dimensionValue2records.containsKey(dimensionValue)) {
            this.dimensionValue2records.put(dimensionValue, new DimensionValueMap(dimensionValue));
        }
        return (DimensionValueMap)this.dimensionValue2records.get(dimensionValue);
    }

    public void add(Record r) throws Exception {
        String dimensionValue = Helper.getDimensionValue((Record)r, (String)this.dimensionKey);
        this.getValueMap(dimensionValue).add(r);
    }

    public Double getSumAt(String dimensionValue, Long timestamp) {
        return this.getValueMap(dimensionValue).getSumAt(timestamp);
    }

    public AggregatedResult getAggregatedResult(String dimensionValue, Long timestamp) {
        return new AggregatedResult(timestamp, dimensionValue, this.getValueMap(dimensionValue).getSumAt(timestamp));
    }

    public Double getAverageInRange(String dimensionValue, Long from, Long to) {
        Double out = 0.0;
        List intervals = UsageTrackerDB.getIntervals((Long)from, (Long)to, (String)"day");
        Long previous = (Long)intervals.get(0);
        for (int i = 1; i < intervals.size(); ++i) {
            Long dayEnd = (Long)intervals.get(i);
            Double value = this.getValueMap(dimensionValue).getSumAt(dayEnd);
            value = value * (double)(dayEnd - previous) / MILLS_IN_DAY;
            out = out + value;
            previous = dayEnd;
        }
        return out / (double)(intervals.size() - 1);
    }

    public Double getVarInRange(String dimensionValue, Long from, Long to) {
        Double out = 0.0;
        Double avg = this.getAverageInRange(dimensionValue, from, to);
        Long current = from + 1L;
        while (current <= to) {
            Double value = this.getValueMap(dimensionValue).getSumAt(current);
            out = out + Math.pow(value - avg, 2.0);
            Long l = current;
            Long l2 = current = Long.valueOf(current + 1L);
        }
        return out / (double)(to - from);
    }

    public Double getMinInRange(String dimensionValue, Long from, Long to) {
        Double out = Double.MAX_VALUE;
        Long current = from + 1L;
        while (current <= to) {
            Double value = this.getValueMap(dimensionValue).getSumAt(current);
            out = Math.min(out, value);
            Long l = current;
            Long l2 = current = Long.valueOf(current + 1L);
        }
        return out;
    }

    public Double getMaxInRange(String dimensionValue, Long from, Long to) {
        Double out = 0.0;
        Long current = from + 1L;
        while (current <= to) {
            Double value = this.getValueMap(dimensionValue).getSumAt(current);
            out = Math.max(out, value);
            Long l = current;
            Long l2 = current = Long.valueOf(current + 1L);
        }
        return out;
    }

    public Set<String> getDimensionValues() {
        return this.dimensionValue2records.keySet();
    }

    public static void main(String[] args) throws Exception {
        String[] people = new String[]{"nunzio", "ciro", "gabriele", "philip", "davide", "cosimo", "giacinta", "maria", "rita", "mario", "tiziana", "ettore", "achille", "giuseppe", "loretta", "piero", "matteo", "giacomo", "giovanni", "giocondo", "antonio", "antonietta", "luca", "mara", "martina", "anna", "andrea", "lino", "pasquale", "lucio", "massi", "gianpaolo", "jurgen", "jessica", "rosella"};
        String[] scopes = new String[]{"gcube", "devsec", "testing", "fishery", "eo"};
        String[] types = new String[]{"blob", "object", "database", "tree", "bigtable"};
        Long mindate = 0L;
        Long maxdate = 100L;
        Long maxValue = 10000L;
        ResultSet rm = new ResultSet("resourceOwner");
        for (int i = 0; i < 10000; ++i) {
            String consumerId = people[(int)(Math.random() * (double)people.length)];
            String resourceOwner = people[(int)(Math.random() * (double)people.length)];
            String type = types[(int)(Math.random() * (double)types.length)];
            String scope = scopes[(int)(Math.random() * (double)scopes.length)];
            Long timestamp = mindate + (long)(Math.random() * (double)(maxdate - mindate));
            Double value = Math.random() * (double)maxValue.longValue();
            System.out.println(consumerId + " " + resourceOwner + " " + type + " " + scope + " " + timestamp + " " + value);
            rm.add(new Record(resourceOwner, resourceOwner, type, scope, timestamp, value));
        }
        for (String dimension : rm.getDimensionValues()) {
            System.out.println("***** " + dimension + " *****");
            AggregatedResult prev = null;
            for (long i = mindate.longValue(); i < maxdate; ++i) {
                long mod;
                AggregatedResult r = rm.getAggregatedResult(dimension, Long.valueOf(0L + i));
                if (prev == null || !prev.getValue().equals(r.getValue())) {
                    System.out.println(i + ". " + r.getValue());
                }
                if (i % (mod = 10L) == 0L) {
                    long previousTimestamp = Math.max(i - mod, -1L);
                    System.out.println("Min/Avg/Max/Var: (" + previousTimestamp + "-" + i + ") " + rm.getMinInRange(dimension, Long.valueOf(previousTimestamp), Long.valueOf(i)) + " / " + rm.getAverageInRange(dimension, Long.valueOf(previousTimestamp), Long.valueOf(i)) + " / " + rm.getMaxInRange(dimension, Long.valueOf(previousTimestamp), Long.valueOf(i)) + " / " + rm.getVarInRange(dimension, Long.valueOf(previousTimestamp), Long.valueOf(i)));
                }
                prev = r;
            }
        }
    }
}

