/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.accounting.usagetracker.persistence;

import com.mongodb.BasicDBObject;
import com.mongodb.DBObject;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.gcube.accounting.datamodel.reports.Report;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;

public class MongoAggregationHelper {
    private static Logger logger = Logger.getLogger(MongoAggregationHelper.class);

    public static DBObject generateMatchClause(Report report) {
        BasicDBObject matchClause = new BasicDBObject();
        matchClause.append("startTime", (Object)new BasicDBObject("$gte", (Object)report.getStartPeriod()).append("$lte", (Object)report.getEndPeriod()));
        matchClause.append("resourceType", (Object)report.getResourceType());
        if (report.getFilters() != null) {
            Map filters = report.getFilters();
            for (Map.Entry entry : filters.entrySet()) {
                if (entry == null) continue;
                String filterName = (String)entry.getKey();
                List filterValues = (List)entry.getValue();
                matchClause.append(filterName, (Object)new BasicDBObject("$in", (Object)filterValues));
            }
        }
        BasicDBObject match = new BasicDBObject("$match", (Object)matchClause);
        logger.debug((Object)("match clause = " + matchClause));
        return match;
    }

    public static DBObject generateSortClause(Report report) {
        BasicDBObject sortFields = new BasicDBObject();
        if (report.getAggregationGranule().toString().equals("week")) {
            sortFields.append("_id.year", (Object)1);
            sortFields.append("_id.week", (Object)1);
        } else if (report.getAggregationGranule().toString().equals("year")) {
            sortFields.append("_id.year", (Object)1);
        } else if (report.getAggregationGranule().toString().equals("month")) {
            sortFields.append("_id.year", (Object)1);
            sortFields.append("_id.month", (Object)1);
        } else if (report.getAggregationGranule().toString().equals("day")) {
            sortFields.append("_id.year", (Object)1);
            sortFields.append("_id.month", (Object)1);
            sortFields.append("_id.day", (Object)1);
        }
        BasicDBObject sort = new BasicDBObject("$sort", (Object)sortFields);
        logger.debug((Object)("sort clause = " + sort));
        return sort;
    }

    public static DBObject generateGroupClause(Report report, boolean aggregationEnabled) {
        BasicDBObject x = new BasicDBObject();
        x.put("resourceType", (Object)"$resourceType");
        if (aggregationEnabled) {
            if (report.getAggregationGranule().toString().equals("week")) {
                x.put("year", (Object)new BasicDBObject("$year", (Object)"$startTime"));
                x.put("week", (Object)new BasicDBObject("$week", (Object)"$startTime"));
            } else if (report.getAggregationGranule().toString().equals("year")) {
                x.put("year", (Object)new BasicDBObject("$year", (Object)"$startTime"));
            } else if (report.getAggregationGranule().toString().equals("month")) {
                x.put("year", (Object)new BasicDBObject("$year", (Object)"$startTime"));
                x.put("month", (Object)new BasicDBObject("$month", (Object)"$startTime"));
            } else if (report.getAggregationGranule().toString().equals("day")) {
                x.put("year", (Object)new BasicDBObject("$year", (Object)"$startTime"));
                x.put("month", (Object)new BasicDBObject("$month", (Object)"$startTime"));
                x.put("day", (Object)new BasicDBObject("$dayOfMonth", (Object)"$startTime"));
            }
        }
        x.put(report.getDimension(), (Object)("$" + report.getDimension()));
        BasicDBObject groupClause = new BasicDBObject("_id", (Object)x);
        logger.debug((Object)("group clause = " + groupClause));
        return groupClause;
    }

    public static DateTime generateAggregationTime(DBObject idField, String granule) {
        DateTime time = new DateTime(DateTimeZone.UTC).withTimeAtStartOfDay();
        if (granule.equals("week")) {
            int year = (Integer)idField.get("year");
            time = time.withYear(year);
            int week = (Integer)idField.get("week");
            GregorianCalendar c = new GregorianCalendar();
            c.set(3, week);
            c.set(1, year);
            time = new DateTime((Object)c).withTimeAtStartOfDay();
        } else if (granule.equals("year")) {
            int year = (Integer)idField.get("year");
            time = time.withYear(year);
        } else if (granule.equals("month")) {
            int year = (Integer)idField.get("year");
            time = time.withYear(year);
            int month = (Integer)idField.get("month");
            time = time.withMonthOfYear(month);
        } else if (granule.equals("day")) {
            int day = (Integer)idField.get("day");
            int month = (Integer)idField.get("month");
            int year = (Integer)idField.get("year");
            time = time.withYear(year);
            time = time.withMonthOfYear(month);
            time = time.withDayOfMonth(day);
        }
        logger.debug((Object)("time = " + time));
        return time;
    }
}

