package org.gcube.accounting.service.health;

import org.gcube.accounting.persistence.AccountingPersistence;
import org.gcube.accounting.persistence.AccountingPersistenceFactory;
import org.gcube.common.health.api.HealthCheck;
import org.gcube.common.health.api.ReadinessChecker;
import org.gcube.common.health.api.response.HealthCheckResponse;


@ReadinessChecker
public class InsertHealthCheck implements HealthCheck {
	
	public static final String INSERT_CONNECTION_LABEL = "Insert Connection";
	
	private static final HealthCheckResponse UP;
	private static final HealthCheckResponse DOWN;

	static {
		UP = HealthCheckResponse.builder(INSERT_CONNECTION_LABEL).up().build();
		DOWN = HealthCheckResponse.builder(INSERT_CONNECTION_LABEL).down().error("Connection is not active").build();
	}

	@Override
	public String getName() {
		return INSERT_CONNECTION_LABEL;
	}

	@Override
	public HealthCheckResponse check() {
		
		AccountingPersistence accountingPersistence = AccountingPersistenceFactory.getPersistence();
		try {
			if(accountingPersistence.isConnectionActive()){
				return UP;
			} else{
				return DOWN;
			} 
		} catch(Exception e) {
			return HealthCheckResponse.builder(getName()).down().error(e.getMessage()).build();
		}
	}
	
}
