/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.accounting.service.resources;

import com.sun.research.ws.wadl.HTTPMethods;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.gcube.accounting.analytics.persistence.AccountingPersistenceQuery;
import org.gcube.accounting.analytics.persistence.AccountingPersistenceQueryFactory;
import org.gcube.accounting.persistence.AccountingPersistence;
import org.gcube.accounting.persistence.AccountingPersistenceFactory;
import org.gcube.accounting.service.AccountingServiceInitializer;
import org.gcube.common.authorization.library.provider.CalledMethodProvider;
import org.gcube.smartgears.annotations.ManagedBy;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ManagedBy(value=AccountingServiceInitializer.class)
@Path(value="state")
public class ServiceState {
    private static final Logger logger = LoggerFactory.getLogger(ServiceState.class);
    public static final String STATE_PATH_PART = "state";
    public static final String SERVICE = "service";
    public static final String RUNNING = "running";
    public static final String CONTEXT = "context";
    public static final String QUERY_CONNECTION_UP = "queryConnection";
    public static final String INSERT_CONNECTION_UP = "insertConnection";

    @GET
    @Produces(value={"application/json;charset=UTF-8"})
    public Response getState() throws JSONException {
        CalledMethodProvider.instance.set(HTTPMethods.GET.name() + " /" + STATE_PATH_PART);
        String context = AccountingServiceInitializer.getCurrentContext();
        logger.debug("Getting Service Status for context {}", (Object)context);
        JSONObject jsonObject = new JSONObject();
        jsonObject.append(SERVICE, (Object)RUNNING);
        jsonObject.append(CONTEXT, (Object)context);
        Response.Status responseStatus = Response.Status.SERVICE_UNAVAILABLE;
        AccountingPersistence accountingPersistence = AccountingPersistenceFactory.getPersistence();
        try {
            jsonObject.append(INSERT_CONNECTION_UP, (Object)accountingPersistence.isConnectionActive());
        }
        catch (Exception e) {
            jsonObject.append(INSERT_CONNECTION_UP, (Object)false);
        }
        AccountingPersistenceQuery accountingPersistenceQuery = AccountingPersistenceQueryFactory.getInstance();
        try {
            jsonObject.append(QUERY_CONNECTION_UP, (Object)accountingPersistenceQuery.isConnectionActive());
        }
        catch (Exception e) {
            jsonObject.append(QUERY_CONNECTION_UP, (Object)false);
        }
        return Response.status((Response.Status)responseStatus).entity((Object)jsonObject.toString()).build();
    }
}

