/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.accounting.utility.postgresql;

import java.util.HashMap;
import java.util.Map;
import org.gcube.accounting.utility.postgresql.RecordToDBConnection;
import org.gcube.accounting.utility.postgresql.RecordToDBFields;
import org.gcube.documentstore.persistence.PersistenceBackendConfiguration;
import org.gcube.documentstore.records.AggregatedRecord;
import org.gcube.documentstore.records.Record;
import org.gcube.documentstore.records.RecordUtility;

public class RecordToDBMapping {
    protected static final Map<String, RecordToDBFields> classToRecordToDBMapper = new HashMap<String, RecordToDBFields>();
    protected final Map<String, RecordToDBConnection> recordToDBInfo = new HashMap<String, RecordToDBConnection>();

    public static String getRecordTypeByClass(Class<? extends Record> clz) {
        try {
            Record r = clz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            return r.getRecordType();
        }
        catch (Exception e) {
            String type = clz.getSimpleName();
            type = type.replace("Abstract", "");
            type = type.replace("Aggregated", "");
            return type;
        }
    }

    public void addRecordToDB(Class<? extends AggregatedRecord<?, ?>> clz, PersistenceBackendConfiguration configuration) throws Exception {
        String type = RecordToDBMapping.getRecordTypeByClass(clz);
        RecordToDBMapping.getRecordToDBFields(clz);
        RecordToDBConnection recordDBInfo = new RecordToDBConnection(type, clz, configuration);
        this.recordToDBInfo.put(type, recordDBInfo);
    }

    public static synchronized RecordToDBFields getRecordToDBFields(Class<? extends Record> clz) throws Exception {
        String type = RecordToDBMapping.getRecordTypeByClass(clz);
        RecordToDBFields recordToDBFields = classToRecordToDBMapper.get(type);
        if (recordToDBFields == null) {
            Class aggregatedRecordClass = AggregatedRecord.class.isAssignableFrom(clz) ? clz : RecordUtility.getAggregatedRecordClass((String)type);
            recordToDBFields = new RecordToDBFields(type, aggregatedRecordClass);
            classToRecordToDBMapper.put(type, recordToDBFields);
        }
        return recordToDBFields;
    }

    public synchronized RecordToDBConnection getRecordDBInfo(Class<? extends Record> clz) throws Exception {
        String type = RecordToDBMapping.getRecordTypeByClass(clz);
        return this.recordToDBInfo.get(type);
    }
}

