/**
 * 
 */
package org.gcube.accounting.datamodel;

import org.gcube.documentstore.records.AggregatedRecord;
import org.gcube.documentstore.records.implementation.AggregatedField;
import org.gcube.documentstore.records.implementation.validations.annotations.NotEmptyIfNotNull;
import org.gcube.documentstore.records.implementation.validations.annotations.ValidInteger;
import org.gcube.documentstore.records.implementation.validations.annotations.ValidLong;

/**
 * @author Luca Frosini (ISTI - CNR) http://www.lucafrosini.com/
 */
public interface AggregatedUsageRecord<A extends AggregatedUsageRecord<A,U>, U extends UsageRecord> extends AggregatedRecord<A,U> {
	
	@AggregatedField @NotEmptyIfNotNull
	public static final String AGGREGATED = AggregatedRecord.AGGREGATED;
	
	@AggregatedField @ValidInteger
	public static final String OPERATION_COUNT = AggregatedRecord.OPERATION_COUNT;
	
	@AggregatedField @ValidLong
	public static final String START_TIME = AggregatedRecord.START_TIME;
	
	@AggregatedField @ValidLong
	public static final String END_TIME = AggregatedRecord.END_TIME;
	
}
