/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.accounting.datamodel.basetypes;

import java.io.Serializable;
import java.util.Calendar;
import java.util.Map;
import org.gcube.accounting.datamodel.BasicUsageRecord;
import org.gcube.accounting.datamodel.backwardcompatibility.MoveToOperationResult;
import org.gcube.accounting.datamodel.backwardcompatibility.MoveToTaskEndTime;
import org.gcube.accounting.datamodel.backwardcompatibility.MoveToTaskStartTime;
import org.gcube.accounting.datamodel.deprecationmanagement.DeprecatedWarning;
import org.gcube.documentstore.exception.InvalidValueException;
import org.gcube.documentstore.records.implementation.RequiredField;
import org.gcube.documentstore.records.implementation.validations.annotations.NotEmpty;
import org.gcube.documentstore.records.implementation.validations.annotations.ValidInteger;
import org.gcube.documentstore.records.implementation.validations.annotations.ValidLong;

public abstract class AbstractTaskUsageRecord
extends BasicUsageRecord {
    private static final long serialVersionUID = -2208425042550641240L;
    @RequiredField
    @NotEmpty
    public static final String JOB_ID = "jobId";
    @RequiredField
    @NotEmpty
    public static final String REF_HOST = "refHost";
    @RequiredField
    @NotEmpty
    public static final String REF_VM = "refVM";
    @Deprecated
    @NotEmpty
    @DeprecatedWarning
    protected static final String DOMAIN = "domain";
    @Deprecated
    @DeprecatedWarning
    @MoveToTaskStartTime
    protected static final String USAGE_START_TIME = "usageStartTime";
    @Deprecated
    @DeprecatedWarning
    @MoveToTaskEndTime
    protected static final String USAGE_END_TIME = "usageEndTime";
    @Deprecated
    @MoveToOperationResult
    @DeprecatedWarning
    protected static final String USAGE_PHASE = "usagePhase";
    @RequiredField
    @ValidLong
    public static final String TASK_START_TIME = "taskStartTime";
    @RequiredField
    @ValidLong
    public static final String TASK_END_TIME = "taskEndTime";
    @Deprecated
    @ValidInteger
    @DeprecatedWarning
    protected static final String INPUT_FILES_NUMBER = "inputFilesNumber";
    @Deprecated
    @ValidLong
    @DeprecatedWarning
    protected static final String INPUT_FILES_SIZE = "inputFilesSize";
    @Deprecated
    @ValidInteger
    @DeprecatedWarning
    protected static final String OUTPUT_FILES_NUMBER = "outputFilesNumber";
    @Deprecated
    @ValidLong
    @DeprecatedWarning
    protected static final String OUTPUT_FILES_SIZE = "outputFilesSize";
    @Deprecated
    @ValidLong
    @DeprecatedWarning
    protected static final String OVERALL_NETWORK_IN = "overallNetworkIn";
    @Deprecated
    @ValidLong
    @DeprecatedWarning
    protected static final String OVERALL_NETWORK_OUT = "overallNetworkOut";
    @Deprecated
    @ValidInteger
    @DeprecatedWarning
    protected static final String CORES = "cores";
    @Deprecated
    @ValidInteger
    @DeprecatedWarning
    protected static final String PROCESSORS = "processors";
    private static final String ABSTRACT_TO_REPLACE = "Abstract";

    public AbstractTaskUsageRecord() {
    }

    public AbstractTaskUsageRecord(Map<String, Comparable<? extends Serializable>> properties) throws InvalidValueException {
        super(properties);
    }

    protected String giveMeRecordType() {
        return AbstractTaskUsageRecord.class.getSimpleName().replace(ABSTRACT_TO_REPLACE, "");
    }

    public String getJobId() {
        return (String)this.resourceProperties.get(JOB_ID);
    }

    public void setJobId(String jobId) throws InvalidValueException {
        this.setResourceProperty(JOB_ID, (Comparable)((Object)jobId));
    }

    public String getRefHost() {
        return (String)this.resourceProperties.get(REF_HOST);
    }

    public void setRefHost(String refHost) throws InvalidValueException {
        this.setResourceProperty(REF_HOST, (Comparable)((Object)refHost));
    }

    public String getRefVM() {
        return (String)this.resourceProperties.get(REF_VM);
    }

    public void setRefVM(String refVM) throws InvalidValueException {
        this.setResourceProperty(REF_VM, (Comparable)((Object)refVM));
    }

    @Deprecated
    public Calendar getUsageStartTime() {
        long millis = (Long)this.resourceProperties.get(USAGE_START_TIME);
        return this.timestampStringToCalendar(millis);
    }

    @Deprecated
    public void setUsageStartTime(Calendar usageStartTime) throws InvalidValueException {
        this.setResourceProperty(USAGE_START_TIME, Long.valueOf(usageStartTime.getTimeInMillis()));
    }

    @Deprecated
    public Calendar getUsageEndTime() {
        long millis = (Long)this.resourceProperties.get(USAGE_END_TIME);
        return this.timestampStringToCalendar(millis);
    }

    @Deprecated
    public void setUsageEndTime(Calendar usageEndTime) throws InvalidValueException {
        this.setResourceProperty(USAGE_END_TIME, Long.valueOf(usageEndTime.getTimeInMillis()));
    }

    public Calendar getTaskStartTime() {
        long millis = (Long)this.resourceProperties.get(TASK_START_TIME);
        return this.timestampStringToCalendar(millis);
    }

    public void setTaskStartTime(Calendar startTime) throws InvalidValueException {
        this.setResourceProperty(TASK_START_TIME, Long.valueOf(startTime.getTimeInMillis()));
    }

    public Calendar getTaskEndTime() {
        long millis = (Long)this.resourceProperties.get(TASK_END_TIME);
        return this.timestampStringToCalendar(millis);
    }

    public void setTaskEndTime(Calendar endTime) throws InvalidValueException {
        this.setResourceProperty(TASK_END_TIME, Long.valueOf(endTime.getTimeInMillis()));
    }

    @Deprecated
    public int getInputFilesNumber() {
        return (Integer)this.resourceProperties.get(INPUT_FILES_NUMBER);
    }

    @Deprecated
    public void setInputFilesNumber(int inputFilesNumber) throws InvalidValueException {
        this.setResourceProperty(INPUT_FILES_NUMBER, Integer.valueOf(inputFilesNumber));
    }

    @Deprecated
    public long getInputFilesSize() {
        return (Long)this.resourceProperties.get(INPUT_FILES_SIZE);
    }

    @Deprecated
    public void setInputFilesSize(long inputFilesSize) throws InvalidValueException {
        this.setResourceProperty(INPUT_FILES_SIZE, Long.valueOf(inputFilesSize));
    }

    @Deprecated
    public int getOutputFilesNumber() {
        return (Integer)this.resourceProperties.get(OUTPUT_FILES_NUMBER);
    }

    @Deprecated
    public void setOutputFilesNumber(int outputFilesNumber) throws InvalidValueException {
        this.setResourceProperty(OUTPUT_FILES_NUMBER, Integer.valueOf(outputFilesNumber));
    }

    @Deprecated
    public long getOutputFilesSize() {
        return (Long)this.resourceProperties.get(OUTPUT_FILES_SIZE);
    }

    @Deprecated
    public void setOutputFilesSize(long outputFilesSize) throws InvalidValueException {
        this.setResourceProperty(OUTPUT_FILES_SIZE, Long.valueOf(outputFilesSize));
    }

    @Deprecated
    public long getOverallNetworkIn() {
        return (Long)this.resourceProperties.get(OVERALL_NETWORK_IN);
    }

    @Deprecated
    public void setOverallNetworkIn(long overallNetworkIn) throws InvalidValueException {
        this.setResourceProperty(OVERALL_NETWORK_IN, Long.valueOf(overallNetworkIn));
    }

    @Deprecated
    public long getOverallNetworkOut() {
        return (Long)this.resourceProperties.get(OVERALL_NETWORK_OUT);
    }

    @Deprecated
    public void setOverallNetworkOut(long overallNetworkOut) throws InvalidValueException {
        this.setResourceProperty(OVERALL_NETWORK_OUT, Long.valueOf(overallNetworkOut));
    }

    @Deprecated
    public int getCores() {
        return (Integer)this.resourceProperties.get(CORES);
    }

    @Deprecated
    public void setCores(int cores) throws InvalidValueException {
        this.setResourceProperty(CORES, Integer.valueOf(cores));
    }

    @Deprecated
    public int getProcessors() {
        return (Integer)this.resourceProperties.get(PROCESSORS);
    }

    @Deprecated
    public void setProcessors(int processors) throws InvalidValueException {
        this.setResourceProperty(PROCESSORS, Integer.valueOf(processors));
    }
}

