/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.accounting.datamodel.validations.validators;

import java.io.Serializable;
import org.gcube.accounting.datamodel.UsageRecord;
import org.gcube.accounting.datamodel.basetypes.AbstractStorageUsageRecord;
import org.gcube.accounting.datamodel.decorators.FieldAction;
import org.gcube.accounting.datamodel.validations.validators.ValidLongValidator;
import org.gcube.accounting.datamodel.validations.validators.ValidOperationTypeValidator;
import org.gcube.accounting.exception.InvalidValueException;

public class FixDataVolumeSignAction
implements FieldAction {
    protected Long checkIt(Long dataVolume, AbstractStorageUsageRecord.OperationType operationType) {
        switch (operationType) {
            case CREATE: {
                dataVolume = dataVolume > 0L ? dataVolume : -dataVolume.longValue();
                break;
            }
            case READ: {
                dataVolume = dataVolume > 0L ? dataVolume : -dataVolume.longValue();
                break;
            }
            case UPDATE: {
                break;
            }
            case DELETE: {
                dataVolume = dataVolume < 0L ? dataVolume : -dataVolume.longValue();
                break;
            }
        }
        return dataVolume;
    }

    @Override
    public Serializable validate(String key, Serializable value, UsageRecord usageRecord) throws InvalidValueException {
        try {
            Long dataVolume;
            AbstractStorageUsageRecord.OperationType operationType;
            if (key.compareTo("dataVolume") == 0 && (operationType = (AbstractStorageUsageRecord.OperationType)((Object)usageRecord.getResourceProperty("operationType"))) != null) {
                ValidLongValidator validLongValidator = new ValidLongValidator();
                value = validLongValidator.validate(key, value, usageRecord);
                Long dataVolume2 = new Long((Long)value);
                value = this.checkIt(dataVolume2, operationType);
            }
            if (key.compareTo("operationType") == 0 && (dataVolume = (Long)usageRecord.getResourceProperty("dataVolume")) != null) {
                ValidOperationTypeValidator v = new ValidOperationTypeValidator();
                value = v.validate(key, value, usageRecord);
                AbstractStorageUsageRecord.OperationType operationType2 = (AbstractStorageUsageRecord.OperationType)((Object)value);
                Long newDataVolume = this.checkIt(dataVolume, operationType2);
                usageRecord.setResourceProperty("dataVolume", newDataVolume);
            }
        }
        catch (InvalidValueException e) {
            // empty catch block
        }
        return value;
    }
}

